<?php
/**
 * Admin Settings Page Template
 * 
 * Available variables:
 * @var array $options Current plugin options
 * @var string $page_title Page title
 * @var array $form_fields Form fields configuration
 */

// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped

if (!defined('ABSPATH'))
    exit;
?>

<?php
// Display success/error messages
if (isset($_GET['settings-updated']) && $_GET['settings-updated'] === 'true') {
    echo '<div class="notice notice-success is-dismissible"><p><strong>Settings saved successfully!</strong></p></div>';
}

if (isset($_GET['error']) && $_GET['error'] === 'api-failed') {
    echo '<div class="notice notice-error is-dismissible"><p><strong>Error:</strong> Failed to save the settings. Please try again.</p></div>';
}
?>

<?php if (isset($_GET['has_token']) && $_GET['has_token'] === 'false'): ?>
    <div class="notice notice-warning is-dismissible">
        <p>
            <strong><?php esc_html_e('Warning:', 'einvoiceapp-malaysia'); ?></strong>
            <?php esc_html_e('It seem like you have not yet submit your company information. Please submit your company information first before proceeding.', 'einvoiceapp-malaysia'); ?>
        </p>
    </div>
<?php endif; ?>

<?php if (!empty($error_message)): ?>
    <div class="notice notice-error is-dismissible">
        <p><?php echo wp_kses($error_message, ['br' => [], 'strong' => [], 'ul' => [], 'li' => []]); ?></p>
    </div>
<?php endif; ?>

<?php echo show_subscription_warning($subscription_url); ?>

<div class="wrap e-invoice-settings">
    <h1><?php echo esc_html($page_title); ?></h1>
    <br />

    <div style="display: flex; align-items: flex-start; gap: 10px;">
        <div style="width: 35%;">
            <div class="o2oeinvoice-panel">
                <div class="panel-header">
                    <h2 class="panel-title"><?php esc_html_e('Subscription Information', 'einvoiceapp-malaysia'); ?></h2>
                </div>

                <div class="panel-body">
                    <h3><?php esc_html_e('Welcome back,', 'einvoiceapp-malaysia'); ?> <?php echo esc_html($site_name); ?> <?php echo '(' . esc_html($statuses[$module_status]['text']) . ')'; ?></h3>

                    <?php if (!$is_subscription_active): ?>
                        <p>
                            <?php esc_html_e('You required subscription to use this plugin. Please subscribe to the plugin to continue.', 'einvoiceapp-malaysia'); ?><br>
                            <?php esc_html_e('You may click the button below to subscribe to the plugin.', 'einvoiceapp-malaysia'); ?><br />
                            <br />
                            <a target="_blank" href="<?php echo esc_url($subscription_url); ?>" class="button button-subscription"><?php esc_html_e('Subscribe', 'einvoiceapp-malaysia'); ?></a>
                        </p>
                    <?php elseif ($is_subscription_active && $subscription_details['is_in_trial']): ?>
                        <p>
                            <?php esc_html_e('You are currently in trial period.', 'einvoiceapp-malaysia'); ?><br>
                            <?php esc_html_e('You have', 'einvoiceapp-malaysia'); ?> <strong><?php echo esc_html($subscription_details['trail_remaining_days']); ?></strong> <?php esc_html_e('days left in your trial period.', 'einvoiceapp-malaysia'); ?><br>
                            <?php esc_html_e('Your trial will expire on', 'einvoiceapp-malaysia'); ?> <strong><?php echo esc_html($subscription_details['expire_date']); ?></strong>.
                        </p>
                    <?php else: ?>
                        <p>
                            <?php esc_html_e('You are currently subscribed to the plugin.', 'einvoiceapp-malaysia'); ?><br>
                            <?php if (!empty($subscription_details)): ?>
                                <?php esc_html_e('Your subscription plan is', 'einvoiceapp-malaysia'); ?> <strong><?php echo esc_html($subscription_details['package_plan']); ?></strong><br>
                                <?php esc_html_e('Your subscription will expire on', 'einvoiceapp-malaysia'); ?> <strong><?php echo esc_html($subscription_details['expire_date']); ?></strong>.
                            <?php endif; ?>
                        </p>
                    <?php endif; ?>
                </div>
            </div>

            <div class="o2oeinvoice-panel">
                <div class="panel-header">
                    <h2 class="panel-title"><?php esc_html_e('Useful Resources', 'einvoiceapp-malaysia'); ?></h2>
                </div>

                <div class="panel-body">
                    <ul style="list-style: disc; margin-left: 20px;">
                        <li>
                            <a href="<?php echo esc_url($config['user_guide_url']); ?>" target="_blank"><?php esc_html_e('App User Guide', 'einvoiceapp-malaysia'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo esc_url($config['faq_url']); ?>" target="_blank"><?php esc_html_e('App FAQ', 'einvoiceapp-malaysia'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo esc_url($config['official_mytax_site_url']); ?>" target="_blank"><?php esc_html_e('Official MyTax Site', 'einvoiceapp-malaysia'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo esc_url($config['official_lhdn_faq_site_url']); ?>" target="_blank"><?php esc_html_e('Official LHDN FAQ', 'einvoiceapp-malaysia'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo esc_url($config['privacy_policy_url']); ?>" target="_blank"><?php esc_html_e('Privacy Policy', 'einvoiceapp-malaysia'); ?></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div style="width: 65%;">
            <!-- MyInvois Environment -->
            <div class="o2oeinvoice-panel">
                <div class="panel-header">
                    <h2 class="panel-title"><?php esc_html_e('MyInvois Environment', 'einvoiceapp-malaysia'); ?></h2>
                </div>

                <div class="panel-body">
                    <div class="alert alert-info">
                        <?php esc_html_e('Please pick the environment and save first, as this will refresh the application to use the respective environment.', 'einvoiceapp-malaysia'); ?>
                    </div>

                    <form action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="post">
                        <input type="hidden" name="action" value="einvappmy_save_settings">
                        <input type="hidden" name="nonce" value="<?php echo esc_attr(wp_create_nonce('einvappmy_save_settings')); ?>">
                        <input type="hidden" name="save_action" value="environment">

                        <table class="form-table">
                            <tbody>
                                <tr>
                                    <th scope="row"><?php esc_html_e('MyInvois Environment', 'einvoiceapp-malaysia'); ?></th>
                                    <td>
                                        <select name="einvappmy_options[status]" id="einvappmy_options[status]">
                                            <?php foreach ($statuses as $status): ?>
                                                <?php $selected = (!empty($options['status']) && $options['status'] == $status['value']) ? 'selected' : ''; ?>
                                                <option value="<?php echo esc_attr($status['value']); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($status['text']); ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </td>
                                </tr>

                                <tr>
                                    <th scope="row">
                                        <input type="submit" class="button button-primary" value="Save">
                                    </th>
                                </tr>
                            </tbody>
                        </table>
                    </form>
                </div>
            </div>

            <!-- Company Information -->
            <div class="o2oeinvoice-panel">
                <div class="panel-body">
                    <div style="margin-top: 10px;">
                        <span class="badge" style="background-color: <?php echo esc_attr($statuses[$module_status]['style']['background_color']); ?>; color: <?php echo esc_attr($statuses[$module_status]['style']['color']); ?>;"><?php echo esc_html($statuses[$module_status]['text']); ?></span>
                    </div>

                    <p><?php esc_html_e('Please fill in these information to get started:', 'einvoiceapp-malaysia'); ?></p>

                    <div class="alert alert-info">
                        <?php esc_html_e('All these information will be collected and be used to send the e‑invoice request to LHDN.', 'einvoiceapp-malaysia'); ?><br />
                        <?php echo wp_kses(__('So please make sure the <strong>information submitted is accurate</strong>. We are not responsible if the information is not accurate.', 'einvoiceapp-malaysia'), ['strong' => []]); ?><br />
                        <br />
                        <?php echo wp_kses(__('Even in Staging/Sandbox/Testing environment, the information submitted will be used to send the e‑invoice request to LHDN. '), ['strong' => []]); ?><br />
                        <?php echo wp_kses(__('ERP keys, TIN, company identification type and value will still need to be validly obtained from the MyInvois (Testing) Portal.'), ['strong' => []]); ?>
                    </div>

                    <form action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="post">
                        <input type="hidden" name="action" value="einvappmy_save_settings">
                        <input type="hidden" name="nonce" value="<?php echo esc_attr(wp_create_nonce('einvappmy_save_settings')); ?>">
                        <input type="hidden" name="save_action" value="company_information">
                        <input type="hidden" name="einvappmy_options[myinvois_token]" value="<?php echo esc_attr($myinvois_token ?? ''); ?>" />
                        <input type="hidden" name="einvappmy_options[name]" value="<?php echo esc_attr($site_name ?? ''); ?>" />
                        <input type="hidden" name="einvappmy_options[site_domain]" id="site_domain" value="<?php echo esc_attr($site_domain ?? ''); ?>" />
                        <input type="hidden" name="einvappmy_options[admin_code]" id="admin_code" value="o2oecommerce" />

                        <table class="form-table">
                            <!-- MyInvois ID -->
                            <tr>
                                <th scope="row">
                                    <label for="myinvois_id">MyInvois ID</label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['myinvois_id']) ? $client_details['myinvois_id'] : (!empty($form_post_data['myinvois_id']) ? $form_post_data['myinvois_id'] : ''); ?>
                                    <input type="text" id="myinvois_id" name="einvappmy_options[myinvois_id]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>

                            <!-- MyInvois Secret -->
                            <tr>
                                <th scope="row">
                                    <label for="myinvois_secret">MyInvois Secret</label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['myinvois_secret']) ? $client_details['myinvois_secret'] : (!empty($form_post_data['myinvois_secret']) ? $form_post_data['myinvois_secret'] : ''); ?>
                                    <input type="text" id="myinvois_secret" name="einvappmy_options[myinvois_secret]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>
                        </table>

                        <hr />

                        <table class="form-table">
                            <!-- Company Name -->
                            <tr>
                                <th scope="row">
                                    <label for="company_name">Company Name</label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['company_name']) ? $client_details['company_name'] : (!empty($form_post_data['company_name']) ? $form_post_data['company_name'] : ''); ?>
                                    <input type="text" id="company_name" name="einvappmy_options[company_name]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>
                            <!-- Email -->
                            <tr>
                                <th scope="row">
                                    <label for="email"><?php esc_html_e('Company Email', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['email']) ? $client_details['email'] : (!empty($form_post_data['email']) ? $form_post_data['email'] : ''); ?>
                                    <input type="email" id="email" name="einvappmy_options[email]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>

                            <!-- Telephone -->
                            <tr>
                                <th scope="row">
                                    <label for="telephone"><?php esc_html_e('Company Telephone', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['telephone']) ? $client_details['telephone'] : (!empty($form_post_data['telephone']) ? $form_post_data['telephone'] : ''); ?>
                                    <input type="text" id="telephone" name="einvappmy_options[telephone]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>
                        </table>

                        <hr />

                        <table class="form-table">
                            <!-- Company TIN -->
                            <tr>
                                <th scope="row">
                                    <label for="company_tin"><?php esc_html_e('Company TIN', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['company_tin']) ? $client_details['company_tin'] : (!empty($form_post_data['company_tin']) ? $form_post_data['company_tin'] : ''); ?>
                                    <input type="text" id="company_tin" name="einvappmy_options[company_tin]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>

                            <!-- Company Identification Type -->
                            <tr>
                                <th scope="row">
                                    <label for="company_identification_type"><?php esc_html_e('Company Identification Type', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <select name="einvappmy_options[company_identification_type]" id="company_identification_type">
                                        <?php foreach ($identification_types as $type): ?>
                                            <?php $selected = (!empty($client_details['company_identification_type']) && $client_details['company_identification_type'] == $type['value']) ? 'selected' : ''; ?>
                                            <option value="<?php echo esc_attr($type['value']); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($type['text']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>

                            <tr>
                                <td colspan="2">
                                    <div class="alert alert-info" id="company_identification_type_info">
                                        <?php foreach ($identification_types as $type): ?>
                                            <p class="d-none company_identification_type_info_<?php echo esc_attr($type['value']); ?>">
                                                <strong><?php echo esc_html($type['help']['title']); ?></strong><br />
                                                <?php echo esc_html($type['help']['description']); ?>
                                            </p>
                                        <?php endforeach; ?>
                                    </div>
                                </td>
                            </tr>

                            <!-- Company Identification Value -->
                            <tr>
                                <th scope="row">
                                    <label for="company_identification_value">Company Identification Value</label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['company_identification_value']) ? $client_details['company_identification_value'] : (!empty($form_post_data['company_identification_value']) ? $form_post_data['company_identification_value'] : ''); ?>
                                    <input type="text" id="company_identification_value" name="einvappmy_options[company_identification_value]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>

                            <!-- Company SST -->
                            <tr>
                                <th scope="row">
                                    <label for="company_sst"><?php esc_html_e('Company SST (if any)', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['company_sst']) ? $client_details['company_sst'] : (!empty($form_post_data['company_sst']) ? $form_post_data['company_sst'] : ''); ?>
                                    <input type="text" id="company_sst" name="einvappmy_options[company_sst]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>

                            <!-- Company TTX -->
                            <tr>
                                <th scope="row">
                                    <label for="company_ttx"><?php esc_html_e('Company TTX (if any)', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['company_ttx']) ? $client_details['company_ttx'] : (!empty($form_post_data['company_ttx']) ? $form_post_data['company_ttx'] : ''); ?>
                                    <input type="text" id="company_ttx" name="einvappmy_options[company_ttx]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>
                        </table>

                        <hr />

                        <table class="form-table">
                            <!-- Address 1 -->
                            <tr>
                                <th scope="row">
                                    <label for="address_1"><?php esc_html_e('Company Address 1', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['address1']) ? $client_details['address1'] : (!empty($form_post_data['address_1']) ? $form_post_data['address_1'] : ''); ?>
                                    <input type="text" id="address_1" name="einvappmy_options[address_1]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>

                            <!-- Address 2 -->
                            <tr>
                                <th scope="row">
                                    <label for="address_2"><?php esc_html_e('Company Address 2', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['address2']) ? $client_details['address2'] : (!empty($form_post_data['address_2']) ? $form_post_data['address_2'] : ''); ?>
                                    <input type="text" id="address_2" name="einvappmy_options[address_2]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>

                            <!-- City -->
                            <tr>
                                <th scope="row">
                                    <label for="city"><?php esc_html_e('Company City', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['city']) ? $client_details['city'] : (!empty($form_post_data['city']) ? $form_post_data['city'] : ''); ?>
                                    <input type="text" id="city" name="einvappmy_options[city]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>

                            <!-- Postcode -->
                            <tr>
                                <th scope="row">
                                    <label for="postcode"><?php esc_html_e('Company Postal Code', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <?php $input_value = !empty($client_details['postcode']) ? $client_details['postcode'] : (!empty($form_post_data['postcode']) ? $form_post_data['postcode'] : ''); ?>
                                    <input type="text" id="postcode" name="einvappmy_options[postcode]" value="<?php echo esc_attr($input_value); ?>" class="regular-text" />
                                </td>
                            </tr>

                            <!-- State -->
                            <tr>
                                <th scope="row">
                                    <label for="state"><?php esc_html_e('Company State', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <select name="einvappmy_options[state]" id="state">
                                        <?php foreach ($states as $key => $state): ?>
                                            <?php $selected = $selected_state == $key ? 'selected' : ''; ?>
                                            <option value="<?php echo esc_attr($state['value']); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($state['label']); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>

                            <!-- Country -->
                            <tr>
                                <th scope="row">
                                    <label for="country"><?php esc_html_e('Company Country', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <select name="einvappmy_options[country]" id="country">
                                        <?php foreach ($countries as $key => $country): ?>
                                            <?php $selected = $selected_country == $key ? 'selected' : ''; ?>
                                            <option value="<?php echo esc_attr($key); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($country); ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>
                        </table>

                        <hr />

                        <table class="form-table">
                            <!-- Classification Name -->
                            <tr>
                                <th scope="row">
                                    <label for="classification_name"><?php esc_html_e('Company Industry', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <select name="einvappmy_options[classification_name]" id="classification_selector"></select>

                                    <input style="display:none;" readonly type="text" name="einvappmy_options[classification_name]" value="<?php echo esc_attr($client_details['classification_name'] ?? ''); ?>" id="classification_name" required />
                                    <input style="display:none;" readonly type="text" name="einvappmy_options[classification_code]" value="<?php echo esc_attr($client_details['classification_code'] ?? ''); ?>" id="classification_code" required />
                                </td>
                            </tr>
                        </table>

                        <hr>

                        <table class="form-table">
                            <!-- Submit Method -->
                            <tr>
                                <th scope="row">
                                    <label for="submit_method"><?php esc_html_e('Submit Method', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <?php foreach ($submit_methods as $method): ?>
                                        <?php $checked = ($client_details['submit_method'] ?? '') == $method['value'] ? 'checked' : ''; ?>
                                        <div style="margin-bottom: 10px;">
                                            <input type="radio" name="einvappmy_options[submit_method]" value="<?php echo esc_attr($method['value']); ?>" <?php echo esc_attr($checked); ?> id="submit_method_<?php echo esc_attr($method['value']); ?>">
                                            <label for="submit_method_<?php echo esc_attr($method['value']); ?>">
                                                <?php echo esc_html($method['text']); ?><br />
                                                <small style="padding-left: 24px;" class="text-muted"><?php echo esc_html($method['help_text']); ?></small>
                                            </label>
                                        </div>
                                    <?php endforeach; ?>
                                </td>
                            </tr>
                        </table>

                        <hr>

                        <div class="alert alert-info">
                            <strong><?php esc_html_e('Helpline (Optional)', 'einvoiceapp-malaysia'); ?></strong><br/>
                            <?php esc_html_e('Please provide your helpline email and phone number if you want your customer to contact you for any enquiries during the e-invoice submission form.', 'einvoiceapp-malaysia'); ?><br />
                        </div>

                        <table class="form-table">
                            <!-- Helpline Email -->
                            <tr>
                                <th scope="row">
                                    <label for="helpline_email"><?php esc_html_e('Helpline Email', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <?php
                                        $input_value = !empty($client_details['helpline_email']) ? $client_details['helpline_email'] : (!empty($form_post_data['helpline_email']) ? $form_post_data['helpline_email'] : '');

                                        $input_class = 'regular-text';
                                        if (in_array('helpline_email', $error_fields, true)) {
                                            $input_class .= ' einvappmy-input-error';
                                        }
                                    ?>
                                    <input type="email" id="helpline_email" name="einvappmy_options[helpline_email]" value="<?php echo esc_attr($input_value); ?>" class="<?php echo esc_attr($input_class); ?>" />
                                </td>
                            </tr>

                            <!-- Helpline Phone -->
                            <tr>
                                <th scope="row">
                                    <label for="helpline_phone"><?php esc_html_e('Helpline Phone', 'einvoiceapp-malaysia'); ?></label>
                                </th>
                                <td>
                                    <?php
                                        $input_value = !empty($client_details['helpline_phone']) ? $client_details['helpline_phone'] : (!empty($form_post_data['helpline_phone']) ? $form_post_data['helpline_phone'] : '');
                                        
                                        $input_class = 'regular-text';
                                        if (in_array('helpline_phone', $error_fields, true)) {
                                            $input_class .= ' einvappmy-input-error';
                                        }
                                    ?>
                                    <input type="text" id="helpline_phone" name="einvappmy_options[helpline_phone]" value="<?php echo esc_attr($input_value); ?>" class="<?php echo esc_attr($input_class); ?>" />
                                </td>
                            </tr>
                        </table>

                        <hr />

                        <table class="form-table">
                            <tr>
                                <th scope="row">
                                    <input type="submit" class="button button-primary" value="Submit">
                                </th>
                            </tr>
                        </table>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>