<?php

if (!defined('ABSPATH')) {
    exit;
}

?>

<?php if (!empty($success_message)): ?>
    <div class="notice notice-success is-dismissible">
        <p><?php echo esc_html($success_message); ?></p>
    </div>
<?php endif; ?>

<?php if (!empty($error_message)): ?>
    <div class="notice notice-error is-dismissible">
        <p><?php echo esc_html($error_message); ?></p>
    </div>
<?php endif; ?>

<div class="wrap einvoice-notes">
    <h1><?php echo esc_html($page_title); ?></h1>
    <br>

    <div class="o2oeinvoice-panel">
        <div class="panel-header">
            <h2 class="panel-title"><?php esc_html_e('Filter', 'einvoiceapp-malaysia'); ?></h2>
        </div>

        <div class="panel-body">
            <form action="<?php echo esc_url(admin_url('admin.php?page=einvappmy-einvoice-notes')); ?>" method="get">
                <div style="display: flex; gap: 10px; align-items: flex-start;">
                    <input type="hidden" name="tab" value="<?php echo esc_attr($active_tab); ?>">
                    <input type="hidden" name="page" value="einvappmy-einvoice-notes">
                    <input type="hidden" name="status_tab" value="<?php echo esc_attr($status_active_tab); ?>">
                    <input type="hidden" name="nonce" value="<?php echo esc_attr(wp_create_nonce('einvappmy_notes_page')); ?>">

                    <div>
                        <label for="filter_date_start"><?php esc_html_e('Date Start', 'einvoiceapp-malaysia'); ?></label><br>
                        <input type="date" name="filter_date_start" value="<?php echo esc_attr($filter_date_start); ?>">
                    </div>

                    <div>
                        <label for="filter_date_end"><?php esc_html_e('Date End', 'einvoiceapp-malaysia'); ?></label><br>
                        <input type="date" name="filter_date_end" value="<?php echo esc_attr($filter_date_end); ?>">
                    </div>
                </div>

                <div style="margin-top: 10px; display: flex; gap: 10px; align-items: flex-start;">
                    <div>
                        <button class="button button-primary" type="submit"><?php esc_html_e('Filter', 'einvoiceapp-malaysia'); ?></button>
                        <button id="button-clear-filter" class="button button-secondary"><?php esc_html_e('Clear', 'einvoiceapp-malaysia'); ?></button>
                    </div>

                    <div style="flex: 1; text-align: right;">
                        <a href="<?php echo esc_url($link_export); ?>" class="button button-secondary"><?php esc_html_e('Export', 'einvoiceapp-malaysia'); ?></a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <h2 class="nav-tab-wrapper">
        <?php foreach ($notes_types as $note_type_value => $note_type_properties): ?>
            <?php $active_tab_class = $note_type_value == $active_tab ? 'nav-tab-active' : ''; ?>
            <a href="<?php echo esc_url($note_type_properties['url']); ?>" class="nav-tab <?php echo esc_attr($active_tab_class); ?>"><?php echo esc_html($note_type_properties['text']); ?></a>
        <?php endforeach; ?>
    </h2>

    <br>

    <div class="o2oeinvoice-panel">
        <div class="panel-body">
            <h2 class="nav-tab-wrapper">
                <?php foreach ($note_statuses as $status_value => $status_properties): ?>
                    <?php $active_tab_class = $status_value == $status_active_tab ? 'nav-tab-active' : ''; ?>
                    <a href="<?php echo esc_url($status_properties['url']); ?>" class="nav-tab <?php echo esc_attr($active_tab_class); ?>"><?php echo esc_html($status_properties['text']); ?></a>
                <?php endforeach; ?>
            </h2>

            <br>

            <table class="wp-list-table widefat fixed striped posts">
                <thead>
                    <tr>
                        <td><?php esc_html_e('Order', 'einvoiceapp-malaysia'); ?></td>
                        <td><?php esc_html_e('Original Order E-Invoice', 'einvoiceapp-malaysia'); ?></td>
                        <td><?php esc_html_e('Created Date', 'einvoiceapp-malaysia'); ?></td>
                        <td><?php esc_html_e('Customer', 'einvoiceapp-malaysia'); ?></td>
                        <td class="ta-right"><?php esc_html_e('Total', 'einvoiceapp-malaysia'); ?></td>
                        <td><?php esc_html_e('Validated Note', 'einvoiceapp-malaysia'); ?></td>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($note_list)): ?>
                        <?php foreach ($note_list as $note): ?>
                            <tr>
                                <td>
                                    <strong><a href="<?php echo esc_url($note['order_info_url']); ?>" target="_blank"><?php echo esc_html($note['order_id']); ?></a></strong>
                                </td>
                                <td>
                                    <?php if (!empty($note['original_invoice_validation_url'])): ?>
                                        <strong><a href="<?php echo esc_url($note['original_invoice_validation_url']); ?>" target="_blank"><?php echo esc_html($note['original_invoice_uuid']); ?></a></strong>
                                    <?php else: ?>
                                        <?php echo esc_html($note['original_invoice_uuid']); ?>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo esc_html($note['date_created']); ?></td>
                                <td><?php echo esc_html($note['customer_name']); ?></td>
                                <td class="ta-right"><?php echo esc_html($note['total_amount_text']); ?></td>
                                <td>
                                    <?php if (!empty($note['validation_url'])): ?>
                                        <strong><a href="<?php echo esc_url($note['validation_url']); ?>" target="_blank"><?php echo esc_html($note['uuid']); ?></a></strong>
                                    <?php else: ?>
                                        <?php echo esc_html($note['uuid']); ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>