<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<?php if (!empty($success_message)): ?>
    <div class="notice notice-success is-dismissible">
        <p><?php echo esc_html($success_message); ?></p>
    </div>
<?php endif; ?>

<?php if (!empty($error_message)): ?>
    <div class="notice notice-error is-dismissible">
        <p><?php echo esc_html($error_message); ?></p>
    </div>
<?php endif; ?>

<div class="wrap einvoice-logs">
    <h1><?php echo esc_html($page_title); ?></h1>
    <br>

    <div class="o2oeinvoice-panel">
        <div class="panel-header">
            <h2 class="panel-title"><?php echo esc_html($log_filename); ?></h2>
        </div>

        <div class="panel-body">
            <?php if (empty($log_histories)): ?>
                <div class="no-logs-message">
                    <p>
                        <span class="dashicons dashicons-info"></span><br>
                        <?php esc_html_e('No log entries found.', 'einvoiceapp-malaysia'); ?>
                    </p>
                </div>
            <?php else: ?>
                <!-- Log Controls -->
                <div class="log-controls">
                    <div class="log-filters">
                        <label for="log-level-filter">Filter by level:</label>
                        <select id="log-level-filter">
                            <option value="all">All Levels</option>
                            <option value="INFO">Info</option>
                            <option value="WARNING">Warning</option>
                            <option value="ERROR">Error</option>
                        </select>
                        <input type="text" id="log-search" placeholder="Search logs...">
                    </div>
                    <div class="log-actions">
                        <span class="log-count">Showing <strong id="visible-count"><?php echo count($log_histories); ?></strong> of <strong><?php echo count($log_histories); ?></strong> entries</span>
                        <button type="button" class="button" id="refresh-logs">
                            <span class="dashicons dashicons-update"></span> Refresh
                        </button>
                        <button type="button" class="button button-secondary" id="clear-logs">
                            <span class="dashicons dashicons-trash"></span> Clear Logs
                        </button>
                    </div>
                </div>

                <!-- Log Table -->
                <div class="log-table-wrapper">
                    <table class="wp-list-table widefat fixed striped" id="log-table">
                        <thead>
                            <tr>
                                <th class="log-col-timestamp">Timestamp</th>
                                <th class="log-col-level">Level</th>
                                <th>Message</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($log_histories as $log): ?>
                                <tr class="log-entry" data-level="<?php echo esc_attr($log['level']); ?>">
                                    <td class="log-timestamp">
                                        <span class="dashicons dashicons-clock"></span>
                                        <?php echo esc_html($log['timestamp']); ?>
                                    </td>
                                    <td class="log-level">
                                        <span class="log-badge log-badge-<?php echo strtolower(esc_attr($log['level'])); ?>">
                                            <?php echo esc_html($log['level']); ?>
                                        </span>
                                    </td>
                                    <td class="log-message">
                                        <code>
                                            <?php echo esc_html($log['message']); ?>
                                        </code>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>