<?php
/**
 * Admin Settings Page Template
 * 
 * Available variables:
 * @var array $options Current plugin options
 * @var string $page_title Page title
 * @var array $form_fields Form fields configuration
 */

if (!defined('ABSPATH'))
    exit;
?>

<div class="wrap">
    <div class="heading">
        <h1><?php echo esc_html($page_title); ?></h1>

        <?php if (empty($myinvois_token)): ?>
            <div class="notice notice-warning">
                <p>You have not setup yet, please go to the setup page first.</p>
            </div>
        <?php endif; ?>
    </div>

    <div class="content">
        <div class="notice">
            <p>All the figure data below is divided in e-invoice order amount and counts being updated on our system.</p>
        </div>

        <form action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="post" enctype="multipart/form-data" id="form">
            <input type="hidden" name="action" value="einvappmy_listing_submit">

            <?php $today = date('Y-m-d'); ?>
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th class="text-align-left"><?php esc_html_e('Date', 'einvoiceapp-malaysia'); ?></th>
                        <th class="text-align-right"><?php esc_html_e('Orders', 'einvoiceapp-malaysia'); ?></th>
                        <th class="text-align-right"><?php esc_html_e('Created', 'einvoiceapp-malaysia'); ?></th>
                        <th class="text-align-right"><?php esc_html_e('Submitted', 'einvoiceapp-malaysia'); ?></th>
                        <th class="text-align-right"><?php esc_html_e('Validated', 'einvoiceapp-malaysia'); ?></th>
                        <th class="text-align-right"><?php esc_html_e('Invalid', 'einvoiceapp-malaysia'); ?></th>
                        <th class="text-align-right"><?php esc_html_e('Cancelled', 'einvoiceapp-malaysia'); ?></th>
                    </tr>
                </thead>

                <?php if (isset($summary_data['current_month'])): ?>
                    <tbody>
                        <tr>
                            <td colspan="7" style="background-color:#ddd!important"><?php echo esc_html($summary_data['current_month']['title']); ?></td>
                        </tr>
                        <?php foreach ($summary_data['current_month']['orders'] ?? [] as $day): ?>
                            <tr class="clickable" onclick="toggleOrderDetails(this)">
                                <td>
                                    <?php echo esc_html($day['date']); ?> <strong><?php if ($day['date'] == $today) {
                                            echo '(Today)';
                                        } ?></strong>
                                </td>

                                <td class="text-align-right">
                                    <?php $sameDayKey = array_search($day['date'], array_column($store_orders_data['current_month']['orders'], 'date')); ?>

                                    <?php if ($sameDayKey !== false): ?>
                                        <?php $sameDayOrders = $store_orders_data['current_month']['orders'][$sameDayKey]; ?>

                                        RM <?php echo number_format($sameDayOrders['total'], 2); ?> | <?php echo esc_html($sameDayOrders['count']); ?>
                                    <?php else: ?>
                                        RM 0 | 0
                                    <?php endif; ?>
                                </td>

                                <td class="text-align-right">
                                    RM <?php echo number_format($day['created']['amount'], 2); ?> | <?php echo esc_html($day['created']['count']); ?>
                                </td>

                                <td class="text-align-right">
                                    RM <?php echo number_format($day['submitted']['amount'], 2); ?> | <?php echo esc_html($day['submitted']['count']); ?>
                                </td>

                                <td class="text-align-right">
                                    RM <?php echo number_format($day['validated']['amount'], 2); ?> | <?php echo esc_html($day['validated']['count']); ?>
                                </td>
                                <td class="text-align-right">
                                    RM <?php echo number_format($day['invalid']['amount'], 2); ?> | <?php echo esc_html($day['invalid']['count']); ?>
                                </td>
                                <td class="text-align-right">
                                    RM <?php echo number_format($day['cancelled']['amount'], 2); ?> | <?php echo esc_html($day['cancelled']['count']); ?>
                                </td>
                            </tr>

                            <tr class="order-details">
                                <td></td>
                                <td></td>

                                <td class="text-align-right">
                                    <?php if (!empty($day['created']['order_ids'])) { ?>
                                        <?php foreach ($day['created']['order_ids'] as $order_id) { ?>
                                            <a target="_blank" href="<?php echo esc_url(admin_url('post.php?action=edit&post=' . $order_id)); ?>" class="order-link"><?php echo esc_html($order_id); ?></a>
                                        <?php } ?>
                                    <?php } ?>
                                </td>

                                <td class="text-align-right">
                                    <?php if (!empty($day['submitted']['order_ids'])) { ?>
                                        <?php foreach ($day['submitted']['order_ids'] as $order_id) { ?>
                                            <a target="_blank" href="<?php echo esc_url(admin_url('post.php?action=edit&post=' . $order_id)); ?>" class="order-link"><?php echo esc_html($order_id); ?></a>
                                        <?php } ?>
                                    <?php } ?>
                                </td>

                                <td class="text-align-right">
                                    <?php if (!empty($day['validated']['order_ids'])) { ?>
                                        <?php foreach ($day['validated']['order_ids'] as $order_id) { ?>
                                            <a target="_blank" href="<?php echo esc_url(admin_url('post.php?action=edit&post=' . $order_id)); ?>" class="order-link"><?php echo esc_html($order_id); ?></a>
                                        <?php } ?>
                                    <?php } ?>
                                </td>

                                <td align="right">
                                    <?php if (!empty($day['invalid']['order_ids'])) { ?>
                                        <?php foreach ($day['invalid']['order_ids'] as $order_id) { ?>
                                            <a target="_blank" href="<?php echo esc_url(admin_url('post.php?action=edit&post=' . $order_id)); ?>" class="order-link"><?php echo esc_html($order_id); ?></a>
                                        <?php } ?>
                                    <?php } ?>
                                </td>

                                <td class="text-align-right">
                                    <?php if (!empty($day['cancelled']['order_ids'])) { ?>
                                        <?php foreach ($day['cancelled']['order_ids'] as $order_id) { ?>
                                            <a target="_blank" href="<?php echo esc_url(admin_url('post.php?action=edit&post=' . $order_id)); ?>" class="order-link"><?php echo esc_html($order_id); ?></a>
                                        <?php } ?>
                                    <?php } ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                <?php endif; ?>

                <?php if (isset($summary_data['past_month'])): ?>
                    <tbody style="display: none;">
                        <tr>
                            <td colspan="7" style="background-color:#ddd!important"><?php echo esc_html($summary_data['past_month']['title']); ?></td>
                        </tr>

                        <?php foreach ($summary_data['past_month']['orders'] ?? [] as $day): ?>
                            <tr>
                                <td>
                                    <?php echo esc_html($day['date']); ?> <strong><?php if ($day['date'] == $today) {
                                            echo '(Today)';
                                        } ?></strong>
                                </td>

                                <td class="text-align-right">
                                    <?php $sameDayKey = array_search($day['date'], array_column($store_orders_data['past_month']['orders'], 'date')); ?>

                                    <?php if ($sameDayKey != false): ?>
                                        <?php $sameDayOrders = $store_orders_data['past_month']['orders'][$sameDayKey]; ?>

                                        RM <?php echo number_format($sameDayOrders['total'], 2); ?> | <?php echo esc_html($sameDayOrders['count']); ?>
                                    <?php else: ?>
                                        RM 0 | 0
                                    <?php endif; ?>
                                </td>

                                <td class="text-align-right">
                                    RM <?php echo number_format($day['created']['amount'], 2); ?> | <?php echo esc_html($day['created']['count']); ?>
                                </td>

                                <td class="text-align-right">
                                    RM <?php echo number_format($day['submitted']['amount'], 2); ?> | <?php echo esc_html($day['submitted']['count']); ?>
                                </td>

                                <td class="text-align-right">
                                    RM <?php echo number_format($day['validated']['amount'], 2); ?> | <?php echo esc_html($day['validated']['count']); ?>
                                </td>
                                <td class="text-align-right">
                                    RM <?php echo number_format($day['invalid']['amount'], 2); ?> | <?php echo esc_html($day['invalid']['count']); ?>
                                </td>
                                <td class="text-align-right">
                                    RM <?php echo number_format($day['cancelled']['amount'], 2); ?> | <?php echo esc_html($day['cancelled']['count']); ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                <?php endif; ?>

                <tfoot>
                    <tr>
                        <th class="text-align-left"><?php esc_html_e('Date', 'einvoiceapp-malaysia'); ?></th>
                        <th class="text-align-right"><?php esc_html_e('Orders', 'einvoiceapp-malaysia'); ?></th>
                        <th class="text-align-right"><?php esc_html_e('Created', 'einvoiceapp-malaysia'); ?></th>
                        <th class="text-align-right"><?php esc_html_e('Submitted', 'einvoiceapp-malaysia'); ?></th>
                        <th class="text-align-right"><?php esc_html_e('Validated', 'einvoiceapp-malaysia'); ?></th>
                        <th class="text-align-right"><?php esc_html_e('Invalid', 'einvoiceapp-malaysia'); ?></th>
                        <th class="text-align-right"><?php esc_html_e('Cancelled', 'einvoiceapp-malaysia'); ?></th>
                    </tr>
                </tfoot>
            </table>
        </form>
    </div>
</div>