<?php 

if (!defined('ABSPATH')) {
    exit; 
}

?>

<?php if (!empty($success_message)) : ?>
    <div class="notice notice-success is-dismissible">
        <p>
            <?php echo esc_html($success_message); ?>
            <?php if (!empty($document_url)): ?>
                <a href="<?php echo esc_url($document_url); ?>" target="_blank" style="margin-left: 10px;">
                    <?php esc_html_e('View Submission', 'einvoiceapp-malaysia'); ?> →
                </a>
            <?php endif; ?>
        </p>
    </div>
<?php endif; ?>

<?php if (!empty($error_message)) : ?>
    <div class="notice notice-error is-dismissible">
        <p><?php echo esc_html($error_message); ?></p>
    </div>
<?php endif; ?>

<div class="wrap e-invoice-request">
    <h1><?php echo esc_html($page_title); ?></h1>
    <br>

    <div class="o2oeinvoice-panel">
        <div class="panel-header">
            <h2 class="panel-title"><?php esc_html_e('Filter', 'einvoiceapp-malaysia'); ?></h2>
        </div>

        <div class="panel-body">
            <form action="<?php echo esc_url(admin_url('admin.php?page=einvappmy-einvoice-request')); ?>" method="get">
                <div style="display: flex; gap: 10px; align-items: flex-start;">
                    <input type="hidden" name="tab" value="<?php echo esc_attr($active_tab); ?>">
                    <input type="hidden" name="page" value="einvappmy-einvoice-request">
                    <input type="hidden" name="nonce" value="<?php echo esc_attr(wp_create_nonce('einvappmy_einvoice_request_page')); ?>">

                    <div>
                        <label for="filter_date_start"><?php esc_html_e('Date Start', 'einvoiceapp-malaysia'); ?></label><br>
                        <input type="date" name="filter_date_start" value="<?php echo esc_attr($filter_date_start); ?>">
                    </div>

                    <div>
                        <label for="filter_date_end"><?php esc_html_e('Date End', 'einvoiceapp-malaysia'); ?></label><br>
                        <input type="date" name="filter_date_end" value="<?php echo esc_attr($filter_date_end); ?>">
                    </div>
                </div>

                <div style="margin-top: 10px; display: flex; gap: 10px; align-items: center;">
                    <div style="flex: 1;">
                        <button class="button button-primary" type="submit"><?php esc_html_e('Filter', 'einvoiceapp-malaysia'); ?></button>
                        <button id="button-clear-filter" class="button button-secondary"><?php esc_html_e('Clear', 'einvoiceapp-malaysia'); ?></button>
                    </div>

                    <div style="flex: 1; text-align: right;">
                        <a href="<?php echo esc_url($link_export); ?>" class="button button-secondary"><?php esc_html_e('Export', 'einvoiceapp-malaysia'); ?></a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <h2 class="nav-tab-wrapper">
        <?php foreach($consolidate_statuses as $status_value => $status_properties) : ?>
            <?php $active_tab_class = $status_value == $active_tab ? 'nav-tab-active' : ''; ?>
            <a href="<?php echo esc_url($status_properties['url']); ?>" class="nav-tab <?php echo esc_attr($active_tab_class); ?>"><?php echo esc_html($status_properties['text']); ?></a>
        <?php endforeach; ?>
    </h2>

    <br>

    <div class="o2oeinvoice-panel">
        <div class="panel-body">
            <table class="wp-list-table widefat fixed striped posts">
                <thead>
                    <tr>
                        <td><?php esc_html_e('Order', 'einvoiceapp-malaysia'); ?></td>
                        <td><?php esc_html_e('Created Date', 'einvoiceapp-malaysia'); ?></td>
                        <td><?php esc_html_e('Invoice Type', 'einvoiceapp-malaysia'); ?></td>
                        <td><?php esc_html_e('Customer', 'einvoiceapp-malaysia'); ?></td>
                        <td class="ta-right"><?php esc_html_e('Total', 'einvoiceapp-malaysia'); ?></td>
                        <td><?php esc_html_e('Validated E-Invoice', 'einvoiceapp-malaysia'); ?></td>
                        <td><?php esc_html_e('Action', 'einvoiceapp-malaysia'); ?></td>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($invoice_list as $invoice) : ?>
                        <tr>
                            <td>
                               <strong><a href="<?php echo esc_url($invoice['order_info_url']); ?>" target="_blank"><?php echo esc_html($invoice['order_id']); ?></a></strong>
                            </td>
                            <td><?php echo esc_html($invoice['date_created']); ?></td>
                            <td><?php echo esc_html($invoice['invoice_type_text']); ?></td>
                            <td><?php echo esc_html($invoice['customer_name']); ?></td>
                            <td class="ta-right"><?php echo esc_html($invoice['total_amount']); ?></td>
                            <td>
                                <?php if (!empty($invoice['uuid'])) : ?>
                                    <?php if (!empty($invoice['validation_url'])) : ?>
                                        <strong><a href="<?php echo esc_url($invoice['validation_url']); ?>" target="_blank"><?php echo esc_html($invoice['uuid']); ?></a></strong>
                                    <?php else : ?>
                                        <?php echo esc_html($invoice['uuid']); ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="button-group">
                                    <?php if (!empty($invoice['cancel_invoice_url'])) : ?>
                                        <a href="<?php echo esc_url($invoice['cancel_invoice_url']); ?>" class="button button-danger">
                                            <span class="dashicons dashicons-no dashicons-tooltip" title="Cancel Invoice"></span>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (!empty($invoice['pdf_url'])) : ?>
                                        <a href="<?php echo esc_url($invoice['pdf_url']); ?>" class="button button-secondary" target="_blank">
                                            <span class="dashicons dashicons-pdf dashicons-tooltip" title="View PDF"></span>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (!empty($invoice['create_credit_note_url'])) : ?>
                                        <a href="<?php echo esc_url($invoice['create_credit_note_url']); ?>" class="button button-secondary einvoice-action-btn" data-action="credit-note">
                                            <span class="dashicons dashicons-plus dashicons-tooltip" title="Create Credit Note"></span>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (!empty($invoice['create_debit_note_url'])) : ?>
                                        <a href="<?php echo esc_url($invoice['create_debit_note_url']); ?>" class="button button-secondary einvoice-action-btn" data-action="debit-note">
                                            <span class="dashicons dashicons-minus dashicons-tooltip" title="Create Debit Note"></span>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (!empty($invoice['create_refund_note_url'])) : ?>
                                        <a href="<?php echo esc_url($invoice['create_refund_note_url']); ?>" class="button button-secondary einvoice-action-btn" data-action="refund-note">
                                            <span class="dashicons dashicons-arrow-left-alt2 dashicons-tooltip" title="Create Refund Note"></span>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>