<?php if (!defined('ABSPATH')) exit; ?>

<div class="wrap e-invoice-consolidated">
    <h1><?php echo esc_html($page_title); ?></h1>
    <br />

    <div style="display: flex; align-items: flex-start; gap: 10px;">
        <div style="width: 43%;">
            <div class="o2oeinvoice-panel">
                <div class="panel-header" style="background-color: rgba(145, 208, 255, 1);">
                    <h2 class="panel-title"><?php esc_html_e('Last Consolidated E-invoice', 'einvoiceapp-malaysia'); ?></h2>
                </div>

                <div class="panel-body">
                    <table id="table-submitted-consolidated" class="wp-list-table widefat fixed striped posts">
                        <thead>
                            <tr>
                                <td><?php esc_html_e('Date and Time', 'einvoiceapp-malaysia'); ?></td>
                                <td><?php esc_html_e('Amount', 'einvoiceapp-malaysia'); ?></td>
                                <td><?php esc_html_e('Validation', 'einvoiceapp-malaysia'); ?></td>
                                <td><?php esc_html_e('Status', 'einvoiceapp-malaysia'); ?></td>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>

                    <div id="submitted-consolidated-buttons" class="buttons" style="margin-top: 20px;"></div>
                </div>
            </div>
        </div>

        <div style="width: 56%;">
            <div class="o2oeinvoice-panel">
                <div class="panel-body">
                    <div class="consolidated-info-container">
                        <div class="consolidated-info-container-item">
                            <span class="dashicons dashicons-info-outline" style="color: #0073aa; font-size: 20px;" title="Consolidated Invoice Information"></span>
                        </div>

                        <div class="consolidated-info-container-content">
                            <?php esc_html_e('Currently Consolidating for: ', 'einvoiceapp-malaysia'); ?> <strong><?php echo esc_html($consolidated_month); ?></strong>

                            <p><?php esc_html_e('You should only consolidate after you end your sales month.', 'einvoiceapp-malaysia'); ?></p>

                            <h3><?php esc_html_e('How to use: ', 'einvoiceapp-malaysia'); ?></h3>
                            <ol>
                                <li><?php esc_html_e('Select the order statuses to fetch the orders.', 'einvoiceapp-malaysia'); ?></li>
                                <li><?php esc_html_e('Choose the order(s) to consolidate.', 'einvoiceapp-malaysia'); ?></li>
                                <li><?php esc_html_e('Check sales amount.', 'einvoiceapp-malaysia'); ?></li>
                                <li><?php esc_html_e('Submit as Consolidated E-invoice.', 'einvoiceapp-malaysia'); ?></li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <div class="o2oeinvoice-panel">
                <div class="panel-header">
                    <h2 class="panel-title"><?php esc_html_e('Step 1: Select Order Statuses', 'einvoiceapp-malaysia'); ?></h2>
                </div>

                <div class="panel-body">
                    <?php esc_html_e('Select the order statuses to fetch the orders.', 'einvoiceapp-malaysia'); ?>

                    <table class="form-table">
                        <tr>
                            <td>
                                <?php foreach ($order_statuses as $status_key => $status_label): ?>
                                    <?php $is_checked = in_array($status_key, $default_consolidated_order_statuses) ? 'checked' : ''; ?>
                                    <label>
                                        <input type="checkbox" name="consolidated_order_statuses[]" value="<?php echo esc_attr($status_key); ?>" <?php echo esc_attr($is_checked); ?>>
                                        <?php echo esc_html($status_label); ?>
                                    </label>
                                    <br>
                                <?php endforeach; ?>
                            </td>
                        </tr>
                    </table>

                    <button class="button button-primary" id="consolidated-fetch-orders"><?php esc_html_e('Fetch Orders', 'einvoiceapp-malaysia'); ?></button>
                </div>
            </div>

            <div class="o2oeinvoice-panel d-none" id="select-orders-container">
                <div class="panel-header">
                    <h2 class="panel-title"><?php esc_html_e('Step 2: Choose the order(s) to consolidate', 'einvoiceapp-malaysia'); ?></h2>
                </div>

                <div class="panel-body">
                    <p class="loading-message"><img src="<?php echo esc_url(get_admin_url() . 'images/loading.gif'); ?>" /> <?php esc_html_e('Please wait while you processing the sales data...', 'einvoiceapp-malaysia'); ?></p>

                    <div id="consolidated-info-container">
                        <p>
                            <?php esc_html_e('Orders waiting for consolidation: ', 'einvoiceapp-malaysia'); ?><strong><span id="total-order-found">0</span></strong>
                            <br />
                            <strong><?php esc_html_e('Total Sales: ', 'einvoiceapp-malaysia'); ?> <span id="total-sales-amount">0</span></strong>
                            
                        </p>
                    </div>

                    <div id="consolidated-orders-table-container"></div>

                    <div class="button-container" style="margin-top: 20px;">
                        <button class="button button-primary" id="button-download-order-list"><?php esc_html_e('Download Order List', 'einvoiceapp-malaysia'); ?></button>
                    </div>

                    <div class="alert alert-info alert-fetch-orders">
                        <ul>
                            <li><?php esc_html_e('If you are using another accounting application for consolidated e-invoice, you only need to download this and ignore the process below.', 'einvoiceapp-malaysia'); ?></li>
                            <li><?php esc_html_e('We will not keep order ID information within the consolidated e-invoice if we submit to LHDN for you, so please download this and store for your own reference.', 'einvoiceapp-malaysia'); ?></li>
                            <li><?php esc_html_e('The validated e-invoice orders will be excluded from the fetch order list.', 'einvoiceapp-malaysia'); ?></li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="o2oeinvoice-panel d-none" id="sales-amount-container">
                <div class="panel-header">
                    <h2 class="panel-title"><?php esc_html_e('Step 3: Check Sales Amount', 'einvoiceapp-malaysia'); ?></h2>
                </div>

                <div class="panel-body">
                    <div class="alert alert-info">
                        <span class="dashicons dashicons-info-outline" style="color: #0073aa; font-size: 20px;" title="Consolidated Invoice Information"></span>
                        <?php esc_html_e('Please only amend the sales amount if it is incorrect.', 'einvoiceapp-malaysia'); ?>
                    </div>

                    <table class="form-table">
                        <tr>
                            <th scope="row"><?php esc_html_e('Consolidated Sales Amount', 'einvoiceapp-malaysia'); ?></th>
                            <td>
                                <input type="number" name="consolidated_sales_amount" class="regular-text" id="input_consolidated_sales_amount" value="0">
                            </td>
                        </tr>

                        <tr>
                            <th scope="row"><?php esc_html_e('Consolidated Tax Amount', 'einvoiceapp-malaysia'); ?></th>
                            <td>
                                <input type="number" name="consolidated_tax_amount" class="regular-text" id="input_consolidated_tax_amount" value="0">
                            </td>
                        </tr>
                    </table>

                    <div class="alert alert-warning">
                        <?php esc_html_e('Please make sure it is correct before submitting. This is irreversible after clicking Submit.', 'einvoiceapp-malaysia'); ?>
                    </div>

                    <div class="button-container" style="margin-top: 20px;">
                        <button class="button button-primary" id="button-submit-consolidated"><?php esc_html_e('Submit as Consolidated E-invoice', 'einvoiceapp-malaysia'); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>