<?php

if ( ! defined( 'ABSPATH' ) ) exit;

// phpcs:disable WordPress.Security.EscapeOutput.OutputNotEscaped

?>

<table class="wp-list-table widefat fixed striped posts">
    <thead>
        <td id="col-cb" class="manage-column column-cb check-column">
            <label class="screen-reader-text" for="cb-select-all-1">Select All</label>
            <input id="cb-select-all-1" type="checkbox">
        </td>
        <td scope="col" id="col-order-name" class="manage-column column-order-name column-primary sortable desc">Order Name</td>
        <td scope="col" id="col-date" class="manage-column column-date column-primary sortable desc">Date</td>
        <td scope="col" id="col-customer" class="manage-column column-customer column-primary sortable desc">Customer</td>
        <td scope="col" id="col-payment-status" class="manage-column column-payment-status column-primary sortable desc">Payment Status</td>
        <td scope="col" id="col-currency" class="manage-column column-currency column-primary sortable desc">Currency</td>
        <td scope="col" id="col-total" class="manage-column column-total column-primary sortable desc" style="text-align: right;">Total</td>
        <td scope="col" id="col-tax" class="manage-column column-tax column-primary sortable desc" style="text-align: right;">Tax</td>
    </thead>

    <tbody id="the-list">
        <?php foreach ($orders as $order): ?>
            <tr id="order-<?php echo esc_attr($order['id']); ?>" class="iedit author-self level-0 post-1 type-post status-publish format-standard hentry category-Dummy category">
                <th scope="row" class="check-column">
                    <label class="screen-reader-text" for="cb-select-<?php echo esc_attr($order['id']); ?>">Select <?php echo esc_html($order['id']); ?></label>
                    <input id="cb-select-<?php echo esc_attr($order['id']); ?>" type="checkbox" name="consolidated_order_ids[]" value="<?php echo esc_attr($order['id']); ?>" 
                    data-amount="<?php echo esc_attr($order['total_amount']); ?>" data-tax-amount="<?php echo esc_attr($order['tax_amount']); ?>">
                    
                    <div class="locked-indicator">
                        <span class="locked-indicator-icon" aria-hidden="true"></span>
                        <span class="screen-reader-text">
                            “<?php echo esc_html($order['id']); ?>” is locked
                        </span>
                    </div>
                </th>

                <td class="order-name column-order-name" data-colname="Order Name">
                    <a href="<?php echo esc_url(admin_url('post.php?post=' . absint($order['id']) . '&action=edit')); ?>" target="_blank">
                        <?php echo esc_html($order['id']); ?>
                    </a>
                </td>

                <td class="date column-date" data-colname="Date">
                    <?php echo esc_html($order['date_added']); ?>
                </td>

                <td class="customer column-customer" data-colname="Customer">
                    <?php echo esc_html($order['customer_name']); ?>
                </td>

                <td class="payment-status column-payment-status" data-colname="Payment Status">
                    <?php echo esc_html($order['status_text']); ?>
                </td>

                <td class="currency column-currency" data-colname="Currency">
                    <?php echo esc_html($order['currency']); ?>
                </td>

                <td class="total column-total" data-colname="Total" align="right">
                    <?php echo esc_html($order['formatted_total_amount']); ?>
                </td>

                <td class="tax column-tax" data-colname="Tax" align="right">
                    <?php echo esc_html($order['formatted_tax_amount']); ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>

    <tfoot>
        <td class="manage-column column-cb check-column">
            <label class="screen-reader-text" for="cb-select-all-1">Select All</label>
            <input id="cb-select-all-1" type="checkbox">
        </td>
        <td scope="col" id="col-order-name" class="manage-column column-order-name column-primary sortable desc">Order Name</td>
        <td scope="col" id="col-date" class="manage-column column-date column-primary sortable desc">Date</td>
        <td scope="col" id="col-customer" class="manage-column column-customer column-primary sortable desc">Customer</td>
        <td scope="col" id="col-payment-status" class="manage-column column-payment-status column-primary sortable desc">Payment Status</td>
        <td scope="col" id="col-currency" class="manage-column column-currency column-primary sortable desc">Currency</td>
        <td scope="col" id="col-total" class="manage-column column-total column-primary sortable desc" style="text-align: right;">Total</td>
        <td scope="col" id="col-tax" class="manage-column column-tax column-primary sortable desc" style="text-align: right;">Tax</td>
    </tfoot>
</table>