<?php

if (!defined('ABSPATH')) {
    exit;
}

?>

<?php if (!empty($success_message)): ?>
    <div class="notice notice-success is-dismissible">
        <p>
            <?php echo esc_html($success_message); ?>
            <?php if (!empty($document_url)): ?>
                <a href="<?php echo esc_url($document_url); ?>" target="_blank" style="margin-left: 10px;">
                    <?php esc_html_e('View Submission', 'einvoiceapp-malaysia'); ?> →
                </a>
            <?php endif; ?>
        </p>
    </div>
<?php endif; ?>

<?php if (!empty($error_message)): ?>
    <div class="notice notice-error is-dismissible">
        <p><?php echo esc_html($error_message); ?></p>
    </div>
<?php endif; ?>


<div class="wrap einvoice-consolidated-history">
    <h1><?php echo esc_html($page_title); ?></h1>
    <br>

    <!-- Status Tabs Start -->
    <h2 class="nav-tab-wrapper">
        <?php foreach ($consolidated_statuses as $consolidated_status_value => $consolidated_status_properties): ?>
            <?php $active_tab_class = $consolidated_status_value == $active_tab ? 'nav-tab-active' : ''; ?>
            <a href="<?php echo esc_url(add_query_arg('tab', $consolidated_status_properties['value'], admin_url('admin.php?page=einvappmy-consolidated-history'))); ?>" class="nav-tab <?php echo esc_attr($active_tab_class); ?>"><?php echo esc_html($consolidated_status_properties['text']); ?></a>
        <?php endforeach; ?>
    </h2>
    <!-- Status Tabs End -->

    <br>

    <!-- Consolidated History Table Start -->
    <div class="o2oeinvoice-panel">
        <div class="panel-body">
            <table class="wp-list-table widefat fixed striped posts">
                <thead>
                    <tr>
                        <td><?php esc_html_e('Date & Time', 'einvoiceapp-malaysia'); ?></td>
                        <td><?php esc_html_e('Validation', 'einvoiceapp-malaysia'); ?></td>
                        <td class="ta-right"><?php esc_html_e('Amount', 'einvoiceapp-malaysia'); ?></td>
                        <td class="ta-right"><?php esc_html_e('Action', 'einvoiceapp-malaysia'); ?></td>
                    </tr>
                </thead>

                <tbody>
                    <?php foreach ($consolidated_listing as $consolidated_item): ?>
                        <tr>
                            <td><?php echo esc_html($consolidated_item['formatted_date']); ?></td>
                            <td><a href="<?php echo esc_url($consolidated_item['validation_url']); ?>" target="_blank"><?php echo esc_html($consolidated_item['uuid']); ?></a></td>
                            <td class="ta-right"><?php echo esc_html($consolidated_item['formatted_total']); ?></td>
                            <td class="ta-right">
                                <?php if (!empty($consolidated_item['trails_pdf_url'])): ?>
                                    <span class="pdf-button-wrapper">
                                        <a href="<?php echo esc_url($consolidated_item['trails_pdf_url']); ?>" target="_blank" class="button button-small pdf-trails-button">
                                            <span class="dashicons dashicons-pdf"></span>
                                        </a>
                                        <span class="pdf-tooltip"><?php esc_html_e('View PDF Trails', 'einvoiceapp-malaysia'); ?></span>
                                    </span>
                                <?php endif; ?>
                                
                                <?php if (!empty($consolidated_item['link_create_debit_note'])): ?>
                                    <span class="pdf-button-wrapper">
                                        <a href="<?php echo esc_url($consolidated_item['link_create_debit_note']); ?>" class="button button-small einvoice-action-btn" data-action="debit-note">
                                            <span class="dashicons dashicons-plus-alt"></span>
                                        </a>
                                        <span class="pdf-tooltip"><?php esc_html_e('Create Debit Note', 'einvoiceapp-malaysia'); ?></span>
                                    </span>
                                <?php endif; ?>
                                
                                <?php if (!empty($consolidated_item['link_create_credit_note'])): ?>
                                    <span class="pdf-button-wrapper">
                                        <a href="<?php echo esc_url($consolidated_item['link_create_credit_note']); ?>" class="button button-small einvoice-action-btn" data-action="credit-note">
                                            <span class="dashicons dashicons-minus"></span>
                                        </a>
                                        <span class="pdf-tooltip"><?php esc_html_e('Create Credit Note', 'einvoiceapp-malaysia'); ?></span>
                                    </span>
                                <?php endif; ?>
                                
                                <?php if (!empty($consolidated_item['link_create_refund_note'])): ?>
                                    <span class="pdf-button-wrapper">
                                        <a href="<?php echo esc_url($consolidated_item['link_create_refund_note']); ?>" class="button button-small einvoice-action-btn" data-action="refund-note">
                                            <span class="dashicons dashicons-money-alt"></span>
                                        </a>
                                        <span class="pdf-tooltip"><?php esc_html_e('Create Refund Note', 'einvoiceapp-malaysia'); ?></span>
                                    </span>
                                <?php endif; ?>
                                
                                <?php if (!empty($consolidated_item['link_cancel_invoice'])): ?>
                                    <span class="pdf-button-wrapper">
                                        <a href="<?php echo esc_url($consolidated_item['link_cancel_invoice']); ?>" class="button button-small button-link-delete einvoice-action-btn" data-action="cancel-invoice">
                                            <span class="dashicons dashicons-dismiss"></span>
                                        </a>
                                        <span class="pdf-tooltip"><?php esc_html_e('Cancel Invoice', 'einvoiceapp-malaysia'); ?></span>
                                    </span>
                                <?php endif; ?>
                                
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <!-- Consolidated History Table End -->
</div>