<?php

/**
 * Plugin Name: EInvoice App Malaysia
 * Description: Collects checkout info, lets customers complete missing details, and submits to LHDN e-invoice
 * Requires Plugins: woocommerce
 * Version: 1.3.0
 * Author: o2oe
 * License: GPLv2 or later
 */

// Stop people from accessing this file directly
if (!defined('ABSPATH')) {
    exit('Nice try! Access denied.');
}

// Make sure WooCommerce is installed and active
if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    add_action('admin_notices', function () {
        echo '<div class="notice notice-error"><p><strong>Oops!</strong> Please make sure to install and activate WooCommerce.</p></div>';
    });
    return;
}

// Define useful constants
define('EINVAPPMY_VERSION', '1.2.0');
define('EINVAPPMY_PLUGIN_URL', plugin_dir_url(__FILE__));
define('EINVAPPMY_PLUGIN_ASSETS_URL', plugin_dir_url(__FILE__) . 'assets/');
define('EINVAPPMY_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('EINVAPPMY_PLUGIN_DOMAIN', 'einvoiceapp-malaysia');

// ADD THIS: Load your CSS files everywhere in admin
add_action('admin_enqueue_scripts', function() {
    wp_enqueue_style(
        'einvappmy-style',                                    // Name for your CSS
        EINVAPPMY_PLUGIN_URL . 'assets/css/style.css?v=' . time(), // Path to your CSS file
        array(),                                          // No dependencies
        '1.2.0'                                          // Version number
    );
    
    // Enqueue the new enhanced alert styles
    wp_enqueue_style(
        'einvappmy-style2',                                   // Name for your enhanced CSS
        EINVAPPMY_PLUGIN_URL . 'assets/css/style2.css?v=' . time(), // Path to your new CSS file
        array(),                                          // No dependencies
        '1.2.0'                                          // Version number
    );
});

class EINVAPPMY
{
    private $config;

    public function __construct() {
        $this->config = require_once EINVAPPMY_PLUGIN_PATH . 'includes/config.php';

        // Register activation hook
        register_activation_hook(__FILE__, array($this, 'activate_plugin'));

        // Start session if needed, but close it immediately to avoid interfering with REST API
        if(!session_id()) {
            session_start();
            // Close session immediately to prevent interference with REST API and loopback requests
            session_write_close();
        }

        // Fix output buffering conflicts with WordPress
        remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );

        $this->load_includes();
    }

    /**
     * Ensure session is open for writing
     * Call this before writing to $_SESSION
     */
    public static function ensure_session_open() {
        if (!session_id()) {
            session_start();
        } elseif (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
    }

    /**
     * Close session after writing
     * Call this after writing to $_SESSION to avoid interfering with REST API
     */
    public static function close_session() {
        if (session_id()) {
            session_write_close();
        }
    }

    public function activate_plugin() {
        require_once EINVAPPMY_PLUGIN_PATH . 'includes/model/model-o2oei.php';
        $model_einvappmy = new Model_EINVAPPMY($this->config);
        $model_einvappmy->setupDBTables();
    }

    public function load_includes() {
        require_once EINVAPPMY_PLUGIN_PATH . 'includes/helper/class-o2oei-helper.php';
        require_once EINVAPPMY_PLUGIN_PATH . 'includes/library/class-o2oei-library.php';
        require_once EINVAPPMY_PLUGIN_PATH . 'includes/model/model-o2oei.php';

        require_once EINVAPPMY_PLUGIN_PATH . 'templates/components/subscription.php';
        
        if (is_admin()) {
            require_once EINVAPPMY_PLUGIN_PATH . 'includes/admin/class-o2oei-admin-settings.php';
            new EINVAPPMY_Admin_Settings($this->config);

            require_once EINVAPPMY_PLUGIN_PATH . 'includes/admin/class-o2oei-wc-order.php';
            new EINVAPPMY_WC_Order($this->config);
        }

        require_once EINVAPPMY_PLUGIN_PATH . 'includes/class-o2oei-order-handle.php';
        new EINVAPPMY_Order_Handler($this->config);
    }
}

new EINVAPPMY();