<?php

if ( ! defined( 'ABSPATH' ) ) exit;

$config = [
    'plugin_name' => 'EInvoice App',
    'setting_name' => 'einvappmy_settings',
    'option_name' => 'einvappmy_options',
    'page_name' => 'einvappmy-settings',
    'admin_code' => 'o2oecommerce',
    'channel' => 'woocommerce',
    'default_country' => 'MY',
    'default_currency_code' => 'MYR',
    'api' => [
        'staging' => ['url' => 'https://dev-api.einvoiceapp.my/'],
        'live' => ['url' => 'https://api.einvoiceapp.my/'],
    ],
    'user_guide_url' => 'https://o2o-ecommerce.gitbook.io/o2o-e-invoice-guide',
    'faq_url' => 'https://o2o-ecommerce.gitbook.io/o2o-e-invoice-guide/faq/general',
    'official_mytax_site_url' => 'https://mytax.hasil.gov.my/',
    'official_lhdn_faq_site_url' => 'https://www.hasil.gov.my/en/e-invoice/reference-for-the-implementation-of-e-invoice/frequently-asked-questions/',
    'privacy_policy_url' => 'https://www.webceo.my/einvoice-app-for-woocommerce-privacy-policy',
    'environments' => [
        0 => [
            'value' => 0,
            'text' => 'Disable',
            'style' => ['background_color' => '#6c757d', 'color' => 'white']
        ],
        1 => [
            'value' => 1,
            'text' => 'Staging (Sandbox / Testing)',
            'style' => ['background_color' => '#ffc107', 'color' => 'black']
        ],
        2 => [
            'value' => 2,
            'text' => 'Live (Production)',
            'style' => ['background_color' => '#28a745', 'color' => 'white']
        ],
    ],
    'invoice_types' => [
        0 => ['value' => 0, 'text' => 'E-Invoice'],
        1 => ['value' => 1, 'text' => 'Consolidated'],
    ],
    'identification_types' => [
        'NRIC' => [
            'value' => 'NRIC',
            'text' => 'NRIC',
            'help' => ['title' => 'NRIC - Malaysian Individuals, MyPR and MyKAS', 'description' => 'MyKad / MyPR / MyKAS identification number']
        ],
        'PASSPORT' => [
            'value' => 'PASSPORT',
            'text' => 'PASSPORT',
            'help' => ['title' => 'PASSPORT - Non-Malaysian Individuals without MyPR and MyKAS', 'description' => 'Passport number']
        ],
        'BRN' => [
            'value' => 'BRN',
            'text' => 'BRN',
            'help' => ['title' => 'BRN - Businesses', 'description' => 'Business registration number']
        ],
        'ARMY' => ['value' => 'ARMY', 'text' => 'ARMY', 'help' => ['title' => 'ARMY - Malaysian Individuals (MyTentera)', 'description' => 'MyTentera identification number']],
    ],
    'submit_methods' => [
        0 => [
            'value' => 0,
            'text' => 'Direct (v1.0)',
            'help_text' => 'Customers submitting the form will directly send into LHDN e-invoice.'
        ],
        // 1 => [
        //     'value'     => 1,
        //     'text'      => '3rd Party App',
        //     'help_text' => 'E-invoice requests will not auto submit int LHDN directly, please contact us for the 3rd party app integration.'
        // ],
    ],
    'consolidated_status_text' => [
        // "0" => "Not Submitted",
        "0" => "Created",
        "2" => "Submitted",
        "1" => "Validated",
        "3" => "Invalid",
        "4" => "Cancelled"
    ],
    'notes_status_text' => [
        // "0" => "Not Submitted",
        "0" => "Created",
        "2" => "Submitted",
        "1" => "Valid",
        "3" => "Invalid",
        "4" => "Cancelled"
    ],
    'notes' => [
        'credit_note' => ['text' => 'Credit Note', 'value' => 'credit_note', 'value2' => 'credit_notes'],
        'debit_note' => ['text' => 'Debit Note', 'value' => 'debit_note', 'value2' => 'debit_notes'],
        'refund_note' => ['text' => 'Refund Note', 'value' => 'refund_note', 'value2' => 'refund_notes'],
    ],
    'consolidated_statuses' => [
        1 => ['value' => 1, 'code' => 'validated', 'text' => 'Validated'],
        2 => ['value' => 2, 'code' => 'submitted', 'text' => 'Submitted'],
    ],
    'consolidated_valid_statuses' => [1],
    'default_consolidated_order_statuses' => ['wc-processing', 'wc-completed'],
    'default_status_label_background_color' => '#999999',
    'status_label_background_color' => [
        "0" => "#999999",
        "1" => "#40c90a",
        "2" => "#fcb322",
        "3" => "#ff0000",
        "4" => "#ff0000"
    ],
    'states' => [
        'JHR' => array("label" => "Johor", "value" => "Johor", 'code' => 'JHR'),
        'KDH' => array("label" => "Kedah", "value" => "Kedah", 'code' => 'KDH'),
        'KTN' => array("label" => "Kelantan", "value" => "Kelantan", 'code' => 'KTN'),
        'MLK' => array("label" => "Melaka", "value" => "Melaka", 'code' => 'MLK'),
        'NSN' => array("label" => "Negeri Sembilan", "value" => "Negeri Sembilan", 'code' => 'NSN'),
        'PHG' => array("label" => "Pahang", "value" => "Pahang", 'code' => 'PHG'),
        'PNG' => array("label" => "Pulau Pinang", "value" => "Pulau Pinang", 'code' => 'PNG'),
        'PRK' => array("label" => "Perak", "value" => "Perak", 'code' => 'PRK'),
        'PLS' => array("label" => "Perlis", "value" => "Perlis", 'code' => 'PLS'),
        'SGR' => array("label" => "Selangor", "value" => "Selangor", 'code' => 'SGR'),
        'TRG' => array("label" => "Terengganu", "value" => "Terengganu", 'code' => 'TRG'),
        'SBH' => array("label" => "Sabah", "value" => "Sabah", 'code' => 'SBH'),
        'SWK' => array("label" => "Sarawak", "value" => "Sarawak", 'code' => 'SWK'),
        'KUL' => array("label" => "Wilayah Persekutuan Kuala Lumpur", "value" => "Wilayah Persekutuan Kuala Lumpur", 'code' => 'KUL'),
        'LBN' => array("label" => "Wilayah Persekutuan Labuan", "value" => "Wilayah Persekutuan Labuan", 'code' => 'LBN'),
        'PJY' => array("label" => "Wilayah Persekutuan Putrajaya", "value" => "Wilayah Persekutuan Putrajaya", 'code' => 'PJY'),
    ],
    'allow_create_invoice_statuses' => [
        'wc-processing',
        'wc-completed',
        'processing',
        'completed',
    ],
    'cancel_or_refund_order_statuses' => [
        'wc-refunded',
        'wc-cancelled',
        'refunded',
        'cancelled',
    ],
    'pending_order_statuses' => [
        'wc-on-hold',
        'wc-pending',
        'on-hold',
        'pending',
    ],
    'fallback_message_order_statuses' => [
        'wc-failed',
        'failed',
    ],
];

return $config;