function myeinvoiceRequest() {
  var create_date = jQuery('#input_create_date').val();

  jQuery.ajax({
    url: einvappmyWCOrderData.ajax_url,
    type: "POST",
    data: {
      action: "einvappmy_myeinvoice_request",
      order_id: einvappmyWCOrderData.order_id,
      nonce: einvappmyWCOrderData.nonce,
      create_date: create_date,
    },
    dataType: "json",
    beforeSend: function () {
      // Clear previous error message
      jQuery("#einvappmy-order-error").addClass("d-none").html("");
      changeStatus("requesting");
    },
    success: function (response) {
      if (response.success && response?.data?.eInvoiceUrl) {
        changeStatus("request-success");
        jQuery('input[name="einvoice_link"]').val(response.data.eInvoiceUrl);
      } else {
        // Show error message from server in alert box div
        var msgHtml =
          response.message ||
          response.error ||
          (response.data && (response.data.error || response.data.message)) ||
          "Failed to request e-invoice. Please try again.";

        var $errorBox = jQuery("#einvappmy-order-error");
        if ($errorBox.length) {
          $errorBox.removeClass("d-none").html(msgHtml);
        } else {
          // Fallback if container is missing
          alert(msgHtml);
        }

        // Show the request button again
        changeStatus("not-requested");
      }
    },
  });
}

function myInvoisCreateDocument(document_type, invoice_code) {
  jQuery.ajax({
    url: einvappmyWCOrderData.ajax_url,
    type: "POST",
    data: {
      action: "einvappmy_myeinvoice_create_document",
      document_type: document_type,
      invoice_code: invoice_code,
      nonce: einvappmyWCOrderData.nonce_create_document,
    },
    dataType: "json",
    beforeSend: function () {
      changeStatus("requesting");
    },
    success: function (response) {
      if (response.success) {
        alert(response.message);
        location.reload();
      } else {
        alert(response.data?.error || "Failed to create document. Please try again.");
        // On error, restore the previous successful/requested state
        changeStatus("request-success");
      }
    },
  });
}

function changeStatus(status) {
  jQuery('.e-invoice-status[status="' + status + '"]').show();
  jQuery(".e-invoice-status")
    .not('[status="' + status + '"]')
    .hide();
}

// Enhance e-invoice link field behaviour in the admin order screen
jQuery(function ($) {
  // Use document-level delegation to handle dynamically added elements
  jQuery(document).on("click", ".einvoice-link-input", function (e) {
    e.preventDefault();
    e.stopPropagation();
    var url = jQuery(this).val();
    if (url && url.trim() !== "") {
      window.open(url, "_blank");
    }
  });

  // Click on the "Copy" button: copy the URL to clipboard
  jQuery(document).on("click", ".einvoice-link-copy", function (e) {
    e.preventDefault();
    e.stopPropagation();

    var $input = jQuery(this).siblings(".einvoice-link-input");
    if (!$input.length) return;

    var url = $input.val();
    if (!url || url.trim() === "") return;

    var $button = jQuery(this);
    var $icon = $button.find(".dashicons");
    var $wrapper = $button.closest(".einvoice-link-wrapper");

    // Function to show success message
    function showSuccessMessage() {
      // Remove any existing success message
      jQuery(".einvoice-copy-success-message").remove();
      
      // Create success message
      var $message = jQuery('<div class="einvoice-copy-success-message">Link copied successfully!</div>');
      
      // Position message relative to button using fixed positioning to account for scrolling
      var buttonOffset = $button.offset();
      var buttonWidth = $button.outerWidth();
      var scrollTop = jQuery(window).scrollTop();
      var scrollLeft = jQuery(window).scrollLeft();
      
      $message.css({
        position: 'fixed',
        top: (buttonOffset.top - scrollTop - 35) + 'px',
        left: (buttonOffset.left - scrollLeft + (buttonWidth / 2) - 80) + 'px'
      });
      
      jQuery('body').append($message);
      
      // Remove message after animation
      setTimeout(function() {
        $message.remove();
      }, 2000);
    }

    // Modern clipboard API if available
    if (navigator.clipboard && navigator.clipboard.writeText) {
      navigator.clipboard
        .writeText(url)
        .then(function () {
          // Visual feedback - briefly change icon
          $icon.removeClass("dashicons-clipboard").addClass("dashicons-yes");
          showSuccessMessage();
          setTimeout(function () {
            $icon.removeClass("dashicons-yes").addClass("dashicons-clipboard");
          }, 1000);
        })
        .catch(function () {
          // Fallback if clipboard API fails
          try {
            $input[0].select();
            document.execCommand("copy");
            // Visual feedback even on fallback
            $icon.removeClass("dashicons-clipboard").addClass("dashicons-yes");
            showSuccessMessage();
            setTimeout(function () {
              $icon.removeClass("dashicons-yes").addClass("dashicons-clipboard");
            }, 1000);
          } catch (err) {
            console.warn("Failed to copy e-invoice link", err);
          }
        });
    } else {
      // Legacy fallback
      try {
        $input[0].select();
        document.execCommand("copy");
        // Visual feedback
        $icon.removeClass("dashicons-clipboard").addClass("dashicons-yes");
        showSuccessMessage();
        setTimeout(function () {
          $icon.removeClass("dashicons-yes").addClass("dashicons-clipboard");
        }, 1000);
      } catch (err) {
        console.warn("Failed to copy e-invoice link", err);
      }
    }
  });
});
