jQuery(window).on("load", function () {
  jQuery.ajax({
    url: einvappmyData.ajax_url,
    type: "GET",
    dataType: "json",
    data: {
      action: "einvappmy_myeinvoice_check_status",
      order_id: einvappmyData.order_id,
      date_added: einvappmyData.date_added,
    },
    beforeSend: function () {
      jQuery(".btn-loading").show();
    },
    complete: function () {
      jQuery('.btn-loading').hide();
    },
    success: function (response) {
      console.log(response);

      if (response.error == "No invoices found") {
        jQuery('.myeinvoice-block [status="not-requested"]').show();
        jQuery('.myeinvoice-block [status="checking"]').hide();
      } else if (response.error == "Expired") {
        jQuery('.myeinvoice-block [status="expired"]').show();
        jQuery('.myeinvoice-block [status="checking"]').hide();
      } else if (response.error) {
        jQuery('.myeinvoice-block [status="error"]').show();
        jQuery('.myeinvoice-block [status="checking"]').hide();
        jQuery('#einvappmy-order-error').html(response.error);
      } else if (response.success && response.data[0]) {
        jQuery('.myeinvoice-block [status="request_success"]').show();
        jQuery('.myeinvoice-block [status="checking"]').hide();

        jQuery('#request_einvoice_qr').attr('href', response.invoice_url);
        jQuery('#request_einvoice_link').attr('href', response.invoice_url);

        new QRCode(document.getElementById("request_einvoice_qr_image"), {
          text: response.invoice_url,
          width: 128,
          height: 128,
        });

        // Update status and PDF URL
        jQuery('#einvoice_status').text(response.status).attr('class', 'status-badge status-' + response.status.toLowerCase().replace(' ', '-')).css('background-color', response.status_color);
        if (response.pdf_url) {
          jQuery('#pdf_url').show();
          jQuery('#pdf_url').attr('href', response?.pdf_url);
        }
      } else {
        jQuery('.myeinvoice-block [status="not-requested"]').hide();
      }
    },
  });
});

function myeinvoiceRequest() {
  jQuery.ajax({
    url: einvappmyData.ajax_url,
    dataType: 'json',
    type: 'post',
    data: {
      action: 'einvappmy_storefront_myeinvoice_request',
      order_id: einvappmyData.order_id,
      nonce: einvappmyData.nonce
    },
    beforeSend: function () {
      jQuery('.btn-loading').show();
    },
    complete: function () {
      jQuery('.btn-loading').hide();
    },
    success: function (data) {
      if (data.success && data.data.eInvoiceUrl) {
        jQuery('.myeinvoice-block [status="request_success"]').show();
        jQuery('.myeinvoice-block [status="not-requested"]').hide();
        jQuery('#request_einvoice_qr').attr('href', data.data.eInvoiceUrl);
        jQuery('#request_einvoice_link').attr('href', data.data.eInvoiceUrl);
        new QRCode(document.getElementById("request_einvoice_qr_image"), {
          text: data.data.eInvoiceUrl,
          width: 128,
          height: 128,
        });

        jQuery('#einvoice_status').text('Created').attr('class', 'status-badge status-created').css('background-color', 'rgb(153, 153, 153)');
      }
    }
  })
}
