jQuery(document).ready(function ($) {
  $.ajax({
    url: einvappmySettingsData.get_msi_sub_categories_codes_url,
    method: "GET",
    dataType: "json",
    success: function (data) {
      var option = "";
      for (var i = 0; i < data.length; i++) {
        option += '<option value="' + data[i].Code + '">' + data[i].Description + "</option>";
      }

      $("#classification_selector").html(option);
      $("#classification_selector").val(einvappmySettingsData.client_details?.classification_code || '');
      $("#classification_selector").trigger("change");
      $("#classification_selector").select2({
        placeholder: "Select an option",
      });
      $("#classification_selector").on("select2:select", function (e) {
        var data = e.params.data;
        $("#classification_name").val(data.text);
        $("#classification_code").val(data.id);
      });
    },
  });

  jQuery(document).on("change", "#o2omyeinvois_status", function (event) {
    event.preventDefault();

    jQuery("#form").append('<input type="hidden" name="' + einvappmySettingsData.config.option_name + '[statusonly]" value="1" />');

    setTimeout(function () {
      jQuery('#form input[type="submit"]').click();
    }, 100);
  });
});

jQuery(document).on('change', '#company_identification_type', function () {
  // make all info to display none first by default
  jQuery('#company_identification_type_info p').addClass('d-none');

  let type = jQuery(this).val();

  jQuery('.company_identification_type_info_' + type).removeClass('d-none');
});

jQuery('#company_identification_type').trigger('change');
