jQuery(document).ready(function($) {
    // Filter by level
    $('#log-level-filter').on('change', function() {
        filterLogs();
    });

    // Search logs
    $('#log-search').on('keyup', function() {
        filterLogs();
    });

    // Filter function
    function filterLogs() {
        const selectedLevel = $('#log-level-filter').val();
        const searchTerm = $('#log-search').val().toLowerCase();
        let visibleCount = 0;

        $('#log-table tbody tr.log-entry').each(function() {
            const $row = $(this);
            const level = $row.data('level');
            const message = $row.find('.log-message').text().toLowerCase();
            const timestamp = $row.find('.log-timestamp').text().toLowerCase();

            const levelMatch = (selectedLevel === 'all' || level === selectedLevel);
            const searchMatch = (searchTerm === '' || message.includes(searchTerm) || timestamp.includes(searchTerm));

            if (levelMatch && searchMatch) {
                $row.removeClass('hidden');
                visibleCount++;
            } else {
                $row.addClass('hidden');
            }
        });

        $('#visible-count').text(visibleCount);
    }

    // Refresh logs
    $('#refresh-logs').on('click', function() {
        location.reload();
    });

    // Clear logs
    $('#clear-logs').on('click', function() {
        if (confirm('Are you sure you want to clear all logs? This action cannot be undone.')) {
            // Add AJAX call to clear logs
            $.post(einvappmyLogData.ajax_url, {
                action: 'clear_einvoice_logs',
                nonce: einvappmyLogData.nonce
            }, function(response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert('Failed to clear logs: ' + response.data.message);
                }
            });
        }
    });
});

