jQuery(document).ready(function ($) {
  getConsolidatedInvoice();

  $("#consolidated-fetch-orders").click(function () {
    $("#select-orders-container").removeClass("d-none");
    $("#select-orders-container .loading-message").removeClass("d-none");
    $("#sales-amount-container").removeClass("d-none");

    let order_statuses = jQuery('input[name="consolidated_order_statuses[]"]:checked')
      .map(function () {
        return this.value;
      })
      .get();

    jQuery.ajax({
      url: einvappmyConsolidatedData.ajax_url,
      type: "GET",
      data: {
        action: "einvappmy_consolidated_fetch_orders",
        order_statuses: order_statuses,
        view: "html",
        nonce: einvappmyConsolidatedData.nonce_consolidated_get_orders,
      },
      success: function (response) {
        jQuery("#select-orders-container .loading-message").addClass("d-none");

        jQuery("#consolidated-orders-table-container").html(response.data.html);
        jQuery('#consolidated-orders-table-container table input[type="checkbox"]').prop("checked", true);

        jQuery("#total-sales-amount").text(response.data.total_order_amount);
        jQuery("#total-order-found").text(response.data.total_orders);

        jQuery("#input_consolidated_sales_amount").val(response.data.total_order_amount);
        jQuery("#input_consolidated_tax_amount").val(response.data.total_order_tax_amount);
      },
    });
  });
});

function getCheckedOrdersTotalAmount() {
  let total_amount = 0;

  jQuery('#consolidated-orders-table-container table tbody input[type="checkbox"]:checked').each(function () {
    let amount = jQuery(this).attr("data-amount");

    total_amount += parseFloat(amount);
  });

  total_amount = total_amount.toFixed(2);

  return total_amount;
}

jQuery(document).on("change", '#consolidated-orders-table-container table input[type="checkbox"]', function () {
  let total_amount = getCheckedOrdersTotalAmount();
  let total_tax_amount = getCheckedOrdersTotalTaxAmount();

  jQuery("#input_consolidated_sales_amount").val(total_amount);
  jQuery("#input_consolidated_tax_amount").val(total_tax_amount);

  jQuery("#total-sales-amount").text(total_amount);
  jQuery("#total-order-found").text(jQuery('#consolidated-orders-table-container table tbody input[type="checkbox"]:checked').length);
});

jQuery(document).on("click", "#button-submit-consolidated", function () {
  const currencyCode = einvappmyConsolidatedData.consolidated_currency_code;
  const descriptionDate = einvappmyConsolidatedData.consolidated_date;
  const total = jQuery("#input_consolidated_sales_amount").val();
  const taxTotal = jQuery("#input_consolidated_tax_amount").val();

  let selectedOrderIds = [];

  jQuery('#consolidated-orders-table-container table tbody input[type="checkbox"]:checked').each(function () {
    selectedOrderIds.push(jQuery(this).val());
  });

  if (selectedOrderIds.length <= 0) {
    alert("Please select at least one order to consolidate.");
    return;
  }

  submitConsolidatedEinvoice({ currencyCode, descriptionDate, total, taxTotal, selectedOrderIds });
});

function getCheckedOrdersTotalTaxAmount() {
  let total_tax_amount = 0;

  jQuery('#consolidated-orders-table-container table tbody input[type="checkbox"]:checked').each(function () {
    let amount = jQuery(this).attr("data-tax-amount");

    total_tax_amount += parseFloat(amount);
  });

  total_tax_amount = total_tax_amount.toFixed(2);

  return total_tax_amount;
}

jQuery(document).on("click", "#button-download-order-list", function () {
  let selectedOrderIds = [];

  jQuery('#consolidated-orders-table-container table tbody input[type="checkbox"]:checked').each(function () {
    selectedOrderIds.push(jQuery(this).val());
  });

  downloadConsolidatedExcel(selectedOrderIds);
});

jQuery(document).on("click", "#button-cancel-consolidated", function () {
  cancelConsolidatedEinvoice();
});

function getConsolidatedInvoice() {
  jQuery(".alert-cancel-consolidated").remove();

  jQuery.ajax({
    url: einvappmyConsolidatedData.ajax_url,
    type: "POST",
    dataType: "json",
    data: {
      action: "einvappmy_get_consolidated_invoice",
      nonce: einvappmyConsolidatedData.nonce_consolidated_get,
    },
    beforeSend: function () {
      let html = ``;
      html += `<tr>`;
      html += `<td colspan="4">`;
      html += `<img src="${einvappmyConsolidatedData.loading_image_url}" class="icon-submiting-consolidated" /> Retrieving consolidated e-invoice...`;
      html += `</td>`;
      html += `</tr>`;

      jQuery("#table-submitted-consolidated tbody").html(html);
    },
    success: function (response) {
      let html = ``;

      if (!response.success) {
        html += `<tr>`;
        html += `<td colspan="4">No consolidated e-invoice found.</td>`;
        html += `</tr>`;

        jQuery("#button-submit-consolidated").attr("disabled", false).removeClass("disabled");
      }

      if (response.success) {
        html += `<tr>`;
        html += `<td>${response.data.date_time}</td>`;
        html += `<td>${response.data.amount}</td>`;

        if (response.data.validation_url) {
          html += `<td><a href="${response.data.validation_url}" target="_blank">View Validation</a></td>`;
        } else {
          html += `<td>--</td>`;
        }

        html += `<td><span class="badge" style="background: ${response.data.status_color};">${response.data.status_text}</span></td>`;
        html += `</tr>`;

        let cancelConsolidatedButtonHtml = `<button class="button button-primary" id="button-cancel-consolidated">${einvappmyConsolidatedData.cancel_button_text || 'Cancel Consolidated E-invoice'}</button>`;
        jQuery("#submitted-consolidated-buttons").html(cancelConsolidatedButtonHtml);

        let html2 = `<input type="hidden" id="consolidated-invoice-code" value="${response.data.invoice_code}">`;
        jQuery("#table-submitted-consolidated").after(html2);

        jQuery("#button-submit-consolidated").attr("disabled", true).addClass("disabled");
      }

      jQuery("#table-submitted-consolidated tbody").html(html);
    },
    error: function (errorThrown) {
      alert(errorThrown);
    },
  });
}

function downloadConsolidatedExcel(orderIds) {
  var consolidatedDate = einvappmyConsolidatedData.consolidated_date;

  // Create a form to submit the download request
  var form = document.createElement("form");
  form.method = "POST";
  form.action = einvappmyConsolidatedData.ajax_url;
  form.style.display = "none";

  // Add action field
  var actionField = document.createElement("input");
  actionField.type = "hidden";
  actionField.name = "action";
  actionField.value = "einvappmy_download_consolidated_excel";
  form.appendChild(actionField);

  // Add nonce field
  var nonceField = document.createElement("input");
  nonceField.type = "hidden";
  nonceField.name = "nonce";
  nonceField.value = einvappmyConsolidatedData.nonce_consolidated_download_excel;
  form.appendChild(nonceField);

  // Add consolidated date field
  var dateField = document.createElement("input");
  dateField.type = "hidden";
  dateField.name = "consolidated_date";
  dateField.value = consolidatedDate;
  form.appendChild(dateField);

  // Add order IDs field
  var orderIdsField = document.createElement("input");
  orderIdsField.type = "hidden";
  orderIdsField.name = "order_ids";
  orderIdsField.value = JSON.stringify(orderIds);
  form.appendChild(orderIdsField);

  // Submit the form
  document.body.appendChild(form);
  form.submit();
  document.body.removeChild(form);
}

function submitConsolidatedEinvoice(data) {
  jQuery(".alert-submit-consolidated").remove();

  let { currencyCode, descriptionDate, total, taxTotal, selectedOrderIds } = data;

  jQuery.ajax({
    url: einvappmyConsolidatedData.ajax_url,
    type: "POST",
    dataType: "json",
    data: {
      action: "einvappmy_submit_consolidated",
      nonce: einvappmyConsolidatedData.nonce_consolidated_submit,
      description_date: descriptionDate,
      currency_code: currencyCode,
      total: total,
      tax_total: taxTotal,
      selected_order_ids: selectedOrderIds,
    },
    beforeSend: function () {
      jQuery("#button-submit-consolidated").after(`<img src="${einvappmyConsolidatedData.loading_image_url}" class="icon-submiting-consolidated" />`);
    },
    success: function (response) {
      jQuery(".icon-submiting-consolidated").remove();

      if (!response.success) {
        jQuery("#button-submit-consolidated")
          .parent()
          .before('<div class="alert alert-error alert-submit-consolidated">' + response.message + "</div>");
      }

      if (response.success) {
        jQuery("#button-submit-consolidated")
          .parent()
          .before('<div class="alert alert-success alert-submit-consolidated">' + response.message + "</div>");

        getConsolidatedInvoice();
      }
    },
    error: function (errorThrown) {
      alert(errorThrown);
    },
  });
}

function cancelConsolidatedEinvoice() {
  jQuery(".alert-cancel-consolidated").remove();
  jQuery(".icon-submiting-consolidated").remove();

  const invoiceCode = jQuery("#consolidated-invoice-code").val();

  jQuery.ajax({
    url: einvappmyConsolidatedData.ajax_url,
    type: "POST",
    dataType: "json",
    data: {
      action: "einvappmy_cancel_consolidated",
      invoice_code: invoiceCode,
      nonce: einvappmyConsolidatedData.nonce_consolidated_cancel,
    },
    beforeSend: function () {
      jQuery("#button-cancel-consolidated").after(`<img src="${einvappmyConsolidatedData.loading_image_url}" class="icon-submiting-consolidated" />`);
    },
    success: function (response) {
      jQuery(".icon-submiting-consolidated").remove();

      if (!response.success) {
        let html = `<div class="alert alert-error alert-cancel-consolidated">${response.error_desc}</div>`;
        jQuery("#submitted-consolidated-buttons").parent().before(html);
        return;
      }

      if (response.success) {
        let html = `<div class="alert alert-success alert-cancel-consolidated">${response.msg}</div>`;
        jQuery("#submitted-consolidated-buttons").before(html);

        jQuery("#button-cancel-consolidated").remove();

        getConsolidatedInvoice();
      }
    },
    error: function (errorThrown) {
      alert(errorThrown);
    },
  });
}
