(function($) {
    'use strict';

    $(document).ready(function() {
        // Check if jQuery UI Dialog is available
        if (typeof $.fn.dialog === 'undefined') {
            console.error('jQuery UI Dialog is not loaded!');
            return;
        }

        // Create dialog HTML structure (hidden by default)
        var dialogHtml = '<div id="einvoice-note-dialog" style="display:none;">' +
            '<form id="einvoice-note-form">' +
                '<div id="refund-note-info" style="display: none; margin-bottom: 15px; padding: 12px; background-color: #e7f3ff; border-left: 4px solid #2271b1; color: #2c3338;">' +
                    '<span style="font-size: 13px;"><strong>ℹ️ Info:</strong> You should only issue Refund Note if you are refunding an amount to the customer.</span>' +
                '</div>' +
                '<div style="margin-bottom: 15px;">' +
                    '<label for="note-amount" style="display: block; margin-bottom: 5px; font-weight: 600;">Amount:</label>' +
                    '<input type="number" id="note-amount" name="amount" step="0.01" min="0.01" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;" required />' +
                    '<span id="amount-error" style="color: #dc3232; font-size: 12px; display: none; margin-top: 5px;">Please enter a valid amount greater than 0.</span>' +
                '</div>' +
                '<div>' +
                    '<label for="note-description" style="display: block; margin-bottom: 5px; font-weight: 600;">Description:</label>' +
                    '<textarea id="note-description" name="description" rows="4" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px; resize: vertical;" required></textarea>' +
                    '<span id="description-error" style="color: #dc3232; font-size: 12px; display: none; margin-top: 5px;">Please enter a description.</span>' +
                '</div>' +
            '</form>' +
        '</div>';
        
        // Append dialog to body (only if it doesn't exist)
        if ($('#einvoice-note-dialog').length === 0) {
            $('body').append(dialogHtml);
        }
        
        // Handle all action button clicks with confirmation
        $('.einvoice-action-btn').on('click', function(e) {
            e.preventDefault();
            
            var $button = $(this);
            var action = $button.data('action');
            var targetUrl = $button.attr('href');
            
            console.log('Action button clicked:', action);
            
            // Actions that require amount and description input
            var inputActions = ['debit-note', 'credit-note', 'refund-note'];
            
            if (inputActions.indexOf(action) !== -1) {
                console.log('Opening dialog for:', action);
                // Show jQuery UI Dialog for amount and description
                var actionTitle = action.replace(/-/g, ' ').replace(/\b\w/g, function(l) {
                    return l.toUpperCase();
                });
                
                // Update labels based on action type
                var amountLabel = 'Adjustment amount for the ' + actionTitle;
                $('#einvoice-note-dialog').find('label[for="note-amount"]').text(amountLabel);
                $('#einvoice-note-dialog').find('label[for="note-description"]').text('Note Description');
                $('#note-description').attr('placeholder', 'Price adjustment for order#');
                
                // Show info message only for Refund Note
                if (action === 'refund-note') {
                    $('#refund-note-info').show();
                } else {
                    $('#refund-note-info').hide();
                }
                
                // Reset form and errors
                $('#einvoice-note-form')[0].reset();
                $('#amount-error, #description-error').hide();
                
                // Initialize and open dialog
                $('#einvoice-note-dialog').dialog({
                    title: 'Create ' + actionTitle,
                    modal: true,
                    width: 500,
                    buttons: {
                        'Create': function() {
                            var amount = $('#note-amount').val().trim();
                            var description = $('#note-description').val().trim();
                            var hasError = false;
                            
                            // Reset errors
                            $('#amount-error, #description-error').hide();
                            
                            // Validate amount
                            if (amount === '' || isNaN(amount) || parseFloat(amount) <= 0) {
                                $('#amount-error').show();
                                hasError = true;
                            }
                            
                            // Validate description
                            if (description === '') {
                                $('#description-error').show();
                                hasError = true;
                            }
                            
                            if (!hasError) {
                                // Append amount and description to the URL
                                var separator = targetUrl.indexOf('?') !== -1 ? '&' : '?';
                                var finalUrl = targetUrl + separator + 'amount=' + encodeURIComponent(amount) + '&description=' + encodeURIComponent(description);
                                
                                // Close dialog and redirect
                                $(this).dialog('close');
                                window.location.href = finalUrl;
                            }
                        },
                        'Cancel': function() {
                            $(this).dialog('close');
                        }
                    },
                    close: function() {
                        // Reset form when dialog is closed
                        $('#einvoice-note-form')[0].reset();
                        $('#amount-error, #description-error').hide();
                    }
                });
                
            } else if (action === 'cancel-invoice') {
                // Handle cancel invoice with confirmation
                var confirmMessage = 'Are you sure you want to cancel this invoice?\n\n⚠️ WARNING: This action is irreversible!';
                
                if (confirm(confirmMessage)) {
                    window.location.href = targetUrl;
                }
            } else {
                // For any other action, just proceed
                window.location.href = targetUrl;
            }
        });
    });

})(jQuery);

