<?php
/**
 * Twig Template Engine Class
 *
 * @package Edidev\AiAssistantForPerfection42\Views
 */

// phpcs:disable WordPress.Files.FileName.NotHyphenatedLowercase, WordPress.Files.FileName.InvalidClassFileName

namespace Edidev\AiAssistantForPerfection42\Views;

use Edidev\AiAssistantForPerfection42\Includes\ServiceProvider\ServiceProvider;
use Twig\Environment;
use Twig\Loader\FilesystemLoader;

/**
 * Class TwigTemplateEngine
 *
 * @package Edidev\AiAssistantForPerfection42\Views
 */
class TwigTemplateEngine extends ServiceProvider {
	/**
	 * Properties
	 */

	/** Loader instance.
	 *
	 * @var object
	 */
	private $loader;

	/** Twig environment instance.
	 *
	 * @var \Twig\Environment
	 */
	private $twig_instance;

	/** Path to views directory.
	 *
	 * @var string
	 */
	private $view_path;

	/**
	 * Constructor
	 *
	 * @param array $args Optional. Arguments to configure the environment.
	 **/
	public function __construct( $args = array() ) {
		parent::__construct( $args );
		$this->view_path = __DIR__ . '/Parts';
	}

	/**
	 * Boot method
	 *
	 * @return void
	 **/
	protected function boot(): void {
		/**
		 * Register some further things if needed later on
		 */
	}

	/**
	 * Load template
	 *
	 * @return void
	 **/
	protected function load(): void {
		$this->loader        = new FilesystemLoader( $this->view_path );
		$this->twig_instance = new Environment(
			$this->loader,
			array()
		);

		$this->twig_instance->addFunction(
			new \Twig\TwigFunction(
				'perfection_ai_shortcode',
				function () {
					return do_shortcode( '[edidev_perfection_ai_shortcode]' );
				}
			)
		);
	}

	/**
	 * Get instance of Twig
	 *
	 * @param array $args Optional. Arguments to configure the environment.
	 * @return Environment
	 **/
	public static function INSTANCE( $args = array() ): Environment {
		$instance = new self( $args );

		$instance->boot();
		$instance->load();
		return $instance->twig_instance;
	}
}
