<?php
/**
 * WooCommerce Repository Class
 *
 * @package Edidev\AiAssistantForPerfection42\Includes\WooCommerce
 */

// phpcs:disable WordPress.Files.FileName.NotHyphenatedLowercase, WordPress.Files.FileName.InvalidClassFileName

namespace Edidev\AiAssistantForPerfection42\Includes\WooCommerce;

use Edidev\AiAssistantForPerfection42\Main;

/**
 * WooCommerce Repository.
 */
class WooCommerceRepository {

	/**
	 * Constructor.
	 */
	public function __construct() {
	}

	/**
	 * Declare WooCommerce HPOS compatibility.
	 *
	 * @return void
	 */
	public function add_product_actions_list() {
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$post_type = isset( $_GET['post_type'] ) ? sanitize_text_field( wp_unslash( $_GET['post_type'] ) ) : '';

		if ( 'product' === $post_type ) {
			$assets_url = Main::plugin_asset_url();
			echo '<div class="actions">';
			echo '<button class="p42-gen-button p42-gen-button--toolbar" type="button" disabled aria-label="' . esc_attr__( 'Open Perfection42 Generation', 'edidev-ai-assistant-for-perfection42' ) . '">';
			echo '<span class="p42-gen-button__inner">'
				. '<img class="p42-logo" src="' . esc_url( $assets_url . '/images/plugin-brand-logo.svg' ) . '" alt="" aria-hidden="true" />'
				. '<span class="p42-label">' . esc_html__( 'Generation', 'edidev-ai-assistant-for-perfection42' ) . '</span>'
				. '<img class="p42-generate-icon" src="' . esc_url( $assets_url . '/images/generate-icon.svg' ) . '" alt="" aria-hidden="true" />'
				. '</span>';
			echo '</button>';
			echo '</div>';
		}
	}

	/**
	 * Add product actions on product list page.
	 *
	 * @param WP_Post $post The current post object.
	 * @return void
	 */
	public function add_product_actions( $post ) {
		$post_type = get_post_type( $post );

		if ( 'product' === $post_type ) {
			$assets_url = Main::plugin_asset_url();
			echo '<div class="actions">';
			echo '<button class="p42-gen-button p42-gen-button--primary p42-gen-button--edit" type="button" aria-label="' . esc_attr__( 'Open Perfection42 Generation', 'edidev-ai-assistant-for-perfection42' ) . '">';
			echo '<span class="p42-gen-button__inner">'
				. '<img class="p42-logo" src="' . esc_url( $assets_url . '/images/plugin-brand-logo.svg' ) . '" alt="" aria-hidden="true" />'
				. '<span class="p42-label">' . esc_html__( 'Generation', 'edidev-ai-assistant-for-perfection42' ) . '</span>'
				. '<img class="p42-generate-icon" src="' . esc_url( $assets_url . '/images/generate-icon.svg' ) . '" alt="" aria-hidden="true" />'
				. '</span>';
			echo '</button>';
			echo '</div>';
		}
	}
}
