<?php
/**
 * Dev Mode Helper
 *
 * Centralizes the logic for checking whether development mode is enabled.
 * When enabled, certain REST API permission and validation checks are bypassed.
 *
 * @package Edidev\AiAssistantForPerfection42\Includes\RestApi
 */

// phpcs:disable WordPress.Files.FileName.NotHyphenatedLowercase, WordPress.Files.FileName.InvalidClassFileName

namespace Edidev\AiAssistantForPerfection42\Includes\RestApi;

/**
 * Class DevModeHelper
 */
class DevModeHelper {
	/**
	 * Determine if dev mode is enabled.
	 *
	 * Accepts either string "true" (case-insensitive) or boolean true for the
	 * PERFECTION_DEV_MODE constant.
	 *
	 * @return bool
	 */
	public static function is_enabled(): bool {
		if ( ! defined( 'PERFECTION_DEV_MODE' ) ) {
			return false;
		}

		$value = PERFECTION_DEV_MODE;
		if ( is_bool( $value ) ) {
			return (bool) $value;
		}

		if ( is_string( $value ) ) {
			return 'true' === strtolower( trim( $value ) );
		}

		// Fallback: treat truthy non-empty values as enabled, but prefer strict above.
		return ! empty( $value );
	}
}
