<?php
/**
 * Plugin Name: EdiDev AI Assistant for Perfection42
 * Plugin URI: https://p42wp.com/
 * Description: AI-powered product assistant, developed by EdiDev in collaboration with Perfection42.
 * Version: 1.0.12
 * Author: EdiDev
 * Author URI: https://edidev.online/
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: edidev-ai-assistant-for-perfection42
 * Domain Path: /languages
 * Requires at least: 6.0
 * Tested up to: 6.9
 * Requires PHP: 7.4
 * WC requires at least: 6.0
 * WC tested up to: 10.4
 * Stable tag: 1.0.12
 *
 * @package Edidev\AiAssistantForPerfection42
 */

// phpcs:disable WordPress.Files.FileName.NotHyphenatedLowercase, WordPress.Files.FileName.InvalidClassFileName

use Edidev\AiAssistantForPerfection42\Main;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

require __DIR__ . '/vendor/autoload.php';

/**
 * Main plugin class.
 */
class EdidevAIAssistantForPerfection42 {


	/**
	 * Constructor.
	 */
	public function __construct() {

		register_activation_hook( __FILE__, array( Main::class, 'install' ) );
		register_deactivation_hook( __FILE__, array( Main::class, 'uninstall' ) );

		add_action(
			'plugins_loaded',
			array(
				Main::instance(
					array(
						'plugin-url'         => plugin_dir_url( __FILE__ ),
						'plugin-basename'    => plugin_basename( __FILE__ ),
						'plugin-dir'         => __DIR__,
						'wordpress-root-dir' => dirname( __DIR__, 3 ),
					)
				),
				'run',
			)
		);

		add_action( 'wp_privacy_policy_content', array( Main::class, 'perfection42_privacy_policy_content' ) );
	}

	/**
	 * Initializes the plugin instance.
	 *
	 * @return void
	 */
	public static function instance(): void {
		( new self() );
	}
}

EdidevAIAssistantForPerfection42::instance();
