/**
 * Modal Perfection.
 */
(function ($) {
	$( document ).ready(
		function () {
			'use strict';

			// ---------- Helpers ----------.
			function openModalWithIds(ids) {
				window.postMessage(
					{
						action: 'post_message_to_react_app',
						is_open_modal: true,
						ids: ids
					}
				);

				$( '#edidev-perfection-ai-nextjs-component-root' ).show();
				const body = $( 'body' );
				if ( ! body.hasClass( 'edidev-ai-assistant-for-perfection42-modal-open' )) {
					body.addClass( 'edidev-ai-assistant-for-perfection42-modal-open' );
				}
				$( '#wpadminbar' ).hide();
			}

			function getAssetsUrl() {
				try {
					const cfg = window.EDIDEV_AI_ASSISTANT_FOR_PERFECTION42_WP_CONST || {};
					// pluginRootUrl points to plugin base url; append /assets.
					return (cfg.pluginRootUrl ? (cfg.pluginRootUrl + '/assets') : '');
				} catch (e) {
					return '';
				}
			}

			function createEditButton() {
				const assets = getAssetsUrl();
				const $btn   = $(
					'<button type="button" class="p42-gen-button p42-gen-button--primary p42-gen-button--edit p42-gen-button--compact" aria-label="Open Perfection42 Generation">\
                    <span class="p42-gen-button__inner">\
                        <img class="p42-logo" alt="" aria-hidden="true" />\
                        <span class="p42-label">' + (window.wp && window.wp.i18n ? wp.i18n.__( 'Generation', 'edidev-ai-assistant-for-perfection42' ) : 'Generation') + '</span>\
                        <img class="p42-generate-icon" alt="" aria-hidden="true" />\
                    </span>\
                </button>'
				);
				$btn.find( '.p42-logo' ).attr( 'src', assets + '/images/plugin-brand-logo.svg' );
				$btn.find( '.p42-generate-icon' ).attr( 'src', assets + '/images/generate-icon.svg' );
				return $btn;
			}

			// ---------- Product list screen: enable/disable + open ----------.
			function updateToolbarButtonState() {
				const anyChecked = $( 'input[name="post[]"]:checked' ).length > 0;
				$( '.p42-gen-button--toolbar' ).prop( 'disabled', ! anyChecked );
			}

			// Selection toggles state.
			$( document ).on(
				'change',
				'#cb-select-all-1, input[name="post[]"]',
				function () {
					updateToolbarButtonState();
				}
			);

			// Open from toolbar button.
			$( document ).on(
				'click',
				'.p42-gen-button--toolbar',
				function () {
					if ($( this ).prop( 'disabled' )) {
						return;
					}
					const checkedValues = $( 'input[name="post[]"]:checked' )
					.map(
						function () {
							return $( this ).val(); }
					)
					.get();
					if (checkedValues.length) {
						openModalWithIds( checkedValues );
					}
				}
			);

			// Initialize state on load (list screen only).
			updateToolbarButtonState();

			// ---------- Product edit screen: open + placements ----------.
			// Delegated handler for all edit buttons (original and clones).
			$( document ).on(
				'click',
				'.p42-gen-button--edit',
				function () {
					const productId = $( '#post_ID' ).val();
					if (productId) {
						openModalWithIds( [productId] );
					}
				}
			);

			function placeButtonsOnEditScreen() {
				// Right side of Add Media in main description.
				const $contentBtns = $( '#wp-content-media-buttons' );
				if ($contentBtns.length && $contentBtns.find( '.p42-gen-button--edit' ).length === 0) {
					const $after = $contentBtns.find( '.insert-media' ).first();
					if ($after.length) {
						createEditButton().insertAfter( $after );
					}
				}

				// Right side of Add Media in short description.
				const $excerptBtns = $( '#wp-excerpt-media-buttons' );
				if ($excerptBtns.length && $excerptBtns.find( '.p42-gen-button--edit' ).length === 0) {
					const $after2 = $excerptBtns.find( '.insert-media' ).first();
					if ($after2.length) {
						createEditButton().insertAfter( $after2 );
					}
				}

				// Featured image metabox (top-left).
				const $featuredInside = $( '#postimagediv .inside' );
				if ($featuredInside.length && $featuredInside.children( '.p42-gen-button--edit' ).length === 0) {
					$featuredInside.prepend( createEditButton() );
				}

				// Gallery images metabox (top-left) - check common containers.
				const gallerySelectors = ['#woocommerce-product-images .inside', '#product_images_container .inside', '#product_images'];
				gallerySelectors.forEach(
					function (sel) {
						const $c = $( sel );
						if ($c.length && $c.find( '.p42-gen-button--edit' ).length === 0) {
							// Prepend to be top-left in the container
							$c.prepend( createEditButton() );
						}
					}
				);
			}

			// Run once on ready.
			placeButtonsOnEditScreen();

			// Observe DOM changes to handle panels loaded later.
			const observer = new MutationObserver(
				function () {
					placeButtonsOnEditScreen();
				}
			);
			observer.observe( document.body, { childList: true, subtree: true } );

			// ---------- Modal close listener (unchanged) ----------
			window.addEventListener(
				'message',
				function (event) {
					if (event.data.action === 'close_modal_from_react' && event.data.should_close_modal) {
						$( '#edidev-perfection-ai-nextjs-component-root' ).hide();
						$( '.modal-backdrop' ).remove();
						const body = $( 'body' );
						body.removeClass( 'modal-open' );
						body.removeClass( 'edidev-ai-assistant-for-perfection42-modal-open' );
						$( '#wpadminbar' ).show();
					}
				}
			);
		}
	);
})( jQuery );
