/**
 * Import WordPress i18n module.
 */
const { __ } = wp.i18n;

(function ($) {
	"use strict";
	window.edidevPerfection                        = window.edidevPerfection || {};
	window.edidevPerfection.wpMediaLib             = wp || null;
	window.edidevPerfection.wpAjaxUrl              = ajaxurl || null;
	window.edidevPerfection.jqueryWPMediaComponent = (function () {
		const module = {};
		let data;
		let galleryData;

		module.init = function () {
			module.mediaUploader            = mediaUploader;
			module.productGallery           = productGallery;
			module.getDataLoaded            = getDataLoaded;
			module.getGalleryData           = getGalleryData;
			module.getProductThumbnailImage = getProductThumbnailImage;
			module.setProductThumbnailImage = setProductThumbnailImage;

			return module;
		};

		const productGallery = function (e) {
			if (window.edidevPerfection.wpMediaLib !== null) {
				const image = window.edidevPerfection.wpMediaLib
				.media(
					{
						title: __( "Upload Image", "edidev-perfection42-ai-product-assistant" ),
						multiple: true,
					}
				)
				.open()
				.on(
					"select",
					function () {
						const uploaded_image           = image.state().get( "selection" );
						const uploaded_image_json_data = uploaded_image.toJSON();
						galleryData                    = JSON.stringify( uploaded_image_json_data );
					}
				);
			}
		};

		const asyncAjaxSetProductThumbnailImage = function (postID, thumbnailID) {
			if (window.edidevPerfection.wpAjaxUrl !== null) {
				return new Promise(
					function (resolve, reject) {
						$.ajax(
							{
								url: window.edidevPerfection.wpAjaxUrl,
								type: "POST",
								data: {
									action: "set_product_thumbnail_image",
									postID: postID,
									thumbnailID: thumbnailID,
								},
								beforeSend: function () {},
								success: function (data) {
										resolve( data ); // Resolve promise and when success.
								},
								error: function (err) {
									reject( err ); // Reject the promise and go to catch().
								},
							}
						);
					}
				);
			}
		};

		const asyncAjaxGetProductThumbnailImage = function (postID) {
			if (window.edidevPerfection.wpAjaxUrl !== null) {
				return new Promise(
					function (resolve, reject) {
						$.ajax(
							{
								url: window.edidevPerfection.wpAjaxUrl,
								type: "POST",
								data: {
									action: "get_product_thumbnail_image",
									postID: postID,
								},
								beforeSend: function () {},
								success: function (data) {
										resolve( data ); // Resolve promise and when success.
								},
								error: function (err) {
									reject( err ); // Reject the promise and go to catch().
								},
							}
						);
					}
				);
			}
		};

		const setProductThumbnailImage = async function (postID, thumbnailID) {
			try {
				return await asyncAjaxSetProductThumbnailImage( postID, thumbnailID );
			} catch (e) {
				console.log( e );
			}

			return null;
		};

		const getProductThumbnailImage = async function (postID) {
			try {
				return await asyncAjaxGetProductThumbnailImage( postID );
			} catch (e) {
				console.log( e );
			}

			return null;
		};

		const getGalleryData = function () {
			return galleryData;
		};

		const getDataLoaded = function () {
			return data;
		};

		const mediaUploader = function () {
			if (window.edidevPerfection.wpMediaLib !== null) {
				const image = window.edidevPerfection.wpMediaLib
				.media(
					{
						title: __( "Upload Image", "edidev-perfection42-ai-product-assistant" ),
						multiple: false,
					}
				)
				.open()
				.on(
					"select",
					function () {
						const uploadedImage         = image.state().get( "selection" ).first();
						const uploadedImageJsonData = uploadedImage.toJSON();
						data                        = JSON.stringify( uploadedImageJsonData );
					}
				);
			}
		};

		return module.init();
	})();
})( jQuery );
