<?php
/**
 * Smooth Scroll
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
function edgeex_smooth_scroll_admin(){
	require_once EDGEEX_PLUGIN_DIR . '/inc/smooth-scroll/smooth-scroll-admin.php';
}

function edgeex_smooth_scroll_options_init() {
	$edgeex_args = array('smooth-scroll', __( 'Smooth Scroll', 'edge-expansion' ),'edgeex_smooth_scroll_options','edgeex_smooth_scroll_admin');
	edgeex_argument($edgeex_args);
}
add_action( 'edgeex_component_init', 'edgeex_smooth_scroll_options_init' );



function edgeex_get_smooth_scroll_options_default() {
	$default_options = array(
		'speed' => '800',
		'effect' => 'swing',
	);
	return apply_filters( 'edgeex_smooth_scroll_default', $default_options );
}

// Loading scripts and styles
function edgeex_smooth_scroll_enqueue_assets() {
    $options = get_option('edgeex_smooth_scroll_options', [
        'speed' => 800,
        'effect' => 'easeInOutCubic',
    ]);

    wp_enqueue_script('smooth-scroll-js', EDGEEX_PLUGIN_URL . '/inc/smooth-scroll/assets/js/smooth-scroll.js', ['jquery'], '1.0.0', true);

	wp_enqueue_script('jquery-easing', EDGEEX_PLUGIN_URL . '/inc/smooth-scroll/assets/js/jquery.easing.min.js', ['jquery'], '1.0.0', true);

    wp_localize_script('smooth-scroll-js', 'edgeex_smoothScrollSettings', [
        'speed' => intval($options['speed']),
        'effect' => sanitize_text_field($options['effect']),
    ]);

    wp_enqueue_style('smooth-scroll-css', EDGEEX_PLUGIN_URL . '/inc/smooth-scroll/assets/css/smooth-scroll.css', array(), '1.0.0');
}
add_action('wp_enqueue_scripts', 'edgeex_smooth_scroll_enqueue_assets');
