<?php
if (!defined('ABSPATH')) exit;

if(isset($_POST['edgeex_smooth_scroll_options']) && check_admin_referer( 'smooth_scroll_action', 'smooth_scroll_nonce_field' )){
    $options = array(
        'speed'  => isset($_POST['edgeex_smooth_scroll_options']['speed']) ? intval( wp_unslash($_POST['edgeex_smooth_scroll_options']['speed']) ):'600',
        'effect' => isset($_POST['edgeex_smooth_scroll_options']['effect']) ? sanitize_text_field( wp_unslash($_POST['edgeex_smooth_scroll_options']['effect']) ):'linear'
    );
    update_option( 'edgeex_smooth_scroll_options', $options );

    echo '<div class="updated"><p>'.esc_html__('Your settings are saved.','edge-expansion').'</p></div>';
}

    $edgeex_scroll_options = get_option('edgeex_smooth_scroll_options', [
        'speed' => '600',
        'effect' => 'linear'
    ]);
?>
    <h3 class="subt-txt"><?php esc_html_e( 'Smooth Scroll', 'edge-expansion' ); ?></h3>
    <div class="wrapper">
        <form method="post" action="">
            <?php
	            wp_nonce_field( 'smooth_scroll_action', 'smooth_scroll_nonce_field' );
            ?>
            <table class="form-table">
                <tr>
                    <th><?php esc_html_e('Scroll Speed','edge-expansion');?>(ms)</th>
                    <td><input type="number" name="edgeex_smooth_scroll_options[speed]" value="<?php if(isset($edgeex_scroll_options['speed'])) echo esc_attr( $edgeex_scroll_options['speed'] ); ?>" step="100" min="100" max="10000">
                    <p><?php esc_html_e('The higher the number, the slower the speed.','edge-expansion');?></p>
                </td>
                </tr>
                <tr>
                    <th>Easing</th>
                    <td>
                        <select name="edgeex_smooth_scroll_options[effect]">
                            <option value="linear" <?php if(isset($scroll_options['effect']) && $edgeex_scroll_options['effect']=='linear') selected( $edgeex_scroll_options['effect'], 'linear' ); ?>>Linear</option>
                            <option value="easeInOutCubic" <?php if(isset($edgeex_scroll_options['effect']) && $edgeex_scroll_options['effect']=='easeInOutCubic') selected( $edgeex_scroll_options['effect'], 'easeInOutCubic' ); ?>>easeInOutCubic</option>
                            <option value="easeInOutQuad" <?php if(isset($edgeex_scroll_options['effect']) && $edgeex_scroll_options['effect']=='easeInOutQuad') selected( $edgeex_scroll_options['effect'], 'easeInOutQuad' ); ?>>easeInOutQuad</option>
                            <option value="swing" <?php if(isset($edgeex_scroll_options['effect']) && $edgeex_scroll_options['effect']=='swing') selected( $edgeex_scroll_options['effect'], 'swing' ); ?>>Swing</option>
                        </select>
                        <p><ul>
                            <li>linear：<?php esc_html_e('Always the same speed','edge-expansion');?>
                            <li>easeInExpo：<?php esc_html_e('Starts very slowly, ends very quickly','edge-expansion');?>
                            <li>easeOutExpo：<?php esc_html_e('Starts very fast, ends very slowly','edge-expansion');?>
                            <li>swing：<?php esc_html_e('Gentle at the beginning, a little faster in the middle, gentle at the end','edge-expansion');?>
                        </ul></p>
                    </td>
                </tr>
                <tr>
	                <td colspan="2">
                    <input type="submit" name="submit" class="button-primary" value="<?php esc_html_e('Save Settings','edge-expansion'); ?>">
                    </td>
                </tr>
            </table>
        </form>
    </div>