<?php
/**
 * Related Posts
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function edgeex_related_posts_register_block() {
    
    //Asset file path
    $script_asset_path = EDGEEX_PLUGIN_DIR . '/inc/related-posts/build/index.asset.php';
    if ( ! file_exists( $script_asset_path ) ) {
      throw new Error(
        'You need to run `npm start` or `npm run build`'
      );
    }
    //Registering a block script
    $index_js     = 'build/index.js';
    $script_asset = require( $script_asset_path );
    wp_register_script(
      'edge-related-posts-editor',
      EDGEEX_PLUGIN_URL . '/inc/related-posts/' . $index_js,
      $script_asset['dependencies'], //Dependencies described in asset files
      $script_asset['version'], //The version stated in the asset file
        array( 'wp-blocks', 'wp-element', 'wp-i18n', 'wp-block-editor' )
    );
    $editor_css = 'build/index.css';
    wp_register_style(
      'edge-related-posts-editor',
      EDGEEX_PLUGIN_URL . '/inc/related-posts/' . $editor_css,
      array(),
      filemtime( EDGEEX_PLUGIN_DIR . '/inc/related-posts/' . $editor_css  )
    );
    $style_css = 'build/style-index.css';
    wp_register_style(
      'edge-related-posts',
      EDGEEX_PLUGIN_URL . '/inc/related-posts/' . $style_css,
      array(),
      filemtime( EDGEEX_PLUGIN_DIR . '/inc/related-posts/' . $style_css )
    );
 
    register_block_type( 'edge/related-posts', array(
      'editor_script' => 'edge-related-posts-editor',
      'editor_style'  => 'edge-related-posts-editor',
      'style'         => 'edge-related-posts',
      'render_callback' => 'edgeex_related_posts_render_callback',
      array(
      'title' => _x( ' Related Posts', 'block title', 'edge-expansion' ),
      'description' => _x( 'A list of links in hierarchical order on a Web page', 'block description', 'edge-expansion' )
      ),
      'attributes'      => array(
        'postsToShow' => array('type' => 'number','default' => 6),
        'numberColumns' => array('type' => 'number','default' => 3),
        'fontSize'        => array('type' => 'string','default' => '21px'),
        'showImage'       => array('type' => 'boolean', 'default' => true),
        'showDate'        => array('type' => 'boolean', 'default' => true),
        'showCategory'      => array('type' => 'boolean', 'default' => true),
        'showAuthor'      => array('type' => 'boolean', 'default' => true),
        'showExcerpt'     => array('type' => 'boolean', 'default' => true),
        'excerptLength'   => array('type' => 'number', 'default' => 20),
    ),
    ) );
    
  }
  add_action( 'init', 'edgeex_related_posts_register_block' );

function edgeex_related_posts_render_callback( $attributes ) {

    global $post;
    if ( ! $post ) {
        return '';
    }

    $categories = wp_get_post_categories( $post->ID );
    if ( empty( $categories ) ) {
        return '';
    }

    $query_args = [
        'post_type'      => 'post',
		    'post_status' => 'publish',
        'posts_per_page' => $attributes['postsToShow'],
        'category__in'   => $categories,
		    'ignore_sticky_posts' => true,
		    'no_found_rows' => true,
    ];
    $exclude = [];
    $current = get_the_ID();
    $related_posts = get_posts( $query_args );
    if ( empty( $related_posts ) ) {
        return '';
    }

    ob_start();
		echo '<div class="wp-block-edge-related-posts">';
    echo '<ul class="edge-related-posts-items container-'.esc_html($attributes['numberColumns']).'">';
    foreach ( $related_posts as $related ) {

		if ( ! in_array( $current, $exclude ) ) {
        echo '<li class="related-item">';
        if ( $attributes['showImage'] && has_post_thumbnail( $related->ID ) ) {
            echo '<div class="wp-block-related-posts-thumbnail">';
            echo get_the_post_thumbnail( $related->ID, 'large' );
            echo '</div>';
        }
        echo '<div class="wp-block-related-posts-content">';
        echo '<a href="' . esc_html(get_permalink( $related->ID )) . '"><span style="font-size:'.esc_html($attributes['fontSize']).';overflow-wrap: break-word;">' . esc_html( get_the_title( $related->ID ) ) . '</span></a>';
        echo '<div class="wp-block-latest-posts-block-meta">';
        
        if ( $attributes['showDate'] ) {
            echo '<span class="wp-block-related-posts-date">';
            echo get_the_date( '', $related->ID );
            echo '</span>';
        }
        if ( $attributes['showCategory'] ) {
            echo '<span class="wp-block-related-posts-category">';
            $categories = get_the_category();
            foreach( $categories as $cat ):
            ?>
            <a href="<?php echo esc_html(get_category_link($cat->term_id)); ?>"><?php echo esc_html($cat->name); ?></a>
            <?php endforeach;
            echo '</span>';
        }
        if ( $attributes['showAuthor'] ) {
            echo '<span class="wp-block-related-posts-author">';
            echo esc_html(get_the_author_meta( 'display_name', $related->post_author ));
            echo '</span>';
        }
        echo '</span>';
        if ( $attributes['showExcerpt'] ) {
            echo '<p>' . esc_html( wp_trim_words( get_the_excerpt( $related->ID ), $attributes['excerptLength'] ) ) . '</p>';
        }
        echo '</span>';
        echo '</li>';
      }
    }
    echo '</ul>';
    echo '</div>';
    return ob_get_clean();
}


