<?php
/**
 * Latest Posts Block
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


function edgeex_latest_posts_block_block_init() {
  $dir = dirname( __FILE__ );
  
  //Asset file path
  $script_asset_path = EDGEEX_PLUGIN_DIR . '/inc/latest-posts-block/build/index.asset.php';
  if ( ! file_exists( $script_asset_path ) ) {
    throw new Error(
      'You need to run `npm start` or `npm run build`'
    );
  }
  
  //Registering a block script
  $index_js     = 'build/index.js';
  $script_asset = require( $script_asset_path );
    wp_register_script(
      'edge-latest-posts-block-editor',
      EDGEEX_PLUGIN_URL . '/inc/latest-posts-block/' . $index_js,
      $script_asset['dependencies'], //Dependencies described in asset files
      $script_asset['version'], //The version stated in the asset file
        array( 'wp-blocks', 'wp-element', 'wp-i18n', 'wp-block-editor' )
    );
    $editor_css = 'build/index.css';
    wp_register_style(
      'edge-latest-posts-block-editor',
      EDGEEX_PLUGIN_URL . '/inc/latest-posts-block/' . $editor_css,
      array(),
      filemtime( EDGEEX_PLUGIN_DIR . '/inc/latest-posts-block/' . $editor_css )
    );
    $style_css = 'build/style-index.css';
    wp_register_style(
      'edge-latest-posts-block',
      EDGEEX_PLUGIN_URL . '/inc/latest-posts-block/' . $style_css,
      array(),
      filemtime( EDGEEX_PLUGIN_DIR . '/inc/latest-posts-block/'.$style_css )
    );
	register_block_type( 'edge/latest-posts-block', array(
    	'editor_script' => 'edge-latest-posts-block-editor',
    	'editor_style'  => 'edge-latest-posts-block-editor',
    	'style'         => 'edge-latest-posts-block',
		'render_callback' => 'edgeex_latest_posts_block_render_content',
	  	'attributes' => [
      		'numberOfPosts' => [
        		'type' => 'number"',
        		'default' => 6
      		],
      		'numberOfColumns' => [
        		'type' => 'number',
        		'default' => 3
      		],
      		'titleFontSize' => [
        		'type' => 'number',
        		'default' => 21
      		],
      		'displayThumbnail' => [
        		'type' => 'boolean',
        		'default' => true
      		],
      		'displayDate' => [
        		'type' => 'boolean',
        		'default' => true
      		],
      		'displayCategory' => [
        		'type' => 'boolean',
        		'default' => true
      		],
      		'displayAuthor' => [
        		'type' => 'boolean',
        		'default' => true
      		],
      		'displayExcerpt' => [
        		'type' => 'boolean',
        		'default' => true
      		],
      		'lateExcLength' => [
        		'type' => 'number',
        		'default' => 36
      		]
    	]
	) );
}
add_action( 'init', 'edgeex_latest_posts_block_block_init' );


function edgeex_latest_posts_block_render_content( $attr ) {
	$args = array(
		'numberposts'	=> $attr['numberOfPosts']
	);
	$edgeex_posts = get_posts( $args );
	
	if( ! empty( $edgeex_posts ) ){
		$output = '<div ' . get_block_wrapper_attributes() . '>';

		$num_cols = $attr['numberOfColumns'] > 1 ? strval( $attr['numberOfColumns'] ) : '1';

		$output .= '<ul class="wp-block-latest-posts-block-items columns-' . $num_cols . '">';
		foreach ( $edgeex_posts as $post ){
			
			$title = $post->post_title ? $post->post_title : 'Default title';
			$url = esc_url( get_permalink( $post->ID ) );
			$thumbnail = has_post_thumbnail( $post->ID ) ? get_the_post_thumbnail( $post->ID, 'large', array( 'class' => 'wp-block-latest-posts-block-post-thumbnail' ) ) : '';

			$output .= '<li class="post-item">';
			if( ! empty( $thumbnail ) && $attr['displayThumbnail'] ){
				$output .= '<div class="wp-block-latest-posts-block-thumbnail">';
				$output .= $thumbnail;
				$output .= '</div>';
			}
			$output .= '<div class="wp-block-latest-posts-block-content">';
			$output .= '<h4 class="wp-block-latest-posts-block-title" style="overflow-wrap: break-word;"><a href="' . $url . '">' . $title . '</a></h4>';
			$output .= '<div class="wp-block-latest-posts-block-meta">';
			if( $attr['displayDate'] ){
				$output .= '<div class="wp-block-latest-posts-block-date"><time datetime="' . esc_attr( get_the_date( 'c', $post ) ) . '" class="wp-block-author-box-author-plugin__post-date">' . esc_html( get_the_date( '', $post ) ) . '</time></div>';
			}
			if( $attr['displayCategory'] ){
				$categories = get_the_category($post->ID);
				$output .= '<div class="wp-block-latest-posts-block-category">';
				foreach( $categories as $category ){
				  $output .= '<a href="'.esc_html(get_category_link($category->term_id)).'">'.esc_html($category->name).'</a>';
				  $output .='&nbsp;';
				}
				$output .= '</div>';
			  }
			  if( $attr['displayAuthor'] ){
				  $user_id = get_the_author_meta( 'ID' );
				  $author = get_userdata($post->post_author);
				  $output .= '<div class="wp-block-latest-posts-block-author">';
				  $output .= $author->display_name;
				  $output .= '</div>';
			  }
			  $output .= '</div>';

			if( get_the_excerpt( $post ) && $attr['displayExcerpt'] ){
				$output .= '<div class="wp-block-latest-posts-block-excerpt">' . mb_substr(get_the_excerpt( $post ), 0, $attr['lateExcLength'] ) . '</div>';
			}
            $output .= '</div>';
			$output .= '</li>';
		}
		$output .= '</ul>';
		$output .= '</div>';
	}
	return $output ?? '<strong>'.esc_html_e('Sorry. No posts matching your criteria!','edge-expansion').'</strong>';
}