<?php
/**
 * Image Deformation
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function edgeex_image_deformation_register_block() {
	$dir = __DIR__;

	// Setting the path of built JS/CSS
	wp_register_script(
		'image-deformation-editor-script',
    EDGEEX_PLUGIN_URL . '/inc/image-deformation/build/index.js',
		[ 'wp-blocks', 'wp-element', 'wp-editor', 'wp-components', 'wp-i18n' ],
		filemtime( EDGEEX_PLUGIN_DIR . '/inc/image-deformation/build/index.js' ),
    ['strategy'  => 'defer','in_footer' => true]
	);

	wp_register_style(
		'image-deformation-editor-style',
    EDGEEX_PLUGIN_URL . '/inc/image-deformation/build/index.css',
		[],
		filemtime( EDGEEX_PLUGIN_DIR . '/inc/image-deformation/build/index.css' )
	);

	wp_register_style(
		'image-deformation-style',
    EDGEEX_PLUGIN_URL . '/inc/image-deformation/build/style-index.css',
		[],
		filemtime( EDGEEX_PLUGIN_DIR . '/inc/image-deformation/build/style-index.css' )
	);

	register_block_type( EDGEEX_PLUGIN_DIR . '/inc/image-deformation/build', [
		'editor_script'   => 'image-deformation-editor-script',
		'editor_style'    => 'image-deformation-editor-style',
		'style'           => 'image-deformation-style',
		'render_callback' => 'edgeex_image_deformation_render_callback',
    'editor_script' => 'edge-expansion-script',
	    'attributes' => [
            'imageUrl' => [
            'type' => 'string',
            'default' => ''
            ],
            'imageAlt' => [
            'type' => 'string',
            'default' => ''
            ],
            'shape' => [
            'type' => 'string',
            'default' => 'rectangle'
            ],
            'borderRadius' => [
            'type' => 'number',
            'default' => 0
            ],
            'width' => [
            'type' => 'string',
            'default' => '300px'
            ],
            'height' => [
            'type' => 'string',
            'default' => '300px'
            ],
            'alignment' => [
            'type' => 'string',
            'default' => 'center'
            ],
        ]
  ] );
}
add_action( 'init', 'edgeex_image_deformation_register_block' );

require_once EDGEEX_PLUGIN_DIR . '/inc/image-deformation/render.php';
