<?php
/**
 * HTML Sitemap Block
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function edgeex_html_sitemap_block_register() {
	//$dir = dirname( __FILE__ );
	
	//Asset file path
	$script_asset_path = EDGEEX_PLUGIN_DIR . '/inc/html-sitemap-block/build/index.asset.php';
	//If the asset file path does not exist, an error is displayed indicating that a build is required.
	if ( ! file_exists( $script_asset_path ) ) {
	  throw new Error(
		'You need to run `npm start` or `npm run build`'
	  );
	}
	
	//Registering a block script
	$index_js     = 'build/index.js';
	$script_asset = require( $script_asset_path );
	wp_register_script(
	  'edge-html-sitemap-block-editor',
      EDGEEX_PLUGIN_URL . '/inc/html-sitemap-block/' . $index_js,
	  $script_asset['dependencies'], //Dependencies described in asset files
	  $script_asset['version'], //The version stated in the asset file
		array( 'wp-blocks', 'wp-element', 'wp-i18n', 'wp-block-editor' )
	);
	
	$editor_css = 'build/index.css';
	wp_register_style(
	  'edge-html-sitemap-block-editor',
      EDGEEX_PLUGIN_URL . '/inc/html-sitemap-block/' . $editor_css,
	  array(),
	  filemtime( EDGEEX_PLUGIN_DIR . '/inc/html-sitemap-block/' . $editor_css )
	);
	
	$style_css = 'build/style-index.css';
	wp_register_style(
	  'edge-html-sitemap-block-posts',
      EDGEEX_PLUGIN_URL . '/inc/html-sitemap-block/' . $style_css,
	  array(),
	  filemtime( EDGEEX_PLUGIN_DIR . '/inc/html-sitemap-block/' . $style_css )
	);
	
	register_block_type( 'edge/html-sitemap-block', array(
	  'editor_script' => 'edge-html-sitemap-block-editor',
	  'editor_style'  => 'edge-html-sitemap-block-editor',
	  'style'         => 'edge-html-sitemap-block-posts',
	  'render_callback' => 'edgeex_html_sitemap_block_render',
		array(
		'title' => esc_html__( 'Html Sitemap Block', 'edge-expansion' ),
		'description' => esc_html__( 'Links to other articles that are highly related to the article you are viewing', 'edge-expansion' )
		),
	  'attributes' => [
		'titleFontSize' => [
			'type' => 'string',
			'default' => '2.25rem'
		],
		'fontSize' => [
			'type' => 'string',
			'default' => '1.2rem'
		],
		'showPages' => [
		  'type' => 'boolean', 
		  'default' => true
		],
		'showPosts' => [
		  'type' => 'boolean', 
		  'default' => true
		],
		'showCategories' => [
		  'type' => 'boolean',
		  'default' => true
		],
		'showTags' => [
		  'type' => 'boolean',
		  'default' => true
		],
		'showCustomPostTypes' => [
		  'type' => 'boolean', 
		  'default' => true
		],
		'enableAccordion' => [
		  'type' => 'boolean', 
		  'default' => true
		],
		'showPostDate' => [
		  'type' => 'boolean', 
		  'default' => false
		],
		'showPostExcerpt' => [
		  'type' => 'boolean', 
		  'default' => false
		],
		'order' => [
		  'type' => 'string',
		  'default' => 'asc'
		],
		'orderby' => [
		  'type' => 'string',
		  'default' => 'title'
		],
		'orderbypages' => [
		  'type' => 'string',
		  'default' => 'title'
		],
		'orderbycat' => [
		  'type' => 'string',
		  'default' => 'name'
		],
		'listStyle' => [
		  'type' => 'string',
		  'default' => 'disc'
		],
	  ]
	) );
  }
  add_action( 'init', 'edgeex_html_sitemap_block_register' );


function edgeex_html_sitemap_block_render($attributes) {
	$titleFontSize = $attributes['titleFontSize'];
	$fontSize = $attributes['fontSize'];
	$showPages = $attributes['showPages'];
	$showCategories = $attributes['showCategories'];
	$showTags = $attributes['showTags'];
	$showPosts = $attributes['showPosts'];
	$showCustomPostTypes = $attributes['showCustomPostTypes'];
	$enableAccordion = $attributes['enableAccordion'];
	$showPostDate = $attributes['showPostDate'];
	$showPostExcerpt = $attributes['showPostExcerpt'];
	$order = $attributes['order'];
	$orderby = $attributes['orderby'];
	$orderbypages = $attributes['orderbypages'];
	$orderbycat = $attributes['orderbycat'];
	$listStyle = $attributes['listStyle'];
	ob_start();
	echo '<div class="html-sitemap-block">';
	if ($showPages=='1') {
		echo '<h3 style="font-size:'.esc_html($titleFontSize).'">'.esc_html__('Pages','edge-expansion').'</h3>';
		echo '<ul class="custom-list '.esc_html($listStyle).'">';

		wp_list_pages(['title_li' => '','sort_order' => $order,'sort_column' => $orderbypages]);
		echo '</ul>';
	}
	//echo $orderbypages;
	if ($showCategories=='1') {
		echo '<h3 style="font-size:'.esc_html($titleFontSize).'">'.esc_html__('Categories','edge-expansion').'</h3>';
		echo '<ul>';
		$categories = get_categories();
		foreach ($categories as $category) {
			echo '<li class="custom-list '.esc_html($listStyle).'"><a href="' . esc_html(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a></li>';
		}
		echo '</ul>';
	}
	if ($showTags=='1') {
		echo '<h3 style="font-size:'.esc_html($titleFontSize).'">'.esc_html__('Tags','edge-expansion').'</h3>';
		echo '<ul>';
		
		$tags = get_tags();
		foreach ($tags as $tag) {
			echo '<li class="custom-list '.esc_html($listStyle).'"><a href="' . esc_html(get_tag_link($tag->term_id)) . '">' . esc_html($tag->name) . '</a></li>';
		}
		echo '</ul>';
	}
	
	if ($showPosts=='1') {
		echo '<h3 style="font-size:'.esc_html($titleFontSize).'">'.esc_html__('Posts','edge-expansion').'</h3>';
		echo '<ul>';
		$args = array(
			'numberposts' => -1,
			'orderby' => $orderby,
			'order' => $order,
			'post_type' => 'post'
		);
		$posts = get_posts($args);
		foreach ($posts as $post) {
			echo '<li class="custom-list '.esc_html($listStyle).'"><a href="' . esc_html(get_permalink($post->ID)) . '">' . esc_html($post->post_title) . '</a>';
			if ($showPostDate=='1') echo '<div class="meta">' . get_the_date('', $post->ID) . '</div>';
			if ($showPostExcerpt=='1') echo '<p>' . esc_html(get_the_excerpt($post->ID)) . '</p>';
			echo '</li>';
		}
		echo '</ul>';
	}


	if($showCustomPostTypes=='1'){
		echo '<h3 style="font-size:'.esc_html($titleFontSize).'">'.esc_html__('Custom Post Types','edge-expansion').'</h3>';
	
		echo '<ul>';
		$post_types = get_post_types(
			array(
				'public'   => true,
				'_builtin' => false,
			)
		);
		
		foreach ( $post_types as $post_type ) {
			$object = get_post_type_object( $post_type );
			echo '<li class="custom-list '.esc_html($listStyle).'">';
			echo '<a href="'.esc_url(get_post_type_archive_link($object->name)).'"><span style="font-size:'.esc_html($fontSize).'">'.esc_html(ucfirst( $object->name )).'</span></a>';
			echo '</li>';
		
		}
		
		echo '</ul>';
	}


	echo '</div>';

	return ob_get_clean();
}
