<?php
/**
 * Render callback for Definition List Block
 *
 * @param array $attributes Block attributes.
 * @return string Rendered HTML.
 */
if (!defined('ABSPATH')) exit;

function edgeex_render_definition_list_block( $attributes ) {
	if ( empty( $attributes['items'] ) || ! is_array( $attributes['items'] ) ) {
		return '';
	}
		
	$dt_style = 'font-size:'. esc_attr( $attributes['dtFontSize']).'; font-weight:'. esc_attr( $attributes['dtFontWeight']).';';

	$dd_style = 'font-size:'.esc_attr( $attributes['ddFontSize']).'; font-weight:'.esc_attr( $attributes['ddFontWeight']) .'; margin-top:'.esc_attr( $attributes['ddVerticalMargin']).'px; margin-bottom:'.esc_attr( $attributes['ddVerticalMargin']).'px; margin-left:'.esc_attr( $attributes['ddLeftMargin']).'px;';
		

	ob_start();
	echo '<dl>';
	foreach ( $attributes['items'] as $item ) {
		if ( empty( $item['term'] ) && empty( $item['description'] ) ) {
			continue;
		}
		echo '<dt style="' . esc_attr($dt_style) . '">' .   esc_attr($item['term']) ?? '' . '</dt>';
		echo '<dd style="' . esc_attr($dd_style) . '">' .   esc_attr($item['description']) ?? '' . '</dd>';
	}
	echo '</dl>';
	return ob_get_clean();
}
