<?php
/**
 * Definition List Block
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function edgeex_register_definition_list_block() {

	// Register CSS and JS for the editor
	wp_register_style(
		'definition-list-editor-style',
    	EDGEEX_PLUGIN_URL . '/inc/definition-list-block/build/index.css',
		[],
		filemtime( EDGEEX_PLUGIN_DIR . '/inc/definition-list-block/build/index.css' )
	);

	wp_register_style(
		'definition-list-style',
    	EDGEEX_PLUGIN_URL . '/inc/definition-list-block/build/style-index.css',
		[],
		filemtime( EDGEEX_PLUGIN_DIR . '/inc/definition-list-block/build/style-index.css' )
	);

	wp_register_script(
		'definition-list-editor-script',
    	EDGEEX_PLUGIN_URL . '/inc/definition-list-block/build/index.js',
		[ 'wp-blocks', 'wp-element', 'wp-editor', 'wp-components', 'wp-i18n', 'wp-block-editor' ],
		filemtime( EDGEEX_PLUGIN_DIR . '/inc/definition-list-block/build/index.js' ),
		true
	);

    register_block_type(EDGEEX_PLUGIN_DIR . '/inc/definition-list-block/build', [
		'editor_script' => 'definition-list-editor-script',
		'editor_style'  => 'definition-list-editor-style',
		'style'         => 'definition-list-style',
		'render_callback' => 'edgeex_render_definition_list_block',
	  	'attributes' => [
      		'items' => [
        		'type' => 'array',
        		'default' =>  []
      		],
      		'dtFontSize' => [
        		'type' => 'string',
        		'default' => '21px'
      		],
      		'dtFontWeight' => [
        		'type' => 'string',
        		'default' => 'bold'
      		],
      		'dtTextColor' => [
        		'type' => 'string',
        		'default' => '#333333'
      		],
      		'ddFontSize' => [
        		'type' => 'string',
        		'default' =>'18px'
      		],
      		'bgColor' => [
        		'type' => 'string',
        		'default' => '#000000'
      		],
      		'ddFontWeight' => [
        		'type' => 'string',
        		'default' =>  'normal'
      		],
      		'ddVerticalMargin' => [
        		'type' => 'number',
        		'default' => 8
      		],
      		'ddLeftMargin' => [
        		'type' => 'number',
        		'default' => 16
      		],
    	]
  	] );
}
add_action( 'init', 'edgeex_register_definition_list_block' );

require_once EDGEEX_PLUGIN_DIR . '/inc/definition-list-block/render.php';