<?php
if (!defined('ABSPATH')) exit;

function edgeex_dashicons_text_render_callback( $attributes ){

    $content = $attributes['content'] ?? '';
    $icon = esc_attr($attributes['icon'] ?? 'dashicons-admin-site');
    $icon_size = intval($attributes['iconSize'] ?? 24);
    $icon_color = esc_attr($attributes['iconColor'] ?? '#000000');
    $icon_position = esc_attr($attributes['iconPosition'] ?? 'left');
    $spacingVer = intval($attributes['spacingVer'] ?? 5);
    $spacingTop = intval($attributes['spacingTop'] ?? 5);
    $spacingBottom = intval($attributes['spacingBottom'] ?? 5);
    $alignment = esc_attr($attributes['alignment'] ?? 'left');
    $textFontSize = esc_attr($attributes['textFontSize'] ?? '21px');
    
    if($icon_position =='left'){
        $block_content = '<div class="dashicons-text-container">';
        $block_content .= '<div class="edge-dashicons-text align-'.$alignment.'">';
        $block_content .= '<div class="dashicons '.$icon.'" style="font-size:'.$icon_size.'px;color:'.$icon_color.';margin-right:'.$spacingVer.'px;margin-top:'.$spacingTop.'px;margin-bottom:'.$spacingBottom.'px;"></div><div class="text-dashicons" style="font-size:'.$textFontSize.';">'.$content.'</div>';
    }elseif($icon_position =='right'){
        $block_content = '<div class="dashicons-text-container">';
        $block_content .= '<div class="edge-dashicons-text align-'.$alignment.'">';
        $block_content .= '<div class="dashicons '.$icon.'" style="font-size:'.$icon_size.'px;color:'.$icon_color.';margin-right:'.$spacingVer.'px;margin-top:'.$spacingTop.'px;margin-bottom:'.$spacingBottom.'px;"></div><div class="text-dashicons" style="font-size:'.$textFontSize.';">'.$content.'</div>';
    }elseif($icon_position =='icon-only'){
        $block_content = '<div class="dashicons-text-container">';
        $block_content .= '<div class="edge-dashicons-text align-'.$alignment.'">';
        $block_content .= '<div class="dashicons '.$icon.'" style="font-size:'.$icon_size.'px;color:'.$icon_color.';></div>';
    }
    $block_content  .= '</div>';
    $block_content  .= '</div>';  
    return $block_content;

}