<?php
/**
 * Dashicons Text
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/reference/functions/register_block_type/
 */
function edgeex_dashicons_text_block_init() {

	// Setting the path of built JS/CSS
	wp_register_script(
		'dashicons-text-editor-script',
    EDGEEX_PLUGIN_URL . '/inc/dashicons-text/build/index.js',
		[ 'wp-blocks', 'wp-element', 'wp-editor', 'wp-components', 'wp-i18n' ],
		filemtime( EDGEEX_PLUGIN_DIR . '/inc/dashicons-text/build/index.js' ),
    ['strategy'  => 'defer','in_footer' => true]
	);

	wp_register_style(
		'dashicons-text-editor-style',
    EDGEEX_PLUGIN_URL . '/inc/dashicons-text/build/index.css',
		[],
		filemtime( EDGEEX_PLUGIN_DIR . '/inc/dashicons-text/build/index.css' )
	);

	wp_register_style(
		'dashicons-text-style',
    EDGEEX_PLUGIN_URL . '/inc/dashicons-text/build/style-index.css',
		[],
		filemtime( EDGEEX_PLUGIN_DIR . '/inc/dashicons-text/build/style-index.css' )
	);

	register_block_type( EDGEEX_PLUGIN_DIR . '/inc/dashicons-text/build', [
		'editor_script'   => 'dashicons-text-editor-script',
		'editor_style'    => 'dashicons-text-editor-style',
		'style'           => 'dashicons-text-style',
		'render_callback' => 'edgeex_dashicons_text_render_callback',
	  'attributes' => [
      'content' => [
        'type' => 'string',
        'default' => ''
      ],
      'icon' => [
        'type' => 'string',
        'default' => 'dashicons-admin-site'
      ],
      'iconPosition' => [
        'type' => 'string',
        'default' => 'left'
      ],
      'iconSize' => [
        'type' => 'number',
        'default' => 24
      ],
      'iconColor' => [
        'type' => 'string',
        'default' => '#000000'
      ],
      'spacingVer' => [
        'type' => 'number"',
        'default' => 5
      ],
      'spacingTop' => [
        'type' => 'number"',
        'default' => 5
      ],
      'spacingBottom' => [
        'type' => 'number"',
        'default' => 5
      ],
      'textFontSize' => [
        'type' => 'string',
        'default' => '21px'
      ],
      'alignment' => [
        'type' => 'string',
        'default' => 'left'
      ],
    ]
  ] );
}
add_action( 'init', 'edgeex_dashicons_text_block_init' );

require_once EDGEEX_PLUGIN_DIR . '/inc/dashicons-text/render.php';
