<?php
if (!defined('ABSPATH')) exit;

function edgeex_cptc_form_page() {
    $custom_types = get_option('edgeex_custom_post_types', []);

    // Edit mode check
    if (isset($_GET['slug']) && isset($custom_types[$_GET['slug']])) {
        $is_edit = true;
        $edit_slug = sanitize_text_field(wp_unslash($_GET['slug']));
        $type = $custom_types[$edit_slug];

        $form_data = [
            'slug' => $edit_slug,
            'name' => $type['labels']['name'],
            'singular_name' => $type['labels']['singular_name'],
            'public' => $type['public'],
            'hierarchical' => $type['hierarchical'],
            'publicly_queryable' => $type['publicly_queryable'],
            'show_ui' => $type['show_ui'],
            'show_in_menu' => $type['show_in_menu'],
            'show_in_rest' => $type['show_in_rest'],
            'menu_position' => $type['menu_position'],
            'capability_type' => $type['capability_type'],
            'has_archive' => $type['has_archive'],
            'rewrite' => $type['rewrite'],
            'custom_rewrite_slug' => $type['custom_rewrite_slug'],
            'with_front' => $type['with_front'],
            'query_var' => $type['query_var'],
            'exclude_from_search' => $type['exclude_from_search'],
            'supports' => $type['supports'],
        ];
    }else{

        $is_edit = false;
        $edit_slug = '';
        $form_data = [
            'slug' => '',
            'name' => '',
            'singular_name' => '',
            'public' => false,
            'hierarchical' => false,
            'publicly_queryable' => false,
            'show_ui' => false,
            'show_in_menu' => false,
            'show_in_rest' => false,
            'menu_position' => '',
            'capability_type' => 'post',
            'has_archive' => false,
            'rewrite' => false,
            'custom_rewrite_slug' => '',
            'with_front' => false,
            'query_var' => false,
            'exclude_from_search' => false,
            'supports' => false,
        ];

    }

    // Save process (new or edit)
    if ((isset($_POST['save_cpt']) || isset($_POST['update_cpt'])) && check_admin_referer('edgeex_cptc_form')) {
        if(isset($_POST['slug'])){
            $slug = sanitize_title(wp_unslash($_POST['slug']));
        }
        if(isset($_POST['name'])){
            $name = sanitize_text_field(wp_unslash($_POST['name']));
        }
        if(isset($_POST['singular_name'])){
            $singular_name = sanitize_text_field(wp_unslash($_POST['singular_name']));
        }
        $allowed_features = array( 'title', 'editor', 'excerpt', 'thumbnail', 'author', 'trackbacks', 'custom-fields', 'comments', 'revisions', 'page-attributes', 'post-formats' );
        /*if(!empty($_POST['supports'])){
            $dirty_array = wp_unslash($_POST['supports']);
            $sanitized_array = [];
            foreach ( $dirty_array as $key => $value ) {
                if ( is_string( $value ) ) {
                    $sanitized_array[ $key ] = sanitize_text_field( $value );
                }
            }
        }*/
        if(!empty($_POST['supports'])){
            $dirty_array = array_map('sanitize_text_field',wp_unslash($_POST['supports']));
            //wp_kses_array('sanitize_text_field',wp_unslash($_POST['supports']));
            $sanitized_array = [];
            foreach ( $dirty_array as $key => $value ) {
                if ( is_string( $value ) ) {
                    $sanitized_array[ $key ] = sanitize_text_field( $value );
                }
            }
        }
        $custom_types[$slug] = [
            'labels' => [
                'name' => $name,
                'singular_name' => $singular_name,
            ],
            'public' => isset($_POST['public'])? true : false,
            'hierarchical' =>isset($_POST['hierarchical'])? true : false,
            'publicly_queryable' => isset($_POST['publicly_queryable'])? true : false,
            'show_ui' => isset($_POST['show_ui'])? true : false,
            'show_in_menu' => isset($_POST['show_in_menu'])? true : false,
            'show_in_rest' => isset($_POST['show_in_rest'])? true : false,
            'menu_position' => isset($_POST['menu_position'])? sanitize_text_field(wp_unslash($_POST['menu_position'])) : '',
            'capability_type' => isset($_POST['capability_type'])? 'post' : 'page',
            'has_archive' => isset($_POST['has_archive'])? true : false,
            'rewrite' => isset($_POST['rewrite'])? true : false,
            'custom_rewrite_slug' => isset($_POST['custom_rewrite_slug'])? sanitize_text_field(wp_unslash($_POST['custom_rewrite_slug'])) : '',
            'with_front' => isset($_POST['with_front'])? true : false,
            'query_var' => isset($_POST['query_var'])? true : false,
            'exclude_from_search' => isset($_POST['exclude_from_search'])? false: true,
            //'supports'   => isset( $_POST['supports'] ) && is_array( $_POST['supports'])  ?  array_intersect( sanitize_text_field(wp_unslash($_POST['supports'])) , $allowed_features ) : '',
            'supports'   => isset( $_POST['supports'] ) && is_array( $_POST['supports'])  ?  array_intersect($sanitized_array , $allowed_features ) : '',

        ];
//var_dump($sanitized_array);
        update_option('edgeex_custom_post_types', $custom_types);

        wp_safe_redirect(admin_url('admin.php?page=edgeex_cptc_list'));
        exit;
    }

    ?>
    <div class="wrap">
		<h1><?php esc_html_e( 'Custom Post Type', 'edge-expansion' ); ?></h1>
		<p><a href="?page=edgeex_cptc_list" class="button button-primary"><?php esc_html_e( 'List of Custom Post Types', 'edge-expansion' ); ?></a></p>
        <h2><?php echo $is_edit ? esc_html_e('Edit Custom Post Type','edge-expansion') : esc_html_e('Create a new Custom Post Type','edge-expansion'); ?></h2>
        <form method="post">
            <?php wp_nonce_field('edgeex_cptc_form'); ?>
            <table class="custom-form-table">
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">slug</span></label>
					<p><?php esc_html_e( 'The post type name. Used to retrieve custom post type content.', 'edge-expansion' ); ?>
					<p><?php esc_html_e( 'Must not exceed 20 characters and may only contain lowercase alphanumeric characters, dashes, and underscores.Must be all in lower-case and without any spaces.', 'edge-expansion' ); ?>
                </th>
                </tr>
                <tr>
                    <td>
                        <?php if ($is_edit): ?>
                            <span style="font-size:1.3em;font-weight:600;"><?php echo esc_html($form_data['slug']); ?></span>
                            <input type="hidden" name="slug" value="<?php echo esc_attr($form_data['slug']); ?>" />
                        <?php else: ?>
                            <input name="slug" type="text" required />
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">label</span></label>
						<p><?php esc_html_e( 'A plural descriptive name for the post type.', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'Name of the post type shown in the menu. Usually plural.', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'e.g.', 'edge-expansion' ); ?> Books</p>
                </th>
                </tr>
                <tr>
                    <td><input name="name" type="text" value="<?php echo esc_attr($form_data['name']); ?>" required />
                </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">singular_label</span></label>
						<p><?php esc_html_e( 'A singular descriptive name for the post type.', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'e.g.', 'edge-expansion' ); ?> Book</p>
                </th>
                </tr>
                <tr>
                    <td><input name="singular_name" type="text" value="<?php echo esc_attr($form_data['singular_name']); ?>" required />
                </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">public</span></label>
                    <p><?php esc_html_e( 'Whether a post type is intended to be used publicly either via the admin interface or by front-end users.', 'edge-expansion' ); ?></p>
					<p><?php esc_html_e( 'True is recommended.', 'edge-expansion' ); ?></p>
					<p><?php esc_html_e( 'Default:false', 'edge-expansion' ); ?></p>
                    </th>
                </tr>
                <tr>
                    <td>
                    <select name="public" id="cpt_public" tabindex="5">
						<option value="1" <?php echo isset($form_data['public'])? selected( $form_data['public'], '1' ): 'selected'; ?>><?php esc_html_e( 'True', 'edge-expansion' ); ?></option>
						<option value="0" <?php echo isset($form_data['public'])? selected( $form_data['public'], '0' ): ''; ?>><?php esc_html_e( 'False', 'edge-expansion' ); ?></option>
					</select>
                </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">hierarchical</span></label>
						<p><?php esc_html_e( 'Specify "true" to allow custom posts to have a parent-child relationship (hierarchy) like static pages. Specify "false" to manage content chronologically like posts and not have a parent-child relationship.', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'Default:false', 'edge-expansion' ); ?></p>
                    </th>
                </tr>
                <tr>
                    <td>
                    <select name="hierarchical" id="cpt_hierarchical" tabindex="5">
						<option value="1" <?php echo isset($form_data['has_archive'])? selected( $form_data['has_archive'], '1' ): 'selected'; ?>><?php esc_html_e( 'True', 'edge-expansion' ); ?></option>
						<option value="0" <?php echo isset($form_data['has_archive'])? selected( $form_data['has_archive'], ' 0' ): ''; ?>><?php esc_html_e( 'False', 'edge-expansion' ); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">publicly_queryable</span></label>
						<p><?php esc_html_e( 'Whether the post should be displayed on the frontend. If set to FALSE, custom posts will not be able to be previewed or displayed (they will return a 404 error).', 'edge-expansion' ); ?></p>
                    </th>
                </tr>
                <tr>
                    <td>
                    <select name="publicly_queryable" id="cpt_publicly_queryable" tabindex="5">
						<option value="1" <?php echo isset($form_data['publicly_queryable'])? selected( $form_data['publicly_queryable'], '1' ): 'selected'; ?>><?php esc_html_e( 'True', 'edge-expansion' ); ?></option>
						<option value="0" <?php echo isset($form_data['publicly_queryable'])? selected( $form_data['publicly_queryable'], '0' ): ''; ?>><?php esc_html_e( 'False', 'edge-expansion' ); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">show_ui</span></label>
                    <p><?php esc_html_e('Whether to display the page for this custom post type on the admin screen. If you specify "false", you will not be able to operate it on the admin screen.', 'edge-expansion'); ?></p>
					<p><?php esc_html_e( 'True is recommended.', 'edge-expansion' ); ?></p>
					<p><?php esc_html_e( 'Default: Value specified in public.', 'edge-expansion' ); ?></p>
                </th>
                </tr>
                <tr>
                    <td>
                    <select name="show_ui" id="cpt_show_ui" tabindex="5">
						<option value="1" <?php echo isset($form_data['show_ui'])? selected( $form_data['show_ui'], '1' ): 'selected'; ?>><?php esc_html_e( 'True', 'edge-expansion' ); ?></option>
						<option value="0" <?php echo isset($form_data['show_ui'])? selected( $form_data['show_ui'], '0' ): ''; ?>><?php esc_html_e( 'False', 'edge-expansion' ); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">show_in_menu</span></label>
						<p><?php esc_html_e( 'Whether this post type should be visible in the admin menus (show_ui must be true for this to be visible).', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'Default:Value specified in public', 'edge-expansion' ); ?></p>
                
                </th>
                </tr>
                <tr>
                    <td>
                    <select name="show_in_menu" id="cpt_show_in_menu" tabindex="5">
						<option value="1" <?php echo isset($form_data['show_in_menu'])? selected( $form_data['show_in_menu'], '1' ): 'selected'; ?>><?php esc_html_e( 'True', 'edge-expansion' ); ?></option>
						<option value="0" <?php echo isset($form_data['show_in_menu'])? selected( $form_data['show_in_menu'], '0' ): ''; ?>><?php esc_html_e( 'False', 'edge-expansion' ); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">show_in_rest</span></label>
						<p><?php esc_html_e( 'Whether to enable the REST API for this post type.Set this to true to make your post type available in the block editor.', 'edge-expansion' ); ?></p>
                    </th>
                </tr>
                <tr>
                    <td>
                    <select name="show_in_rest" id="cpt_show_in_rest" tabindex="5">
						<option value="1" <?php echo isset($form_data['show_in_rest'])? selected( $form_data['show_in_rest'], '1' ): 'selected'; ?>><?php esc_html_e( 'True', 'edge-expansion' ); ?></option>
						<option value="0" <?php echo isset($form_data['show_in_rest'])? selected( $form_data['show_in_rest'], '0' ): ''; ?>><?php esc_html_e( 'False', 'edge-expansion' ); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">menu_position</span></label>
                        <p><?php esc_html_e( 'The position in the menu order the post type should appear. "show_in_menu" must be true.', 'edge-expansion' ); ?></p>
                        <p><?php esc_html_e( 'Refer to the following to set the number to which position in the menu you want to display.', 'edge-expansion' ); ?><br>
                        <?php
                        echo '5:';
                        esc_html_e('Posts','edge-expansion');
                        echo '&nbsp;&nbsp10:';
                        esc_html_e('Media','edge-expansion').'&nbsp;&nbsp;';
                        echo '&nbsp;&nbsp20:';
                        esc_html_e('Pages','edge-expansion').'&nbsp;';
                        echo '&nbsp;&nbsp25:';
                        esc_html_e('Comments','edge-expansion').'&nbsp;';
                        echo '&nbsp;&nbsp60:';
                        esc_html_e('Appearance','edge-expansion').'&nbsp;';
                        echo '&nbsp;&nbsp65:';
                        esc_html_e('Plugins','edge-expansion').'&nbsp;';
                        echo '&nbsp;&nbsp70:';
                        esc_html_e('Users','edge-expansion').'&nbsp;';
                        echo '&nbsp;&nbsp75:';
                        esc_html_e('Tools','edge-expansion').'&nbsp;';
                        echo '&nbsp;&nbsp80:';
                        esc_html_e('Settings','edge-expansion').'&nbsp;';
                        echo '&nbsp;&nbsp100:';
                        esc_html_e('Bottom','edge-expansion');
                        ?>
                        </p>
					</th>
                </tr>
                <tr>
                    <td><input name="menu_position" type="text" value="<?php echo esc_attr($form_data['menu_position'] ?? '5'); ?>" />
                </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">capability_type</span></label>
						<p><?php esc_html_e( 'The post type to use to build the read, edit, and delete capabilities.Specify the post type name (post or page).', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'Default:post', 'edge-expansion' ); ?></p>
                
                </th>
                </tr>
                <tr>
                    <td>
                    <select name="capability_type" id="cpt_capability_type" tabindex="5">
						<option value="post" <?php echo isset($form_data['capability_type'])? selected( $form_data['capability_type'], 'post' ): 'selected'; ?>><?php esc_html_e( 'Post', 'edge-expansion' ); ?></option>
						<option value="page" <?php echo isset($form_data['capability_type'])? selected( $form_data['capability_type'], 'page' ): ''; ?>><?php esc_html_e( 'Page', 'edge-expansion' ); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">has_archive</span></label>
						<p><?php esc_html_e( 'Specify whether to generate a list page (archive page) of articles with a boolean value. If you set it to "true", a list page of posted articles will be generated.', 'edge-expansion' ); ?>
						<p><?php esc_html_e( 'Default:false.', 'edge-expansion' ); ?></p>
                </th>
                </tr>
                <tr>
                    <td>
                    <select name="has_archive" id="cpt_has_archive" tabindex="5">
						<option value="1" <?php echo isset($form_data['has_archive'])? selected( $form_data['has_archive'], '1' ): 'selected'; ?>><?php esc_html_e( 'True', 'edge-expansion' ); ?></option>
						<option value="0" <?php echo isset($form_data['has_archive'])? selected( $form_data['has_archive'], '0' ): ''; ?>><?php esc_html_e( 'False', 'edge-expansion' ); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">rewrite</span></label>
						<p><?php esc_html_e( 'Specifies how to rewrite the permalinks for this post type (automatic URL rewriting).', 'edge-expansion' ); ?>
						<p><?php esc_html_e( 'If the setting is true, you can access it at the following URL: http://site URL/custom post type name/individual custom post slug/', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'If the setting is false, you can access it at the following URL: http://site URL/?post_type=custom post type name&p=individual custom post ID', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'Default:true.', 'edge-expansion' ); ?></p>
					    <p><?php esc_html_e( 'False is recommended.', 'edge-expansion' ); ?></p>
                </th>
                </tr>
                <tr>
                    <td>
                    <select name="rewrite" id="cpt_rewrite" tabindex="5">
						<option value="1" <?php echo isset($form_data['rewrite'])? selected( $form_data['rewrite'], '1' ): 'selected'; ?>><?php esc_html_e( 'True', 'edge-expansion' ); ?></option>
						<option value="0" <?php echo isset($form_data['rewrite'])? selected( $form_data['rewrite'], '0' ): ''; ?>><?php esc_html_e( 'False', 'edge-expansion' ); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">custom_rewrite_slug</span></label>
						<p><?php esc_html_e( 'Customize the permastruct slug.', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'Default: Custom Post Type Slug', 'edge-expansion' ); ?></p>
                </th>
                </tr>
                <tr>
                    <td><input name="custom_rewrite_slug" type="text" value="<?php echo esc_attr($form_data['custom_rewrite_slug'] ?? ''); ?>" />
                </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">with_front</span></label>
						<p><?php esc_html_e( 'Sets whether to prepend the WP_Rewrite $front setting to the front of the structure.', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( '(For example, if you select a custom structure in "Permalink Settings" and the permalink structure is /blog/, if true, the link will become /blog/news/, and if false, the link will become /news/.)', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'Default:true.', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'False is recommended.', 'edge-expansion' ); ?></p>
                </th>
                </tr>
                <tr>
                    <td>
                    <select name="with_front" id="cpt_with_front" tabindex="5">
						<option value="1" <?php echo isset($form_data['with_front'])? selected( $form_data['with_front'], '1' ): 'selected'; ?>><?php esc_html_e( 'True', 'edge-expansion' ); ?></option>
						<option value="0" <?php echo isset($form_data['with_front'])? selected( $form_data['with_front'], '0' ): ''; ?>><?php esc_html_e( 'False', 'edge-expansion' ); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">query_var</span></label>
						<p><?php esc_html_e( 'Specifies whether to use the query_var key for this custom post.', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'If this setting is true, the custom post page will be displayed at "WordPress address/?custom post type name=individual custom post slug".', 'edge-expansion' ); ?>
						<p><?php esc_html_e( 'If this setting is false, the custom post page will be displayed at "WordPress address/?post_type=custom post type name&name=individual custom post slug".', 'edge-expansion' ); ?>
						<p><?php esc_html_e( 'Default:true.', 'edge-expansion' ); ?></p>
                </th>
                </tr>
                <tr>
                    <td>
                    <select name="query_var" id="cpt_query_var" tabindex="5">
						<option value="1" <?php echo isset($form_data['query_var'])? selected( $form_data['query_var'], '1' ): 'selected'; ?>><?php esc_html_e( 'True', 'edge-expansion' ); ?></option>
						<option value="0" <?php echo isset($form_data['query_var'])? selected( $form_data['query_var'], '0' ): ''; ?>><?php esc_html_e( 'False', 'edge-expansion' ); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="cpt_label"><span class="custom-sub-title">exclude_from_search</span></label>
						<p><?php esc_html_e( 'Whether to exclude posts with this post type from front end search results.', 'edge-expansion' ); ?></p>
						<p><?php esc_html_e( 'Default: The opposite of the value specified for public.', 'edge-expansion' ); ?></p>
                </th>
                </tr>
                <tr>
                    <td>
                    <select name="exclude_from_search" id="cpt_exclude_from_search" tabindex="5">
						<option value="1" <?php echo isset($form_data['exclude_from_search'])? selected( $form_data['exclude_from_search'], '1' ): ''; ?>><?php esc_html_e( 'True', 'edge-expansion' ); ?></option>
						<option value="0" <?php echo isset($form_data['exclude_from_search'])? selected( $form_data['exclude_from_search'], '0' ): 'selected'; ?>><?php esc_html_e( 'False', 'edge-expansion' ); ?></option>
                    </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="edge_supports"><span class="custom-sub-title">supports</span></label>
						<p><?php esc_html_e( 'Set the fields to be displayed on the new post creation and editing page for custom post type.', 'edge-expansion' ); ?></p>
                </th>
                </tr>
                <tr>
                    <td>
                    <?php
                    if(!empty($form_data['supports'])){
                        $form_data_flip['supports'] = array_flip($form_data['supports']);
                    }else{
                        $form_data_flip['supports'] = '';
                    }
                    ?>
                    <input type="checkbox" tabindex="23" name="supports[]" id="edge_supports_title" value="title" <?php echo isset($form_data_flip['supports']['title']) ? 'checked' : ''; ?> <?php if(empty($form_data['supports'])){ echo 'checked';} ?> /> <label for="edge_supports_title"><?php esc_html_e( 'Title', 'edge-expansion' ); ?> <span class="default">(<?php esc_html_e( 'default', 'edge-expansion' ); ?>)</span></label><br />
					<input type="checkbox" tabindex="24" name="supports[]" id="edge_supports_editor" value="editor" <?php echo isset($form_data_flip['supports']['editor']) ? 'checked' : ''; ?> <?php if(empty($form_data['supports'])){ echo 'checked';} ?> /> <label for="edge_supports_editor"><?php esc_html_e( 'Editor', 'edge-expansion' ); ?> <span class="default">(<?php esc_html_e( 'default', 'edge-expansion' ); ?>)</span></label><br />
					<input type="checkbox" tabindex="25" name="supports[]" id="edge_supports_excerpt" value="excerpt" <?php echo isset($form_data_flip['supports']['excerpt']) ? 'checked' : ''; ?> <?php if(empty($form_data['supports'])){ echo 'checked';} ?> /> <label for="edge_supports_excerpt"><?php esc_html_e( 'Excerpt', 'edge-expansion' ); ?> <span class="default">(<?php esc_html_e( 'default', 'edge-expansion' ); ?>)</span></label><br />
					<input type="checkbox" tabindex="26" name="supports[]" id="edge_supports_featured_image" value="thumbnail" <?php echo isset($form_data_flip['supports']['thumbnail']) ? 'checked' : ''; ?> <?php if(empty($form_data['supports'])){ echo 'checked';} ?> /> <label for="edge_supports_featured_image"><?php esc_html_e( 'Featured Image', 'edge-expansion' ); ?><span class="default">(<?php esc_html_e( 'default', 'edge-expansion' ); ?>)</span></label><br />
					<input type="checkbox" tabindex="27" name="supports[]" id="edge_supports_author" value="author" <?php echo isset($form_data_flip['supports']['author']) ? 'checked' : ''; ?> <?php if(empty($form_data['supports'])){ echo 'checked';} ?> /> <label for="edge_supports_author"><?php esc_html_e( 'Author', 'edge-expansion' ); ?><span class="default">(<?php esc_html_e( 'default', 'edge-expansion' ); ?>)</span></label><br />
					<input type="checkbox" tabindex="28" name="supports[]" id="edge_supports_trackbacks" value="trackbacks" <?php echo isset($form_data_flip['supports']['trackbacks']) ? 'checked' : ''; ?> /> <label for="edge_supports_trackbacks"><?php esc_html_e( 'Trackbacks', 'edge-expansion' ); ?></label><br />
					<input type="checkbox" tabindex="29" name="supports[]" id="edge_supports_custom_fields" value="custom-fields" <?php echo isset($form_data_flip['supports']['custom-fields']) ? 'checked' : ''; ?> /> <label for="edge_supports_custom_fields"><?php esc_html_e( 'Custom Fields', 'edge-expansion' ); ?></label><br />
					<input type="checkbox" tabindex="30" name="supports[]" id="edge_supports_comments" value="comments" <?php echo isset($form_data_flip['supports']['comments']) ? 'checked' : ''; ?> /> <label for="edge_supports_comments"><?php esc_html_e( 'Comments', 'edge-expansion' ); ?></label><br />
					<input type="checkbox" tabindex="31" name="supports[]" id="edge_supports_revisions" value="revisions" <?php echo isset($form_data_flip['supports']['revisions']) ? 'checked' : ''; ?> /> <label for="edge_supports_revisions"><?php esc_html_e( 'Revisions', 'edge-expansion' ); ?></label><br />
					<input type="checkbox" tabindex="32" name="supports[]" id="edge_supports_page_attributes" value="page-attributes" <?php echo isset($form_data_flip['supports']['page-attributes']) ? 'checked' : ''; ?> /> <label for="edge_supports_page_attributes"><?php esc_html_e( 'Page Attributes', 'edge-expansion' ); ?></label><br />
					<input type="checkbox" tabindex="33" name="supports[]" id="edge_supports_post_formats" value="post-formats" <?php echo isset($form_data_flip['supports']['post-formats']) ? 'checked' : ''; ?> /> <label for="edge_supports_post_formats"><?php esc_html_e( 'Post Formats', 'edge-expansion' ); ?></label><br />

                    </td>
                </tr>
            </table>
            <p>
                <input type="submit" name="<?php echo $is_edit ? 'update_cpt' : 'save_cpt'; ?>" class="button-primary" value="<?php echo $is_edit ? esc_html_e('Update','edge-expansion') : esc_html_e('Create','edge-expansion'); ?>" />
            </p>
        </form>
    </div>
    <?php
    
}


function edgeex_cptc_list_page() {
    if (isset($_POST['delete_cpt']) && check_admin_referer('cptc_delete')) {
        if (isset($_POST['slug'])) {
            $slug = sanitize_text_field(wp_unslash($_POST['slug']));
        }
        edgeex_cptc_delete_custom_post_type($slug);
        wp_safe_redirect(esc_url(admin_url('admin.php?page=edgeex_cptc_list')));
        exit;
    }

    $custom_types = get_option('edgeex_custom_post_types', []);
    ?>
    <div class="wrap">
        <h1><?php esc_html_e( 'List of Custom Post Types', 'edge-expansion' ); ?></h1>
        <table class="widefat">
            <thead>
                <tr>
                    <th><?php esc_html_e( 'Post Type', 'edge-expansion' ); ?></th>
                    <th><?php esc_html_e( 'Label', 'edge-expansion' ); ?></th>
                    <th><?php esc_html_e( 'Operation', 'edge-expansion' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($custom_types)): ?>
                    <?php foreach ($custom_types as $slug => $args): ?>
                        <tr>
                            <td><span style="font-size:1.2em;font-weight:600;"><?php echo esc_html($slug); ?></span></td>
                            <td><?php echo esc_html($args['labels']['name']); ?></td>
                            <!-- Add to Post Type List View -->
                            <td>
                            <a href="<?php echo esc_url(admin_url('admin.php?page=edgeex_cptc_form&slug=' . esc_attr($slug))); ?>" class="button"><?php esc_html_e('Edit', 'edge-expansion' ); ?></a>
                            <form method="post" style="display:inline;">
                            <?php wp_nonce_field('cptc_delete'); ?>
                            <input type="hidden" name="slug" value="<?php echo esc_attr($slug); ?>" />
                            <button type="submit" name="delete_cpt" class="button button-danger" onclick="return confirm(<?php esc_html_e('Are you sure you want to delete?', 'edge-expansion' ); ?>);">
                            <?php esc_html_e( 'Delete', 'edge-expansion' ); ?>
                            </button>
                            </form>
                            </td>

                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="3"><?php esc_html_e( 'There are no custom post types registered yet.', 'edge-expansion' ); ?></td></tr>
                <?php endif; ?>
            </tbody>
        </table>

        <p><a href="?page=edgeex_cptc_form" class="button button-primary"><?php esc_html_e( 'New addition', 'edge-expansion' ); ?></a></p>
    </div>
    <?php
}

function edgeex_cptc_delete_custom_post_type($slug) {
    $custom_types = get_option('edgeex_custom_post_types', []);
    if (isset($custom_types[$slug])) {
        unset($custom_types[$slug]);
        update_option('edgeex_custom_post_types', $custom_types);
    }
}

