<?php
/**
 * Custom Post Type
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */


if (!defined('ABSPATH')) exit;

// Output buffering to avoid header warnings
ob_start();

require_once EDGEEX_PLUGIN_DIR . '/inc/custom-post-type/includes/functions.php';
require_once EDGEEX_PLUGIN_DIR . '/inc/custom-post-type/includes/admin-page.php';
require_once EDGEEX_PLUGIN_DIR . '/inc/custom-post-type/block/custom-post-type.php';

// Register saved post types on plugin activation
add_action('init', 'edgeex_cptc_register_custom_post_types');

function edgeex_cptc_register_custom_post_types() {
    $custom_types = get_option('edgeex_custom_post_types', []);

    foreach ($custom_types as $slug => $args) {
        register_post_type($slug, [
            'labels' => [  
                'name' => $args['labels']['name'],
                'singular_name' => $args['labels']['singular_name'], 
                'add_new' => __( 'Add New', 'edge-expansion' ),
                'add_new_item' => __( 'Add New Post', 'edge-expansion' ),
                'edit_item' => __( 'Edit Post', 'edge-expansion' ),
                'new_item' => __( 'New Post', 'edge-expansion' ),
                'view_item' => __( 'View Post', 'edge-expansion' ),
                'view_items' => __( 'View Post', 'edge-expansion' ),
                'search_items' => __( 'Search Posts', 'edge-expansion' ),
                'not_found' => __( 'No posts found.', 'edge-expansion' ),
                'not_found_in_trash' => __( 'No posts found in Trash.', 'edge-expansion' ),
            ],
            'public' => $args['public'],
            'hierarchical' => $args['hierarchical'],
            'publicly_queryable' => $args['publicly_queryable'],
            'show_ui' => $args['show_ui'],
            'show_in_menu' => $args['show_in_menu'],
            'show_in_rest' => $args['show_in_rest'],
            'menu_position' => $args['menu_position'],
            'capability_type' => $args['capability_type'],
            'has_archive' => $args['has_archive'],
            'rewrite' => $args['rewrite'],
            'custom_rewrite_slug' => $args['custom_rewrite_slug'],
            'with_front' => $args['with_front'],
            'query_var' => $args['query_var'],
            'exclude_from_search' => $args['exclude_from_search'],
            'supports' => $args['supports'] ?? ['title', 'editor','excerpt','thumbnail','author'],
            'menu_icon' => 'dashicons-admin-post',
        ]);
    }
}

add_action('init', 'edgeex_cptc_register_custom_taxonomy');

function edgeex_cptc_register_custom_taxonomy(){
    $custom_types = get_option('edgeex_custom_post_types', []);
    foreach ($custom_types as $slug => $args) {
        $taxonomy='edgeex_'.$slug;
        register_taxonomy($taxonomy,array($slug), array(
            'label' => __('Category','edge-expansion'),
            'public' => true,
            'hierarchical' => true,
            'show_ui' => true,
            'show_in_rest' => true,
            'rewrite' => true,
            'show_admin_column'=> true
        ));
    }
}

function edgeex_custom_post_manager_admin_register_css() {
	wp_register_style(
    	'edgeex-custom-post-manager-admin-style',
    	EDGEEX_PLUGIN_URL . '/inc/custom-post-type/css/admin-style.css',
        array(),
		1.4
    );
    wp_enqueue_style('edgeex-custom-post-manager-admin-style');
}
add_action( 'admin_enqueue_scripts', 'edgeex_custom_post_manager_admin_register_css' );
