<?php
/**
 * Plugin Name:       Custom Post Type
 * Description:       Add custom post types and custom taxonomies
 * Version:           1.1.0
 * Requires at least: 6.7
 * Requires PHP:      7.4
 * Author:            EastEdge
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       edge-expansion
 *
 * @package Edge
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function edgeex_custom_post_type_block_register_block() {
  
  //Asset file path
  $script_asset_path = EDGEEX_PLUGIN_DIR . 'inc/custom-post-type/block/build/index.asset.php';
  if ( ! file_exists( $script_asset_path ) ) {
    throw new Error(
      'You need to run `npm start` or `npm run build`'
    );
  }
  
  //Registering a block script
  $index_js     = 'build/index.js';
  $script_asset = require( $script_asset_path );
    wp_register_script(
      'edge-custom-posts-type-block-editor',
      EDGEEX_PLUGIN_URL . '/inc/custom-post-type/block/' . $index_js,
      $script_asset['dependencies'], //Dependencies described in asset files
      $script_asset['version'], //The version stated in the asset file
        array( 'wp-blocks', 'wp-element', 'wp-i18n', 'wp-block-editor' )
    );
    $editor_css = 'build/index.css';
    wp_register_style(
      'edge-custom-posts-type-block-editor',
      EDGEEX_PLUGIN_URL . '/inc/custom-post-type/block/' . $editor_css,
      array(),
      filemtime( EDGEEX_PLUGIN_DIR . 'inc/custom-post-type/block/'.$editor_css )
    );
    $style_css = 'build/style-index.css';
    wp_register_style(
      'edge-custom-posts-type-block',
      EDGEEX_PLUGIN_URL . '/inc/custom-post-type/block/' . $style_css,
      array(),
      filemtime( EDGEEX_PLUGIN_DIR . 'inc/custom-post-type/block/'.$style_css )
    );
    register_block_type(EDGEEX_PLUGIN_DIR . 'inc/custom-post-type/block/build', array(
        'render_callback' => 'edgeex_custom_post_type_block_render_callback',
    ) );
}
add_action( 'init', 'edgeex_custom_post_type_block_register_block' );

function edgeex_custom_post_type_block_render_callback( $attributes ) {
    
    $post_type = $attributes['postType'];
    $post_count = $attributes['postCount'];
    $args = array(
        'post_type' => $post_type,
        'posts_per_page' => $post_count,
    );
    $query = new WP_Query( $args );
    $num_cols = $attributes['columnsNum'] > 1 ? strval( $attributes['columnsNum'] ) : '1';
    ob_start();
    if ( $query->have_posts() ) {
        echo '<ul class="wp-block-custom-post-type-items columns-' . esc_html($num_cols) . '">';
        while ( $query->have_posts() ) {
            $query->the_post();
            echo '<li class="custompost-item">';
            echo '<div class="wp-block-custom-post-type-thumbnail">';
            if ( $attributes['showImage'] && has_post_thumbnail() ) {
                the_post_thumbnail();
            }
            echo '</div>';

		    $url = esc_url( get_permalink() );
        
            echo '<div class="wp-block-custom-post-type-content">';
            echo '<h4 class="wp-block-custom-post-type-title" style="font-size:'.esc_html($attributes['fontSize']).';"><a href="' . esc_html($url) . '">' . esc_html(get_the_title()) . '</a></h4>';
            echo '<div class="wp-block-latest-posts-block-meta">';
            
            if ( $attributes['showDate'] ) {
                echo '<span class="wp-block-custom-post-type-date">';
                echo get_the_date();
                echo '</span>';
            }
            if ( $attributes['showTaxonomy'] ) {
                $ID= get_the_ID();
                $obj = get_queried_object($ID);
                if(get_the_taxonomies()):
                    $tax_slug = array_keys(get_the_taxonomies()) [0] ;
                    $terms= get_the_terms($ID,$tax_slug);
                    if($terms):
                        echo '<span class="wp-block-custom-post-type-category">';
                            echo get_the_term_list($ID, $tax_slug, '', ' ');
                        echo '</span>';
                    endif;
                else:
                    $tax_slug = '';
                endif;
                
            }
            if ( $attributes['showAuthor'] ) {
                echo '<span class="wp-block-custom-post-type-author">';
                echo get_the_author();
                echo '</span>';
            }
            echo '</div>';
            if ( $attributes['showExcerpt'] ) {
                echo '<div class="wp-block-custom-post-type-excerpt">';
                echo esc_html(get_the_excerpt());
                echo '</div>';
            }
            echo '</div>';
            echo '</li>';
        }
        echo '</ul>';
    }
    wp_reset_postdata();

    return ob_get_clean();
}
