<?php
/**
 * Child Pages Index
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function edgeex_render_child_pages_index($attributes) {
    $post_id = get_the_ID();
    if (!$post_id) {
        return '<p>Error: Unable to retrieve post ID.</p>';
    }
    
    $parent_page_id = wp_get_post_parent_id($post_id) ?: $post_id;
    
    $child_pages = get_pages(array(
        'parent' => $parent_page_id,
        'sort_column' => 'menu_order'
    ));
    
    //ob_start();
    $output = '<div class="child-pages-index">';
            $parent_page = get_post($parent_page_id);
            if (!empty($attributes['showParent']) && $attributes['showParent']=='1') :
                $output .= '<div class="parent-page">';
                if (!empty($attributes['showThumbnail']) && has_post_thumbnail($parent_page->ID)) :
                $output .= '<div class="wp-block-child-page-index-thumbnail">';
                $output .= '<img src="'.get_the_post_thumbnail_url($parent_page->ID, 'large').'" alt="'.esc_attr($parent_page->post_title).'">';
                $output .= '</div>';
                endif;
            
                $output .= '<h4 class="wp-block-parent-page-block-title" style="font-size:'.$attributes['parentFontSize'].';"><a href="'.get_permalink($parent_page->ID).'">'.esc_html($parent_page->post_title).'</a></h4>';
                $output .= '<div class="wp-block-child-pages-block-meta">';
                if (!empty($attributes['showDate'])) :
                    $output .= '<span class="wp-block-child-pages-block-date">';
                    $output .= esc_html(get_the_date('', $parent_page->ID));
                    $output .= '</span>';
                endif;
                if (!empty($attributes['showAuthor'])) :
                    $output .= '<span class="wp-block-child-pages-block-author">';
                    $output .= esc_html(get_the_author_meta('display_name', $parent_page->post_author));
                    $output .= '</span>';
                endif;
                $output .= '</div>';
                if (!empty($attributes['showExcerpt'])) :
                    $output .= '<p>'. esc_html(wp_trim_words(get_the_excerpt($parent_page->ID), 20)).'</p>';
                endif;
                $output .= '</div>';
            endif;
        
        if (!empty($child_pages)) :
            $output .= '<ul class="wp-block-child-pages-block-items columns-'.$attributes['numberColumns'].'">';
                foreach ($child_pages as $child) :
                    $output .= '<li class="child-pages-item">';
                    if (!empty($attributes['showThumbnail'])) :
                        if (has_post_thumbnail($child->ID)) :
                             $output .= '<div class="wp-block-child-pages-block-thumbnail">';
                            $output .= get_the_post_thumbnail($child->ID, 'large');
                            $output .= '</div>';
                        endif;
                    endif;
                    $output .= '<div class="wp-block-child-pages-block-content">';
                    $output .= '<h4 class="wp-block-child-pages-block-title" style="font-size:'.$attributes['fontSize'].'"><a href="'. get_permalink($child->ID).'">'. esc_html($child->post_title).'</a></h4>';
                    $output .= '<div class="wp-block-child-pages-block-meta">';
                    if (!empty($attributes['showDate'])) :
                        $output .= '<span class="wp-block-child-pages-block-date">';
                        $output .= esc_html(get_the_date('', $child->ID));
                        $output .= '</span>';
                    endif;
                    if (!empty($attributes['showAuthor'])) :
                         $output .= '<span class="wp-block-child-pages-block-author">';
                        $output .= esc_html(get_the_author_meta('display_name', $child->post_author));
                        $output .= '</span>';
                    endif;
                    $output .= '</div>';
                    if (!empty($attributes['showExcerpt'])) :
                        $output .= '<p>'. esc_html(wp_trim_words(get_the_excerpt($child->ID), 20)).'</p>';
                    endif;
                    $output .= '</div>';
                    $output .= '</li>';
                endforeach;
                $output .= '</ul>';
        else :
            $output .= '<p>'. esc_html_e('No child pages found.', 'edge-expansion').'</p>';
        endif;
    $output .= '</div>';
    return $output;
    //return ob_get_clean();
}
function edgeex_register_child_pages_index_block() {
    register_block_type(EDGEEX_PLUGIN_DIR . '/inc/child-pages-index/build', array(
        'render_callback' => 'edgeex_render_child_pages_index'
    ));
}
add_action('init', 'edgeex_register_child_pages_index_block');
