<?php

function edge_button_block_render_callback($attributes){
    $attributes = $attributes ?? [];
    $text = $attributes['buttonText'] ?? 'Click Me';
    $buttonWidth = $attributes['buttonWidth'] ?? 108;
    $buttonHeight = $attributes['buttonHeight'] ?? 36;
    $fontSize = $attributes['fontSize'] ?? '21px';
    $textColor = $attributes['textColor'] ?? '#ffffff';
    $backgroundColor = $attributes['bgColor'] ?? '#0073aa';
    $hoverTextColor = $attributes['hoverTextColor'] ?? '#ffffff';
    $hoverBackgroundColor = $attributes['hoverBgColor'] ?? '#005177';
    $borderRadius = $attributes['borderRadius'] ?? 4;
    $borderColor = $attributes['borderColor'] ?? '#000000';
    $borderWidth = $attributes['borderWidth'] ?? 2;
    $paddingVertical= $attributes['paddingVertical'] ?? 4;
    $textAlign = $attributes['textAlign'] ?? 'center';
    $alignment = $attributes['alignment'] ?? 'center';
    //$buttonLink = $attributes['buttonLink'] ?? '#';
    $url = $attributes['url'] ?? 'url';
    $blank   = ! empty( $attributes['opensInNewTab'] );
    $target = $blank ? ' target="_blank" rel="noopener noreferrer"' : '';
    //var_dump($hoverTextColor);
    $style = "
        --width:{$buttonWidth}px;
        --height:{$buttonHeight}px;
        --color: $textColor;
        --background-color: $backgroundColor;
        --border-radius: {$borderRadius}%;
        --border-width:{$borderWidth}px;
        --border-color:$borderColor;
        --text-align: $textAlign;
	    --line-height: {$paddingVertical}px;
        font-size:$fontSize;
        line-height: {$paddingVertical}px;
    ";

    $hoverStyle = "
        --hover-text-color: $hoverTextColor;
        --hover-background-color: $hoverBackgroundColor; 
        --border-radius: {$borderRadius}%;
    ";

    $output = '<div class="wp-block-custom-button-block" style="text-align:'.esc_attr($alignment).';">';
    $output .= '<div class="custom-button">';
    $output .= '<a href="'.esc_html($url).'" '.esc_attr($target).' style="'.esc_attr($style .$hoverStyle ).'">';
    $output .= esc_html($text);
    $output .= '</a>';
    $output .= '</div>';
    $output .= '</div>';
    
    return $output;
}
