<?php
/**
 * Custom Buttons
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function edge_button_block_register() {
	$dir = __DIR__;
	
	wp_register_script(
		'button-block-editor-script',
    EDGEEX_PLUGIN_URL . 'inc/button-custom/build/index.js',
		[ 'wp-blocks', 'wp-element', 'wp-editor', 'wp-components', 'wp-i18n' ],
		filemtime( EDGEEX_PLUGIN_DIR . 'inc/button-custom/build/index.js' ),
    ['strategy'  => 'defer','in_footer' => true]
	);

	wp_register_style(
		'button-block-editor-style',
    EDGEEX_PLUGIN_URL . 'inc/button-custom/build/index.css',
		[],
		filemtime( EDGEEX_PLUGIN_DIR . 'inc/button-custom/build/index.css' )
	);

	wp_register_style(
		'button-block-style',
    EDGEEX_PLUGIN_URL . 'inc/button-custom/build/style-index.css',
    //EDGEEX_PLUGIN_URL . 'inc/button-custom/style.css',
		[],
		filemtime( EDGEEX_PLUGIN_DIR . 'inc/button-custom/build/style-index.css' )
		//filemtime( EDGEEX_PLUGIN_DIR . 'inc/button-custom/style.css' )
	);


    register_block_type(EDGEEX_PLUGIN_DIR . '/inc/button-custom/build', [
		'editor_script'   => 'button-block-editor-script',
		'editor_style'    => 'button-block-editor-style',
		'style'           => 'button-block-style',
		'render_callback' => 'edge_button_block_render_callback',
    'editor_script' => 'edge-expansion-script',
	  'attributes' => [
      'buttonText' => [
        'type' => 'string',
        'default' => 'Click me'
      ],
      'buttonWidth' => [
        'type' => 'number',
        'default' => 108
      ],
      'buttonHeight' => [
        'type' => 'number',
        'default' => 36
      ],
      'fontSize' => [
        'type' => 'string',
        'default' => '21px'
      ],
      'textColor' => [
        'type' => 'string',
        'default' =>'#ffffff'
      ],
      'bgColor' => [
        'type' => 'string',
        'default' => '#000000'
      ],
      'hoverTextColor' => [
        'type' => 'string',
        'default' =>  '#ffffff'
      ],
      'hoverBgColor' => [
        'type' => 'string',
        'default' => '#005177'
      ],
      'borderRadius' => [
        'type' => 'number',
        'default' => 5
      ],
      'borderColor' => [
        'type' => 'string',
        'default' => '#000000'
      ],
      'borderWidth' => [
        'type' => 'number',
        'default' => 2
      ],
      'paddingVertical' => [
        'type' => 'number',
        'default' => 4
      ],
      'textAlign' => [
        'type' => 'string',
        'default' => 'center'
      ],
      'alignment' => [
        'type' => 'string',
        'default' => 'center'
      ],
      'url' => [
        'type' => 'string',
        'default' => ''
      ],
      'buttonLink' => [
        'type' => 'string',
        'default' => '#'
      ],
    ]
  ] );
}
add_action('init', 'edge_button_block_register');

require_once EDGEEX_PLUGIN_DIR . '/inc/button-custom/render.php';

