jQuery(document).ready(function($) {
    function updatePreview() {
        let button_shape = $('#button_shape').val();
        let size = $('#button_size').val() + 'px';
        let color = $('#button_bgcolor').val();
        let hoverColor = $('#button_hover_bgcolor').val();
        let bottom = $('#button_pos_bottom').val() + 'px';
        let right = $('#button_pos_right').val() + 'px';
        let arrow_color = $('#arrow_color').val();
        let arrow_shape = $('#arrow_shape').val();
        let arrow_size = $('#arrow_size').val() + 'px';
        let arrow_position_top = $('#arrow_position_top').val() + 'px';
        let arrow_position_left = $('#arrow_position_left').val() + 'px';
        
        if(button_shape=='circle'){
            $('#button-preview').css({
            'border-radius': '50%',
            'width': size,
            'height': size,
            'background-color': color,
            'bottom': bottom, 
            'right': right
            });
        } else if(button_shape=='square'){
            $('#button-preview').css({
            'border-radius': '0%',
            'width': size,
            'height': size,
            'background-color': color,
            'bottom': bottom, 
            'right': right
            });
        }
        if(arrow_shape=='chevron'){
            $('#arrow-preview').css({
                'color': arrow_color,
                'arrow-shape': arrow_shape,
                'font-size': arrow_size,
                'top': arrow_position_top,
                'left': arrow_position_left
            });
            $(".arrow-dashicons").addClass("dashicons dashicons-arrow-up-alt2");
        }
        else if(arrow_shape=='triangle'){
            $('#arrow-preview').css({
                'color': arrow_color,
                'arrow-shape': arrow_shape,
                'font-size': arrow_size,
                'top': arrow_position_top,
                'left': arrow_position_left
            });
            $(".arrow-dashicons").addClass("dashicons dashicons-arrow-up");
        }
        else if(arrow_shape=='arrow'){
            $('#arrow-preview').css({
                'color': arrow_color,
                'arrow-shape': arrow_shape,
                'font-size': arrow_size,
                'top': arrow_position_top,
                'left': arrow_position_left
            });
            $(".arrow-dashicons").addClass("dashicons dashicons-arrow-up-alt");
        }

        // Remove any existing hover style
        $('#button-hover-style').remove();

        // Append new hover style
        const style = `<style id="button-hover-style">
            #button-preview:hover {
                background-color: ${hoverColor} !important;
            }
        </style>`;
        $('head').append(style);

        
    }
    $('#button_shape, #button_size, #button_bgcolor, #button_hover_bgcolor, #button_pos_bottom, #button_pos_right,#arrow_color,#arrow_shape,#arrow_size,#arrow_position_top,#arrow_position_left').on('input change', updatePreview);
    
    updatePreview(); // Initial value reflected
});
