<?php
/**
 * Button Back to Top
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function edgeex_backtotop_admin() {
	require_once EDGEEX_PLUGIN_DIR . '/inc/button-backtotop/button-backtotop-admin.php';
}

add_action( 'wp_footer', 'edgeex_add_backtotop' );
function edgeex_add_backtotop() {
	$option = get_option( 'edgeex_backtotop_options' );
	if(!empty($option)){
  		if(!wp_is_mobile() || (wp_is_mobile() && empty($option['hide_mobile']))){
			if($option['button_shape']=='square'){
				$shape='0';
			}elseif($option['button_shape']=='circle'){
				$shape='50%';
			}
			echo '<div id="retop" class="wp-block-edge-backtotop shape-'.esc_html($option['button_shape']).'" style="border-radius:'.esc_html($shape).';width:'.esc_html($option['button_size']).'px; height:'.esc_html($option['button_size']).'px;background-color:'.esc_html($option['button_bgcolor']).';bottom:'.esc_html($option['button_pos_bottom']).'px;right:'.esc_html($option['button_pos_right']).'px;" onMouseOut="this.style.background=\''.esc_html($option['button_bgcolor']).'\'" onMouseOver="this.style.background=\''.esc_html($option['button_hoverbgcolor']).'\'">';
			echo '<a href="#top"><span class="dashicons '.esc_html($option['arrow_shape']).'" style="font-size:'.esc_html($option['button_size']).'px;color:'.esc_html($option['arrow_color']).';font-size:'.esc_html($option['arrow_size']).'px;position:absolute;top:'.esc_html($option['arrow_position_top']).'px;left:'.esc_html($option['arrow_position_left']).'px;"><!--Return Top--></span></a></div>';
		}
	}else{
		$default = edgeex_get_backtotop_options_default();

		echo '<div id="retop" class="wp-block-edge-backtotop shape-'.esc_html($default['button_shape']).'" style="border-radius:50%;width:'.esc_html($default['button_size']).'px; height:'.esc_html($default['button_size']).'px;background-color:'.esc_html($default['button_bgcolor']).';bottom:'.esc_html($default['button_pos_bottom']).'px;right:'.esc_html($default['button_pos_right']).'px;" onMouseOut="this.style.background=\''.esc_html($default['button_bgcolor']).'\'" onMouseOver="this.style.background=\''.esc_html($default['button_hoverbgcolor']).'\'">';
		echo '<a href="#top"><span class="dashicons '.esc_html($default['arrow_shape']).'" style="font-size:'.esc_html($default['button_size']).'px;color:'.esc_html($default['arrow_color']).';font-size:'.esc_html($default['arrow_size']).'px;position:absolute;top:'.esc_html($default['arrow_position_top']).'px;left:'.esc_html($default['arrow_position_left']).'px;"><!--Return Top--></span></a></div>';
		
	}
}

/*
  Options Init
/*-------------------------------------------*/

function edgeex_backtotop_options_init() {

	$edgeex_args = array('button-backtotop', esc_html__( 'Back to Top Button', 'edge-expansion' ),'edgeex_backtotop_options','edgeex_backtotop_admin');
	edgeex_argument($edgeex_args);
}
add_action( 'edgeex_component_init', 'edgeex_backtotop_options_init' );

function edgeex_get_backtotop_options_default() {
	$default_options = array(
		'button_shape' => 'circle',
		'button_size' => '46',
		'button_bgcolor' => '#333333',
		'button_hoverbgcolor' => '#666666',
		'arrow_color' => '#ffffff',
		'button_pos_bottom' => '24',
		'button_pos_right' => '16',
		'arrow_shape' => 'chevron',
		'arrow_size' => '44',
		'arrow_position_top' => '0',
		'arrow_position_left' => '0',
		'hide_mobile' => false,
	);
	return $default_options;
}

function edgeex_admin_enqueue_scripts( $hook_suffix ) {
    wp_enqueue_script( 'wp-color-picker' );
    wp_enqueue_style( 'wp-color-picker' );
    wp_add_inline_script(
      'wp-color-picker',
      'jQuery(document).ready(function($){
        $(\'.color-picker-hex\').wpColorPicker();
      });'
    );
}

add_action( 'admin_enqueue_scripts', 'edgeex_admin_enqueue_scripts' );

function edgeex_button_backtotop_register_css() {
	wp_register_style(
    	'edge-button-backtotop-style',
    	EDGEEX_PLUGIN_URL . '/inc/button-backtotop/css/style.css',
        array(),
		1.4
    );
    wp_enqueue_style(
		'edge-button-backtotop-style');
}
add_action( 'wp_enqueue_scripts', 'edgeex_button_backtotop_register_css' );
