<?php
if (!defined('ABSPATH')) exit;

$allowed_button = array( 'circle', 'square' );
$allowed_arrow = array( 'chevron', 'triangle', 'arrow' );
if(isset($_POST['edgeex_backtotop_options']) && check_admin_referer( 'backtotop_action', 'backtotop_nonce_field' )){
    $options = array(
		'button_shape' => isset($_POST['edgeex_backtotop_options']['button_shape']) && in_array(wp_unslash($_POST['edgeex_backtotop_options']['button_shape']), $allowed_button, true ) ? sanitize_textarea_field(wp_unslash($_POST['edgeex_backtotop_options']['button_shape'])) : 'circle',
		'button_size' =>  isset($_POST['edgeex_backtotop_options']['button_size']) ? intval( wp_unslash($_POST['edgeex_backtotop_options']['button_size']) ):'46',
		'button_bgcolor' => isset($_POST['edgeex_backtotop_options']['button_bgcolor']) ? sanitize_hex_color( wp_unslash($_POST['edgeex_backtotop_options']['button_bgcolor']) ):'#333333',
		'button_hoverbgcolor' => isset($_POST['edgeex_backtotop_options']['button_hoverbgcolor']) ? sanitize_hex_color(wp_unslash($_POST['edgeex_backtotop_options']['button_hoverbgcolor']) ):'#666666',
		'arrow_color' => isset($_POST['edgeex_backtotop_options']['arrow_color']) ? sanitize_hex_color( wp_unslash($_POST['edgeex_backtotop_options']['arrow_color']) ) :'#ffffff',
		'button_pos_bottom' =>  isset($_POST['edgeex_backtotop_options']['button_pos_bottom']) ? intval( wp_unslash($_POST['edgeex_backtotop_options']['button_pos_bottom']) ):'24',
		'button_pos_right' =>  isset($_POST['edgeex_backtotop_options']['button_pos_right']) ? intval( wp_unslash($_POST['edgeex_backtotop_options']['button_pos_right']) ):'16',
		'arrow_shape' => isset($_POST['edgeex_backtotop_options']['arrow_shape']) && in_array(wp_unslash($_POST['edgeex_backtotop_options']['arrow_shape']), $allowed_arrow, true ) ?  sanitize_textarea_field(wp_unslash($_POST['edgeex_backtotop_options']['arrow_shape'])) : 'chevron',
		'arrow_size' =>  isset($_POST['edgeex_backtotop_options']['arrow_size']) ? intval(wp_unslash($_POST['edgeex_backtotop_options']['arrow_size']) ):'0',
		'arrow_position_top' =>  isset($_POST['edgeex_backtotop_options']['arrow_position_top']) ? intval( wp_unslash($_POST['edgeex_backtotop_options']['arrow_position_top']) ):'0',
		'arrow_position_left' =>  isset($_POST['edgeex_backtotop_options']['arrow_position_left']) ? intval( wp_unslash($_POST['edgeex_backtotop_options']['arrow_position_left']) ):'0',
		'hide_mobile' => isset( $_POST['edgeex_backtotop_options']['hide_mobile'] ) ? 1 : 0,
    );
    update_option( 'edgeex_backtotop_options', $options );
    echo '<div class="updated"><p>'.esc_html__('Your settings are saved.','edge-expansion').'</p></div>';
}
    
	$options =  get_option('edgeex_backtotop_options',edgeex_get_backtotop_options_default());
?>

<h3 class="subt-txt"><?php esc_html_e( 'Button to return Page Top', 'edge-expansion' ); ?></h3>
<div class="wrapper">
<form method="post" action="">
<?php
	wp_nonce_field( 'backtotop_action', 'backtotop_nonce_field' );
?>
<table class="form-table">
<tr>
	<th class="label"><?php esc_html_e( 'Button Shape', 'edge-expansion' ); ?></th>
	<td>
		<label>
		<select name="edgeex_backtotop_options[button_shape]" id="button_shape">
			<?php if(isset($options['button_shape'])):?>
			<option value="circle" <?php if( 'circle' == $options['button_shape']) echo ' selected'; ?> /><?php esc_html_e('circle','edge-expansion');?></option>
			<option value="square" <?php if( 'square' == $options['button_shape']) echo ' selected'; ?> /><?php esc_html_e('square','edge-expansion');?></option>
		<?php else:?>
			<option value="circle" selected /><?php esc_html_e('circle','edge-expansion');?></option>
			<option value="square" /><?php esc_html_e('square','edge-expansion');?></option>
			<?php endif;?>
			
		</select>
	</label>
	</td>
</tr>
<tr>
	<th class="label"><label for="button_size"><?php esc_html_e( 'Button Size', 'edge-expansion' ); ?></label></th>
	<td>
		<label>
		<input type="number" name="edgeex_backtotop_options[button_size]" id="button_size" step="1" min="12" max="120" value="<?php if(isset($options['button_size'])) echo esc_attr( $options['button_size'] ); ?>" style="" /></label>
		
	</td>
</tr>
<tr valign="top">
    <th scope="row"><label for="edge-original-color"><?php esc_html_e( 'Button background color', 'edge-expansion' ); ?></label></th>
    <td>
		<input name="edgeex_backtotop_options[button_bgcolor]" class="color-picker-hex" type="text" id="button_bgcolor" maxlength="7" value="<?php if(isset($options['button_bgcolor'])) echo esc_attr( $options['button_bgcolor'] ); ?>" placeholder="#222222" data-default-color="#222222">

	</td>
</tr>
<tr valign="top">
    <th scope="row"><label for="edge-original-color"><?php esc_html_e( 'Button hover background color', 'edge-expansion' ); ?></label></th>
    <td>
		<input name="edgeex_backtotop_options[button_hoverbgcolor]" class="color-picker-hex" type="text" id="button_hbgcolor" maxlength="7" value="<?php if(isset($options['button_hoverbgcolor'])) echo esc_attr( $options['button_hoverbgcolor'] ); ?>" placeholder="#222222" data-default-color="#222222">

	</td>
</tr>
<tr valign="top">
    <th scope="row"><label for="edge-original-color"><?php esc_html_e( 'Arrow color', 'edge-expansion' ); ?></label></th>
    <td>
		<input name="edgeex_backtotop_options[arrow_color]" class="color-picker-hex" type="text" id="arrow_color" maxlength="7" value="<?php if(isset($options['arrow_color'])) echo esc_attr( $options['arrow_color'] ); ?>" placeholder="#ffffff" data-default-color="#222222">

	</td>
</tr>
<tr>
	<th class="label"><label for="button_pos_bottom"><?php esc_html_e( 'Button Position(bottom)', 'edge-expansion' ); ?></label></th>
	<td>
		<label>
		<input type="number" name="edgeex_backtotop_options[button_pos_bottom]" id="button_pos_bottom" step="1" min="0" max="120" value="<?php if(isset($options['button_pos_bottom'])) echo esc_attr( $options['button_pos_bottom'] ); ?>" style="" /></label>
		
	</td>
</tr>
<tr>
	<th class="label"><label for="button_pos_right"><?php esc_html_e( 'Button Position(Right)', 'edge-expansion' ); ?></label></th>
	<td>
		<label>
		<input type="number" name="edgeex_backtotop_options[button_pos_right]" id="button_pos_right" step="1" min="0" max="120" value="<?php if(isset($options['button_pos_right'])) echo esc_attr( $options['button_pos_right'] ); ?>" style="" /></label>
		
	</td>
</tr>
<tr>
	<th class="label"><?php esc_html_e( 'Arrow Shape', 'edge-expansion' ); ?></th>
	<td>
		<label>
		<select name="edgeex_backtotop_options[arrow_shape]" id="arrow_shape">
			<?php if(isset($options['arrow_shape'])):?>
			<option value="chevron" <?php if( 'chevron' == $options['arrow_shape']) echo ' selected'; ?> /><?php esc_html_e('Chevron','edge-expansion');?></option>
			<option value="triangle" <?php if( 'triangle' == $options['arrow_shape']) echo ' selected'; ?> /><?php esc_html_e('Triangle','edge-expansion');?></option>
			<option value="arrow" <?php if( 'arrow' == $options['arrow_shape']) echo ' selected'; ?> /><?php esc_html_e('Arrow','edge-expansion');?></option>
		<?php else:?>
			<option value="chevron" selected /><?php esc_html_e('Chevron','edge-expansion');?></option>
			<option value="triangle" /><?php esc_html_e('Triangle','edge-expansion');?></option>
			<option value="arrow" /><?php esc_html_e('Arrow','edge-expansion');?></option>
		<?php endif;?>
		</select>
	</label>
				
	</td>
</tr>
<tr>
	<th class="label"><label for="arrow_size"><?php esc_html_e( 'Arrow Size', 'edge-expansion' ); ?></label></th>
	<td>
		<label>
		<input type="number" name="edgeex_backtotop_options[arrow_size]" id="arrow_size" step="1" min="12" max="120" value="<?php if(isset($options['arrow_size'])) echo esc_attr( $options['arrow_size'] ); ?>" style="" /></label>
		
	</td>
</tr>
<tr>
	<th class="label"><label for="arrow_position_top"><?php esc_html_e( 'arrow position(Top)', 'edge-expansion' ); ?></label></th>
	<td>
		<label>
		<input type="number" name="edgeex_backtotop_options[arrow_position_top]" id="arrow_position_top" step="1" min="-36" max="36" value="<?php if(isset($options['arrow_position_top'])) echo esc_attr( $options['arrow_position_top'] ); ?>" style="" /></label>
		
	</td> 
</tr>
<tr>
	<th class="label"><label for="arrow_position_left"><?php esc_html_e( 'arrow position(Left)', 'edge-expansion' ); ?></label></th>
	<td>
		<label>
		<input type="number" name="edgeex_backtotop_options[arrow_position_left]" id="arrow_position_left" step="1" min="-36" max="36" value="<?php if(isset($options['arrow_position_left'])) echo esc_attr( $options['arrow_position_left'] ); ?>" style="" /></label>
		
	</td>
</tr>
<tr>
<th class="label">&nbsp;</th>
<td><label>
<input type="checkbox" name="edgeex_backtotop_options[hide_mobile]" value="true"<?php if( ! empty( $options['hide_mobile'] ) ) echo ' checked'; ?> /> <?php esc_html_e( 'Not displayed on smartphones or tablets', 'edge-expansion' ); ?> </label>
</td>
</tr>
<tr>
	<td colspan="2">
    <?php submit_button(); ?>
    </td>
</tr>
</table>
</form>
<div id="button-preview" class="shape-circle" style="position:fixed; bottom:20px; right:20px; width:50px; height:50px; background-color:#000;border-radius:50%;">
<span id="arrow-preview" class="arrow-dashicons" style="color:#ffffff;font-size:1px;position:absolute;top:0px;left:0;"><!--Return Top--></span>
</div>
    
</div>
<?php
//}
add_action('admin_enqueue_scripts', 'edgeex_add_color_picker_admin_print_styles');
function edgeex_add_color_picker_admin_print_styles() {
	wp_enqueue_style( 'wp-color-picker' );
}

add_action('admin_enqueue_scripts', 'edgeex_add_color_picker_admin_print_scripts');
function edgeex_add_color_picker_admin_print_scripts() {
	wp_enqueue_script( 'wp-color-picker' );
	wp_enqueue_script( 
		'add-color-picker-admin-script', 
		EDGEEX_PLUGIN_URL . '/inc/button-backtotop/js/color-picker.js', 
		array( 'wp-color-picker' ), 
		'1.0.0', 
		true 
	);
}
