<?php
if (!defined('ABSPATH')) exit;

global $edgeex_attributes;
//Breadcrumbs
function edgeex_breadcrumb($edgeex_attributes) {
    global $post;
    $wp_obj = get_queried_object();
    $list = '<ul itemscope itemtype="http://schema.org/BreadcrumbList" style="font-size:'.$edgeex_attributes['fontSize'].'">';
  if ( !is_front_page() ) {
    if ( $edgeex_attributes['displayHomeIcon'] ):
      $list .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><a href="'.get_bloginfo('url').'" itemprop="item">
      <span class="dashicons dashicons-admin-home" style="font-size:'.$edgeex_attributes['fontSize'].';margin-right:'.$edgeex_attributes['homeIconMarginR'].'px;margin-top:'.$edgeex_attributes['homeIconMarginT'].'px;margin-bottom:'.$edgeex_attributes['homeIconMarginB'].'px;"></span><span itemprop="name" class="breadHome">'. $edgeex_attributes['homeText'].'</span></a><meta itemprop="position" content="1" /><div class="edgeicons dashicons '.$edgeex_attributes['icon'].'" style="font-size:'.$edgeex_attributes['iconSize'].'px;width:'.$edgeex_attributes['arrowWidth'].'px;margin-top:'.$edgeex_attributes['marginTop'].'px;margin-bottom:'.$edgeex_attributes['marginBottom'].'px;margin-right:'.$edgeex_attributes['marginRight'].'px;margin-left:'.$edgeex_attributes['marginLeft'].'px"></div></li>';
    else:
      $list .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><a href="'.get_bloginfo('url').'" itemprop="item">
      <span itemprop="name" class="breadHome">'. $edgeex_attributes['homeText'].'</span></a><meta itemprop="position" content="1" /><div class="edgeicons dashicons '.$edgeex_attributes['icon'].'" style="font-size:'.$edgeex_attributes['iconSize'].'px;width:'.$edgeex_attributes['arrowWidth'].'px;margin-top:'.$edgeex_attributes['marginTop'].'px;margin-bottom:'.$edgeex_attributes['marginBottom'].'px;margin-right:'.$edgeex_attributes['marginRight'].'px;margin-left:'.$edgeex_attributes['marginLeft'].'px"></div></li>';
    endif;
  }
 if ( is_front_page() ) {
      //Do not display on the top page
  }
  else if(is_home() && !is_front_page()){
    $list .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem">blog</li>';
  }
  // Category Page
  else if ( is_category() ) {
      $cat = get_queried_object();//A function that gets the information object for the currently requested query.
      $cat_id = $cat->parent;
      $cat_list = array();
      while ($cat_id != 0){
          $cat = get_category( $cat_id );
          $cat_link = get_category_link( $cat_id );
          array_unshift( $cat_list, '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><a href="'.$cat_link.'"><span itemprop="name">'.$cat->name.'</span></a><div class="edgeicons dashicons '.$edgeex_attributes['icon'].'" style="font-size:'.$edgeex_attributes['iconSize'].'px;width:'.$edgeex_attributes['arrowWidth'].'px;margin-top:'.$edgeex_attributes['marginTop'].'px;margin-bottom:'.$edgeex_attributes['marginBottom'].'px;margin-right:'.$edgeex_attributes['marginRight'].'px;margin-left:'.$edgeex_attributes['marginLeft'].'px"></div></li>' );
          $cat_id = $cat->parent;
      }
      //echo $home;
      foreach($cat_list as $value){
          $list .= $value;
      }
      $title = get_the_archive_title();
      $list .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><span itemprop="name">'.$title.'</span><li>';
  }
  // Archives/Tag Page
  else if ( is_archive() ) {
      $title = get_the_archive_title();
      $list .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><span itemprop="name">'.$title.'</span><li>';
  }
  elseif(is_post_type_archive()){
    $title = post_type_archive_title();
    $list .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><span itemprop="name">'.$title.'</span><li>';
  } 
  // Post page
  else if ( is_single() ) {
    $post_id    = $wp_obj->ID;
    $post_type  = $wp_obj->post_type;
    $post_title = apply_filters( 'the_title', $wp_obj->post_title );
    // Is it a custom post type?
    if ( $post_type !== 'post' ) {
      $the_tax = "";  //You can also explicitly specify each post type according to the site.
      // Get the taxonomy associated with a post type (excluding post formats)
      $tax_array = get_object_taxonomies( $post_type, 'names');
      foreach ($tax_array as $tax_name) {
          if ( $tax_name !== 'post_format' ) {
              $the_tax = $tax_name;
              break;
          }
      }
      $post_type_link = esc_url( get_post_type_archive_link( $post_type ) );
      $post_type_label = esc_html( get_post_type_object( $post_type )->label );
      //Displaying Custom Post Type Name
      $list .='<li>'.
            '<a href="'. $post_type_link .'"><span>'. $post_type_label .'</span></a><div class="edgeicons dashicons '.$edgeex_attributes['icon'].'" style="font-size:'.$edgeex_attributes['iconSize'].'px;width:'.$edgeex_attributes['arrowWidth'].'px;margin-top:'.$edgeex_attributes['marginTop'].'px;margin-bottom:'.$edgeex_attributes['marginBottom'].'px;margin-right:'.$edgeex_attributes['marginRight'].'px;margin-left:'.$edgeex_attributes['marginLeft'].'px"></div></li>';
    } else {

    $cat = get_the_category();
      if( isset($cat[0]->cat_ID) ) {
        $cat_id = $cat[0]->cat_ID;
        $cat_list = array();
        while ($cat_id != 0){
          $cat = get_category( $cat_id );
          $cat_link = get_category_link( $cat_id );
          array_unshift( $cat_list, '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><a href="'.$cat_link.'" itemprop="item"><span itemprop="name">'.$cat->name.'</span></a><div class="edgeicons dashicons '.$edgeex_attributes['icon'].'" style="font-size:'.$edgeex_attributes['iconSize'].'px;width:'.$edgeex_attributes['arrowWidth'].'px;margin-top:'.$edgeex_attributes['marginTop'].'px;margin-bottom:'.$edgeex_attributes['marginBottom'].'px;margin-right:'.$edgeex_attributes['marginRight'].'px;margin-left:'.$edgeex_attributes['marginLeft'].'px"></div></li>' );
          $cat_id = $cat->parent;
        }
        foreach($cat_list as $value){
          $list .= $value;
        }
      }
    $terms=get_post_type();
  }
      $title = the_title( '', '', false );
      $list .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><span itemprop="name">'.$title.'</span><li>';
    
  }
  // Static Pages
  else if( is_page() ) {
  $title = the_title( '', '', false );

  if($post -> post_parent != 0 ){
        $ancestors = array_reverse(get_post_ancestors( $post->ID ));
        foreach($ancestors as $ancestor){
            $list.='<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><a href="'. get_permalink($ancestor).'" itemprop="item"><span itemprop="title">'. get_the_title($ancestor) .'</span></a><div class="edgeicons dashicons '.$edgeex_attributes['icon'].'" style="font-size:'.$edgeex_attributes['iconSize'].'px;width:'.$edgeex_attributes['arrowWidth'].'px;margin-top:'.$edgeex_attributes['marginTop'].'px;margin-bottom:'.$edgeex_attributes['marginBottom'].'px;margin-right:'.$edgeex_attributes['marginRight'].'px;margin-left:'.$edgeex_attributes['marginLeft'].'px"></div></li>';
        }
    }
    $list .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem"><span itemprop="name">'.$title.'</span><li>';
  }
  else if( is_search() ) {
  $list .='<li>'. __( 'Search Result:', 'edge-expansion' ).get_search_query().'<li>';
    }
  //For 404 pages
  else if( is_404() ) {
  $list .= '<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem">'.__( 'Page Not Found', 'edge-expansion' ).'<li>';
  }
  $list .='</ul>';
  return $list;
}