<?php
/**
 * Breadcrumb Trail
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

require_once EDGEEX_PLUGIN_DIR . '/inc/breadcrumb-trail/trail.php';

function edgeex_breadcrumb_trail_init() {
  
  //Asset file path
  $script_asset_path = EDGEEX_PLUGIN_DIR .'/inc/breadcrumb-trail/build/index.asset.php';
  if ( ! file_exists( $script_asset_path ) ) {
    throw new Error(
      'You need to run `npm start` or `npm run build`'
    );
  }
  
  //Registering a block script
  $index_js     = 'build/index.js';
  $script_asset = require( $script_asset_path );
  wp_register_script(
    'edge-breadcrumb-trail-editor',
    EDGEEX_PLUGIN_URL . '/inc/breadcrumb-trail/' . $index_js,
    $script_asset['dependencies'], //Dependencies described in asset files
    $script_asset['version'], //The version stated in the asset file
	  array( 'wp-blocks', 'wp-element', 'wp-i18n', 'wp-block-editor' )
  );
  $editor_css = 'build/index.css';
  wp_register_style(
    'edge-breadcrumb-trail-editor',
    EDGEEX_PLUGIN_URL . '/inc/breadcrumb-trail/' . $editor_css,
    array(),
    filemtime( EDGEEX_PLUGIN_DIR . '/inc/breadcrumb-trail/'.$editor_css )
  );
  $style_css = 'build/style-index.css';
  wp_register_style(
    'edge-breadcrumb-trail',
    EDGEEX_PLUGIN_URL . '/inc/breadcrumb-trail/' . $style_css,
    array(),
    filemtime( EDGEEX_PLUGIN_DIR . '/inc/breadcrumb-trail/'.$style_css )
  );
 
  register_block_type( 'edge/breadcrumb-trail', array(
    'editor_script' => 'edge-breadcrumb-trail-editor',
    'editor_style'  => 'edge-breadcrumb-trail-editor',
    'style'         => 'edge-breadcrumb-trail',
    'render_callback' => 'edgeex_breadcrumb_trail_render',
    array(
    'title' => _x( 'Breadcrumb Trail', 'block title', 'edge-expansion' ),
    'description' => _x( 'A list of links in hierarchical order on a Web page', 'block description', 'edge-expansion' )
    ),
    'attributes' => [
      'homeText' => [
          'type' => 'string',
          'default' => ''
      ],
      'displayHomeIcon' => [
          'type' => 'boolean',
          'default' => true
      ],
      'homeIconMarginR' => [
          'type' => 'number',
          'default' => 0
      ],
      'homeIconMarginT' => [
          'type' => 'number',
          'default' => 0
      ],
      'homeIconMarginB' => [
          'type' => 'number',
          'default' => 0
      ],
      'title' => [
        'type' => 'string', 
        'default' =>''
      ], 
      'headingElem' => [
        'type' => 'string', 
        'default' =>'h3'
      ],
      'fontSize' => [
        'type' => 'string', 
        'default' => '16px'
      ],
      'icon' => [
        'type' => 'string', 
        'default' => 'dashicons-arrow-right-alt2'
      ],
      'iconSize' => [
        'type' => 'number', 
        'default' => 16
      ],
      'homeIcon' => [
        'type' => 'string', 
        'default' => 'home'
      ],
      'marginRight' => [
        'type' => 'number',
        'default' => 0
      ],
      'marginLeft' => [
        'type' => 'number',
        'default' => 0
      ],
      'marginTop' => [
        'type' => 'number',
        'default' => 0
      ],
      'marginBottom' => [
        'type' => 'number',
        'default' => 0
      ],
      'arrowWidth' => [
        'type' => 'number',
        'default' => 16
      ]
    ],  
  ) );
}
add_action( 'init', 'edgeex_breadcrumb_trail_init' );
 
function edgeex_breadcrumb_trail_render($attributes, $content) {
  
  $output = '<div class="wp-block-edge-breadcrumb-trail">';
  $output .= edgeex_breadcrumb($attributes);
  $output .= '</div>';
  return $output;
}
