jQuery(document).ready(function ($) {
    let frame;

    $('#atn-upload-btn').on('click', function (e) {
        e.preventDefault();

        if (frame) {
            frame.open();
            return;
        }

        frame = wp.media({
            title: 'Select an Alternate Thumbnail',
            button: { text: 'Use this image' },
            multiple: false
        });

        frame.on('select', function () {
            const attachment = frame.state().get('selection').first().toJSON();
            $('#atn_thumbnail_id').val(attachment.id);
            $('#atn-thumbnail-preview').attr('src', attachment.url);
        });

        frame.open();
    });

    $('#atn-remove-btn').on('click', function (e) {
        e.preventDefault();
        $('#atn_thumbnail_id').val('');
        $('#atn-thumbnail-preview').attr('src', '');
    });
});
