<?php
/**
 * Alternate Thumbnail
 *
 * @package edge-expansion
 * @version: 1.0.0
 * @author EastEdge
 * @license GPL-2.0-or-later
 *
 */

if (!defined('ABSPATH')) exit;

function edgeex_alternate_thumbnail_html( $html, $post = null, $post_thumbnail_id = null, $size = 'post-thumbnail', $attr = '' ) {
	$post = get_post( $post );//Gets the current post object and sets the specified data from it to a variable. If the specified post does not exist or an error occurs, it returns null.
	if ( ! $post ) {
		return '';
	}
	$post_thumbnail_id = get_post_thumbnail_id( $post );//get_post_thumbnail_id:Gets the ID of the featured image set for the specified post ID.

	$size = apply_filters( 'post_thumbnail_size', $size, $post->ID );

	$image_option     = get_option( 'edgeex_alternate_thumbnail' );
	$image_alternate_id = ! empty( $image_option['alternate_image_id'] ) ? $image_option['alternate_image_id'] : '';
	$image_enabled = isset( $image_option['enabled'] ) ? $image_option['enabled'] : '';

	if ( ! $post_thumbnail_id) {
		if ( $image_alternate_id && !empty($image_enabled) ) {
			do_action( 'begin_fetch_post_thumbnail_html', $post->ID, $image_alternate_id, $size );//begin_fetch_post_thumbnail_html とは、ポストサムネイルHTMLを取得する前に起動します。wp_get_attachment_image() のすべてのフィルタの「ジャストインタイム」フィルタリングを提供します。
			if ( in_the_loop() ) {//Determines if the caller is in a loop.
				update_post_thumbnail_cache();//Updates the cache of thumbnails in the current loop.
			}
			$html = wp_get_attachment_image( $image_alternate_id, $size, false, $attr );//Gets HTML text of attachment information. Images are automatically resized.
			do_action( 'end_fetch_post_thumbnail_html', $post->ID, $image_alternate_id, $size );//end_fetch_post_thumbnail_html とは、ポストサムネイルHTMLを取得した後に発生します。
		} else {
			$html = '';
		}
	}
	return $html;
}
add_filter( 'post_thumbnail_html', 'edgeex_alternate_thumbnail_html', 10, 5 );

function edgeex_has_post_thumbnail( $has_thumbnail, $post = null ) {
	$thumbnail_id = get_post_thumbnail_id( $post );//Get the featured image ID

	$image_option     = get_option( 'edgeex_alternate_thumbnail' );
	$image_default_id = ! empty( $image_option['alternate_image_id'] ) ? $image_option['alternate_image_id'] : '';

	if ( $thumbnail_id ) {
		$has_thumbnail = true;
	} elseif ( $image_default_id ) {
		$has_thumbnail = true;
	} else {
		$has_thumbnail = false;
	}
	return $has_thumbnail;
}
add_filter( 'has_post_thumbnail', 'edgeex_has_post_thumbnail' );

function edgeex_change_east_components_image_alternate_url( $options ) {
    if ( edgeex_package_is_enable( 'alternate_thumbnail' ) ) {
        $image_option     = get_option( 'edgeex_alternate_thumbnail' );
        $image_alternate_id = ! empty( $image_option['alternate_image_id'] ) ? $image_option['alternate_image_id'] : '';
        if ( $image_alternate_id ) {
            $image = wp_get_attachment_image_src( $image_alternate_id, 'large', true );//$image[0]:Get only the URL from the featured image.$image[1]、$image[2]:Image size
            $options['image_alternate_url'] = $image[0];
        }
    }
    return $options;
}
add_filter( 'edgeex_post_options', 'edgeex_change_east_components_image_alternate_url' );


// Media Uploader Script Loading
add_action('admin_enqueue_scripts', function ($hook) {
    wp_register_script(
        'alternate-thumbnail-js',
        EDGEEX_PLUGIN_URL . '/inc/alternate-thumbnail/js/media-uploader.js',
        ['jquery'],
        '1.0.0',
        true
    );
    wp_enqueue_media();
    wp_enqueue_script('alternate-thumbnail-js');
});

// Settings page output
function edgeex_atn_settings_page(){

	if(isset($_POST['edgeex_alternate_thumbnail']) && check_admin_referer( 'alternate_image_action', 'alternate_image_nonce_field' )){
        $thumb_options = array(
            'alternate_image_id'  =>  isset($_POST['edgeex_alternate_thumbnail']['alternate_image_id']) ? intval( wp_unslash($_POST['edgeex_alternate_thumbnail']['alternate_image_id']) ) : '',
            'enabled' =>  isset($_POST['edgeex_alternate_thumbnail']['enabled']) ? sanitize_text_field( wp_unslash($_POST['edgeex_alternate_thumbnail']['enabled']) ) : 1,
        );
        update_option( 'edgeex_alternate_thumbnail', $thumb_options );
        echo '<div class="updated"><p>'.esc_html__('Your settings are saved.','edge-expansion').'</p></div>';
    }
        $option = get_option('edgeex_alternate_thumbnail', [
            'alternate_image_id' => '',
            'enabled' => 1
        ]);
        $image_url = $option['alternate_image_id'] ? wp_get_attachment_url($option['alternate_image_id']) : '';
    ?>
    <h3 class="subt-txt"><?php esc_html_e( 'Alternate Thumbnail', 'edge-expansion' ); ?></h3>
    <div class="wrapper">
    <table class="form-table">
    <tr>
    <th><label for="image-url">&nbsp;</label></th>
    <td>
        
        <form method="post" action="">
            <?php  
	            wp_nonce_field( 'alternate_image_action', 'alternate_image_nonce_field' );
            ?>
            <label>
            <?php if(isset($option['enabled'])):?>
                <input type="checkbox" name="edgeex_alternate_thumbnail[enabled]" value="1" <?php checked(1, $option['enabled']); ?> />
            <?php else: ?>
                <input type="checkbox" name="edgeex_alternate_thumbnail[enabled]" value="" />
            <?php endif;?>
                <?php esc_html_e( 'Enable Alternate Thumbnails', 'edge-expansion' ); ?>
            </label>
            <br><br>
            <div>
                <img id="atn-thumbnail-preview" src="<?php echo esc_url($image_url); ?>" style="max-width:200px;"><br>
                <input type="hidden" name="edgeex_alternate_thumbnail[alternate_image_id]" id="atn_thumbnail_id" value="<?php echo esc_attr($option['alternate_image_id']); ?>">
                <button type="button" class="button" id="atn-upload-btn"><?php esc_html_e( 'Choose Image', 'edge-expansion' ); ?></button>
                <button type="button" class="button" id="atn-remove-btn"><?php esc_html_e( 'Delete Image', 'edge-expansion' ); ?></button>
            </div>
            </td>
    </tr>
    <tr>
	<td colspan="2">
    <?php submit_button(); ?>
    </td>
    </tr>
    </table>
        </form>
    </div>
    <?php
}

/*
  Add setting page
/*-------------------------------------------*/

function edgeex_alternate_thumbnail_options_init() {
	$edgeex_args = array('alternate-thumbnail', __( 'Alternate Thumbnail', 'edge-expansion' ),'edgeex_alternate_thumbnail_options','edgeex_atn_settings_page');
	edgeex_argument($edgeex_args);
}
add_action( 'edgeex_component_init', 'edgeex_alternate_thumbnail_options_init' );

function edgeex_get_alternate_thumbnail_options_default() {
	$default_options = array(
        'alternate_image_id' => '',
        'enabled' => 1
	);
    return $default_options;
}

