<?php
if (!defined('ABSPATH')) exit;

function edgeex_get_components() {
	$elements = array();
	/*
	  custom post type
	/*-------------------------------------------*/
	$elements[] = array(
		'custom-post-type',
		esc_html__( 'Custom Post Type', 'edge-expansion' ),
		esc_html__( 'Add custom post types and custom taxonomies.', 'edge-expansion' ),
		admin_url() . 'admin.php?page=edgeex_cptc_form',
		false,
		'custom-post-type/custom-post-type.php',
		'block',
	);

	/*
	  latest posts Block
	/*-------------------------------------------*/
	$elements[] = array(
		'latest-posts-block',
		esc_html__( 'Latest Posts', 'edge-expansion' ),
		esc_html__( 'Display the latest posts in a list or column.', 'edge-expansion' ),
		'',
		false,
		'latest-posts-block/latest-posts-block.php',
		'block',
	);

	/*
	  relatedPosts
	/*-------------------------------------------*/
	$elements[] = array(
		'related-posts',
		esc_html__( 'Related posts', 'edge-expansion' ),
		esc_html__( 'Display a list of related posts in a list or column.', 'edge-expansion' ) .esc_html__( 'It can be inserted from the block.', 'edge-expansion' ),
		'',
		false,
		'related-posts/related-posts.php',
		'block',
		
	);

	/*
	  ChildPagesIndex
	/*-------------------------------------------*/

	$elements[] = array(
		'child-pages-index',
		esc_html__( 'Child Pages Index', 'edge-expansion' ),
		esc_html__( 'It displays a list of the child page.', 'edge-expansion' ) . esc_html__( 'It can be inserted from the block.', 'edge-expansion' ), 
		'',
		false,
		'child-pages-index/child-pages-index.php',
		'block',
	);

	/*
	  breadcrumb-trail
	/*-------------------------------------------*/
	$elements[] = array(
		'breadcrumb-trail',
		esc_html__( 'Breadcrumb', 'edge-expansion' ),
		esc_html__( 'Displays a tree-structured list of hyperlinks that point to web pages within a website.', 'edge-expansion' ),
		'',
		false,
		'breadcrumb-trail/breadcrumb-trail.php',
		'block',
	);

	
	/*
	  Page Top Button
	/*-------------------------------------------*/
	$elements[] = array(
		'button-backtotop',
		esc_html__( 'Back to Top Button ', 'edge-expansion' ),
		esc_html__( 'Display a button to return to the top of the page at the bottom right of the screen.', 'edge-expansion' ),
		admin_url() . 'admin.php?page=edgeex_add_setting_page#edgeex_backtotop_options',
		false,
		'button-backtotop/button-backtotop.php',
		'',
	);

	/*
	 Alternate thumbnail
	/*-------------------------------------------*/
	$elements[] = array(
		'alternate-thumbnail',
		esc_html__( 'Alternate thumbnail', 'edge-expansion' ),
		esc_html__( 'Set an alternative featured image for all posts that do not have an featured image set.', 'edge-expansion' ),
		admin_url() . 'admin.php?page=edgeex_add_setting_page#edgeex_alternate_thumbnail_options',
		false,
		'alternate-thumbnail/alternate-thumbnail.php',
		'',
	);

	/*
	  Smooth Scroll
	/*-------------------------------------------*/
	$elements[] = [
		'smooth-scroll',
		esc_html__( 'Smooth Scroll', 'edge-expansion' ),
		esc_html__( 'When you jump to an anchor on a page, the screen scrolls to the desired location.', 'edge-expansion' ),
		admin_url() . 'admin.php?page=edgeex_add_setting_page#edgeex_smooth_scroll_options',
		false,
		'smooth-scroll/smooth-scroll.php',
		'',
	];
	/*
	  Html Sitemap
	/*-------------------------------------------*/
	$elements[] = [
		'html-sitemap-block',
		esc_html__( 'HTML Sitemap', 'edge-expansion' ),
		esc_html__( 'A list of links within the site to help users find the page they are looking for.', 'edge-expansion' ),
		'',
		false,
		'html-sitemap-block/html-sitemap-block.php',
		'block',
	];

	/*
	  Image Deformation
	/*-------------------------------------------*/
	$elements[] = [
		'image-deformation',
		__( 'Image Deformation', 'edge-expansion' ),
		__( 'Transform images into squares, rounded corners, or circles.', 'edge-expansion' ),
		'',
		false,
		'image-deformation/image-deformation.php',
		'block',
	];

	/*
	  Button
	/*-------------------------------------------*/
	$elements[] = [
		'button-custom',
		__( 'Button', 'edge-expansion' ),
		__( 'Added the ability to change button width and color when mouse is over.', 'edge-expansion' ),
		'',
		false,
		'button-custom/button-custom.php',
		'block',
	];

	/*
	  Dashicons Text
	/*-------------------------------------------*/
	$elements[] = [
		'dashicons-text',
		__( 'Dashicons Text', 'edge-expansion' ),
		__( 'Displays Dashicons icons before or after the text.', 'edge-expansion' ),
		'',
		false,
		'dashicons-text/dashicons-text.php',
		'block',
	];

	/*
	  Definition List Block
	/*-------------------------------------------*/
	$elements[] = [
		'definition-list-block',
		__( 'Definition List', 'edge-expansion' ),
		__( 'You can create a list of definition types, which consist of a term that you define (the dt element) and a description for that term (the dd element).', 'edge-expansion' ),
		'',
		false,
		'definition-list-block/definition-list-block.php',
		'block',
	];

  return $elements;
} 

