<?php

if (!defined('ABSPATH')) exit;

require_once EDGEEX_PLUGIN_DIR . 'admin/settings/components.php';

add_action( 'init', 'edgeex_component_init' );
function edgeex_component_init() {
	if ( ! current_user_can( 'activate_plugins' ) ) {
		return;
	}
	do_action( 'edgeex_component_init' );
}

add_action( 'plugin_loaded', 'edgeex_manage_component_block_block_init' );
function edgeex_manage_component_block_block_init() {
	$db_options = get_option('edgeex_common_options');
	if ( ! empty( $db_options ) ) {
		$edgeex_options=[];
		foreach($db_options	as $key => $meta){
			if($meta == 1){
				array_push($edgeex_options,$key);
			}
		}
		$count=count($edgeex_options);
		for($i=0;$i<$count; $i++){
			$file_link = $edgeex_options[$i].'/'.$edgeex_options[$i].'.php';
			include_once EDGEEX_PLUGIN_DIR . 'inc/' .$file_link;
		}
		
	}
}

function edgeex_get_common_options() {
	$dafault = edgeex_get_common_options_default();
	$options = get_option( 'edgeex_common_options' );
	$options = wp_parse_args( $options, $dafault );
	//wp_parse_args:A generic function to combine an array of arguments and an array of default values.

	return $options;
}

function edgeex_get_common_options_default() {
	$components = edgeex_get_components();
	foreach ( $components as $value ) {
		$name  = $value[0];
		$default_options[ $name ] = $value[4];
	}
}