<?php
/*
 Main Setting Page
/*-------------------------------------------*/

if (!defined('ABSPATH')) exit;

function edgeex_manage_expansion() {
	if ( ! current_user_can( 'manage_options' ) ) {
        wp_die( esc_html__('You do not have permission.' ,'edge-expansion'));
    }
	global $edgeex_options;


?>
<div class="admin-wrapper">
<h2 class="page-title">
<?php 
	echo esc_html__( 'Edge Module settings', 'edge-expansion' ); 
?>
</h2>
<div class="admin-container">
<div class="admin-maincol">

<form method="post" action="<?php echo esc_url( admin_url('admin-post.php') ); ?>">
<?php wp_nonce_field('edgeex_mp_save_settings', 'mp_nonce'); ?>
<input type="hidden" name="action" value="edgeex_mp_save_settings">

<p>*block:<?php echo esc_html__('Module with "block" in the title are displayed using the block editor on the post screen.','edge-expansion');?></p>
<table class="wp-list-table widefat edge-settings">
	<thead>
	<tr>
		<th scope="" id="" class="">
		<input id="select-all-check" for="all" type="checkbox" /></th>
		<th><label for="all" id="all_label"></label><?php echo esc_html__( 'Select All', 'edge-expansion' ); ?></th>
		<th><?php echo esc_html__( 'Description', 'edge-expansion' ); ?></th>
		<th><?php echo esc_html__( 'Setting', 'edge-expansion' ); ?></th>
	</tr>
	</thead>
	<tbody>
		<tr>
	<?php
		$edgeex_components = edgeex_get_components();
		foreach ( $edgeex_components as $component ){
	?>
	<th scope="" class="column-check">
		<input type="checkbox" class="check" name="edgeex_common_options[<?php echo esc_attr($component[0]); ?>]" id="active_check_<?php echo esc_attr($component[0]); ?>" value="1"
		<?php
			if (isset($edgeex_options[$component[0]]) && $edgeex_options[$component[0]]==1) {echo 'checked'; }
		?>
 		/>
		</th>
		<td class="column-title">
			<label for="active_check_<?php echo esc_attr($component[0]); ?>"><div class="module-title"><?php echo esc_attr($component[1]); ?></div></label>
			<p><?php echo esc_attr($component[6]); ?></p>
			</td>
		<td class="column-description>
			<div class="setting-description">
					<p><?php echo esc_attr($component[2]); ?></p>
				</div>
			</td>
		<td>
			<?php
		if(!empty($component[3])):
		?>
		<span>
		<a href="<?php echo esc_url( $component[3] ) ? esc_url($component[3]) : esc_url(admin_url()) . 'admin.php?page=edgeex_main_setting'; ?>">
		
		<?php echo esc_html__( 'Setting', 'edge-expansion' ); ?>
		</a></span>
		<?php endif;?>
			</td>
	</tr>
	<?php } ?>
	</tbody>
	<tfoot>
	<tr>
		<th scope="" id="" class="">
		<input id="select-all-check" type="checkbox" /></th>
		<th><?php echo esc_html__( 'Select All', 'edge-expansion' ); ?></th>
		<th><?php echo esc_html__( 'Description', 'edge-expansion' ); ?></th>
		<th><?php echo esc_html__( 'Setting', 'edge-expansion' ); ?></th>

	</tr>
	</tfoot>
</table>

<?php submit_button(); ?>
</form>
</div>
</div>
</div>
<?php
}


add_action('admin_post_edgeex_mp_save_settings', function () {
    if ( ! current_user_can('manage_options') ) {
		wp_die( esc_html__('You do not have permission.' ,'edge-expansion'));
    }
    check_admin_referer('edgeex_mp_save_settings', 'mp_nonce');
	
	if(isset($_POST['edgeex_common_options']) && is_array($_POST['edgeex_common_options'])){
		$allowed_keys = array( 'alternate-thumbnail','breadcrumb-trail','button-backtotop','button-custom','child-pages-index','custom-post-type','dashicons-text','definition-list-block','html-sitemap-block','image-deformation','latest-posts-block','related-posts','smooth-scroll' );
		$options = array();
    	foreach ( $allowed_keys as $key ) {
        //Normalized to 1 if checked, 0 if not
        	$options[ $key ] = isset( $_POST['edgeex_common_options'][ $key ] ) ? 1 : 0;
    	}
		update_option( 'edgeex_common_options', $options );
	}else{
		update_option( 'edgeex_common_options', '' );
	}

    // Return when done
	wp_safe_redirect( admin_url('admin.php?page=edgeex_main_menu') );
    exit;
});

/*
 Scripts
/*-------------------------------------------*/

add_action('admin_enqueue_scripts', 'edgeex_setting_admin_scripts');
function edgeex_setting_admin_scripts() {
    wp_enqueue_script(
		'setting-admin-js',
		EDGEEX_PLUGIN_URL . '/assets/js/setting-admin.js',
		['jquery'],
		'1.0.0',
		true
	);
}
