<?php
/*
 Main Detail Setting Page
/*-------------------------------------------*/

if (!defined('ABSPATH')) exit;

function edgeex_argument($edgeex_args){
	global $edgeex_argument;
	$edgeex_argument[]=$edgeex_args;
}

function edgeex_manage_display() {
	echo '<div class="admin-wrapper">';
?>
	<h2 class="page-title"><?php echo esc_html__( 'Edge Detail Settings', 'edge-expansion' ); ?></h2>
<?php

	$db_options = get_option('edgeex_common_options');
	if(!empty($db_options)){
		edgeex_the_main_setting_tabs();
		edgeex_the_main_setting_body();
	}else{
		echo  esc_html__( 'Activated Components is nothing. please activate some component.', 'edge-expansion' );
	}
}

/*
Tab Setting Page  _ Inside the main area
/*-------------------------------------------*/
function edgeex_the_main_setting_tabs() {
	global $edgeex_argument;
	if ( is_array( $edgeex_argument ) ) {
		echo '<div class="detail-tab">'; // For first-child acquisition
		echo '<ul class="detail-menu">';
		foreach ( $edgeex_argument as $edgeoption ) {
			if ( empty( $edgeoption[3] ) ) {
				continue; 
			}
			echo  '<li id="tab-'.esc_html($edgeoption[0]).'" class="detail-item"><a href="#'.esc_html($edgeoption[0]).'">'.esc_html($edgeoption[1]).'</a></li>';
		}
		echo '</ul>';
		echo '</div>';
	} else {
		echo  esc_html__( 'Activated Components is nothing. please activate some component.', 'edge-expansion' );
	}
}


/*
 Main Setting Page  _ Inside the main area
/*-------------------------------------------*/
function edgeex_the_main_setting_body() {

	global $edgeex_argument;
	$db_options = get_option('edgeex_common_options');

	if(!empty($db_options)){
		$hash = array_flip($db_options);
		$db_data= [];
		if($db_options['alternate-thumbnail']==1){
			array_push($db_data,'alternate-thumbnail');
		}
		if($db_options['button-backtotop']==1){
			array_push($db_data,'button-backtotop');
		}
		if($db_options['smooth-scroll']==1){
			array_push($db_data,'smooth-scroll');
		}
	}
	?>
	<form method="post" action="">
	<?php
		if ( is_array( $edgeex_argument ) ) {
			echo '<div class="detail-box">'; // For first-child acquisition
			foreach ( $edgeex_argument as $edgeoption ) {
				if(in_array($edgeoption[0], $db_data)){
					echo '<div id="'.esc_html($edgeoption[0]).'" name="#'.esc_html($edgeoption[0]).'"></div>';
					echo '<div class="detail-content">';
					call_user_func_array( $edgeoption[3], array() );
					echo '</div>';
				}
			}
		}
		echo '</div>';
		echo  '</form>';
		echo '</div>';
}

/*
 Style and Scripts
/*-------------------------------------------*/

add_action('admin_init', 'edgeex_admin_menu_style');
function edgeex_admin_menu_style() {
    wp_enqueue_media();
}
function edgeex_admin_detail_enqueue() {
    wp_register_script(
        'edge-admin-detail-style',
		EDGEEX_PLUGIN_URL . '/assets/css/edge-admin-detail.css',
		array(),
        '1.0.0',
		true
	);

	wp_enqueue_style('edge-admin-detail-style');
}

add_action( 'admin_enqueue_scripts', 'edgeex_admin_detail_enqueue' );

add_action('admin_enqueue_scripts', 'edgeex_backtop_admin_scripts');
function edgeex_backtop_admin_scripts() {
	global $edgeex_options;
	if(isset($edgeex_options['button-backtotop'])){
    	wp_register_script(
        	'edge-button-admin-js',
			EDGEEX_PLUGIN_URL . '/inc/button-backtotop/js/admin.js', 
        	['jquery'],
        	'1.0.0',
        	true
    	);
    	wp_enqueue_script('edge-button-admin-js');

    	wp_register_style(
        	'edge-button-admin-css', 
			EDGEEX_PLUGIN_URL . '/inc/button-backtotop/css/check-admin.css',
        	array(), 
        	'1.0.0', 
        	'all'
    	);
		wp_enqueue_style('edge-button-admin-css');
	}
}
