<?php
if ( ! defined( 'ABSPATH' ) ) exit;
if ( ! defined( 'thpeddup-cartpopup-popup-wporg' ) ) exit;
?>

<style type="text/css">
.thpeddup-dark-overlay {
    display: block;
    position: fixed;
    top: 0%;
    left: 0%;
    width: 100%;
    height: 100%;
    background-color: #000;
    z-index: 9999998;
    -moz-opacity: 0.7;
    opacity: .70;
    filter: alpha(opacity=70);
}

.thpeddup-content-body {
    display: block;
    position: fixed;
    top: 3%;
    left: 30%;
	width: 40%;
	max-height: 95%;
    z-index: 9999999;
    overflow: auto;
    background: #fff;
	color: #333;
	border-radius: .3rem;
	/*font-family: 'Roboto', 'Lato', 'Open Sans', sans serif !important;*/
	font-weight: 300;
	font-size: 100%;
}

@media only screen and (max-width : 768px) {
	.thpeddup-content-body {
		top: 5%;
		left: 10%;
		width: 80%;
		height: 90%;
		border-radius: 3px;
	}
}

@media only screen and (max-width : 480px) {
	.thpeddup-content-body {
		top: 0%;
		left: 0%;
		width: 100%;
		height: 100%;
		border-radius: 0;
	}
}

.thpeddup-popup-container {
	padding: 0 20px 20px 20px;
	position: relative;
}

.thpeddup-popup-header {
	font-size: 14px;
    font-weight: bold;
	color: #000;
	padding-top: 15px;
	padding-bottom: 15px;
	display: flex;
	align-items: center;
}

.thpeddup-popup-line {
	border-bottom: 2px solid #eee;
	width: 100%;
	padding-bottom: 10px !important;
	display: flex;
	justify-content: flex-start;
}

.thpeddup-popup-line > a {
	margin-right: 10px;
	padding: 5px 16px;
	font-size: 14px;
	color: #fff;
	background-color: #ff4747;
	border-radius: 4px;
	text-decoration: none;
}

.thpeddup-popup-line > a:hover {
	color: #fff;
	background-color: #3590e8;
	text-decoration: none;
}

.thpeddup-popup-content {
	margin-bottom: 20px;
	font-size: 13px;
}

.thpeddup-prod-container {
	background: #f9f9f9;
	border: 1px solid #e3e3e3;
	border-radius: 5px;
}

.thpeddup-inner-popup {
	padding: 0 0 15px 0;
}

.thpeddup-spinner-container {
	display: none;
}

#thpeddup-spinner-overlay {
	position: absolute;
	top: 0;
	bottom: 0;
	left: 0;
	right: 0;
	z-index: 10000000;
	width: 100%;
	height:100%;
	background: rgba(0,0,0,0.3);
}
.thpeddup-cv-spinner {
	height: 100%;
	display: flex;
	justify-content: center;
	align-items: center;  
}
.thpeddup-spinner {
	width: 35px;
	height: 35px;
	border: 4px #fff solid;
	border-top: 4px #000 solid;
	border-radius: 50%;
	animation: sp-anime 0.8s infinite linear;
}
@keyframes sp-anime {
	0% { 
		transform: rotate(0deg); 
	}
	100% { 
		transform: rotate(359deg); 
	}
}

.thpeddup-popup-header .dashicons {
	color: #9dcc00;
	font-size: 28px;
	margin-right: 10px;
	width: auto !important;
	height: auto !important;
}

.thpeddup-popup-container .thpeddup-checkout-form .thpeddup-display-right .thpeddup-atc-btn {
	padding: 20px 30px;
}

.thpeddup-popup-container .thpeddup-upcross-display-container {
	padding: 3px;
}

a#thpeddup-close-id {
	text-decoration: none;
}

.thpeddup-popup-close {
	position: absolute;
	right: 15px;
	top: 10px;
	width: 20px;
	height: 20px;
	opacity: 0.3;
}

.thpeddup-popup-close:hover {
	opacity: 1;
}

.thpeddup-popup-close:before, .thpeddup-popup-close:after {
	position: absolute;
	left: 15px;
	content: ' ';
	height: 15px;
	width: 3px;
	background-color: #333;
}

.thpeddup-popup-close:before {
	transform: rotate(45deg);
}

.thpeddup-popup-close:after {
	transform: rotate(-45deg);
}
</style>

<div class="thpeddup-dark-overlay"></div>

<div class="thpeddup-content-body">

		<div class="thpeddup-popup-container">
			
			<a href="#" id="thpeddup-close-id" class="thpeddup-popup-close"></a>
			
		    <div class="thpeddup-popup-header">
				<span class="dashicons dashicons-yes-alt"></span>
				<?php _e( "A new item has been added to your cart.", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?>
			</div>
			
			<div class="thpeddup-popup-line">
				<a href="#" class="thpeddup-continue-shopping-btn"><?php _e( "Continue Shopping", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></a>
				<a href="<?php echo edd_get_checkout_uri(); ?>"><?php _e( "Checkout", 'edd-upsell-cross-sell-in-cart-and-popup' ); ?></a>
			</div>
			
			<div class="thpeddup-inner-popup">
				<div class="thpeddup-popup-header">
					<?php
					if (thpeddup_edduppro_is_active() && thpeddup_pro_prosettings_is_active()) {
						$thpeddup_pro_options = ( !empty(get_option( 'thpeddup_pro_options' )) ? get_option( 'thpeddup_pro_options' ) : '' );
						$popup_heading = ( !empty($thpeddup_pro_options['popup_heading']) ? $thpeddup_pro_options['popup_heading'] : '' );
						
						if (!$popup_heading)
							$popup_heading = get_post_meta($product_id, 'thpeddup_popup_heading', true);
					}
					else {
						$popup_heading = get_post_meta($product_id, 'thpeddup_popup_heading', true);
					}
					
					if ($popup_heading)
						echo esc_html($popup_heading);
					else
						_e( "Recommended for you:", 'edd-upsell-cross-sell-in-cart-and-popup' );
					?>
				</div>
				
				<div class="thpeddup-popup-content">
					<div class="thpeddup-prod-container">
					
						<?php
						foreach ($upcrossitems_IDs as $upcrossitem_ID) { ?>
						
						<div class="thpeddup-upcross-display-container">
						
						<div class="thpeddup-display-left">
							<div class="thpeddup-left-left">
								<a href="<?php echo get_permalink( $upcrossitem_ID ); ?>">
								<?php 
								if ( has_post_thumbnail( $upcrossitem_ID ) )
									echo get_the_post_thumbnail( $upcrossitem_ID, array( 50, 50) );
								else
									echo '<img src="'.plugin_dir_url( __DIR__ ).'images/download_icon_default.png" alt="thumbnail" style="width:50px;" />';
								?>
								</a>
								<a href="<?php echo get_permalink( $upcrossitem_ID ); ?>"><?php echo get_the_title( $upcrossitem_ID ); ?></a>
							</div>
							<div class="thpeddup-popup-price-wrap">
								<?php 
								if ( edd_has_variable_prices( $upcrossitem_ID ) ) {
									$prices = edd_get_variable_prices( $upcrossitem_ID );
									if( $prices ) {
										echo '<select id="thpeddup-popup-select-priceid">';
										foreach( $prices as $price_id => $price ) {
											echo '<option value="'.$price_id.'">' . $price['name'] . ' : ' . edd_currency_filter($price['amount']) . '</option>';
										}
										echo '</select>';
									}
								}
								else {
									edd_price( $upcrossitem_ID );
								}
								?>
							</div>
						</div>
						
						<form class="thpeddup-checkout-form" method=post>
							<div class="thpeddup-display-right">
								<div class="thpeddup-spinner-container">
									<div id="thpeddup-spinner-overlay">
										<div class="thpeddup-cv-spinner">
											<span class="thpeddup-spinner"></span>
										</div>
									</div>
								</div>
								<input class="thpeddup-atc-btn" name="thpeddup-atc-btn" type="submit" value="" />
								<input class="thpeddup-hidden-upcross-id" name="thpeddup-hidden-upcross-id" type="hidden" value="<?php echo esc_attr($upcrossitem_ID); ?>">
							</div>
						</form>
						
					</div><!-- .thpeddup-upcross-display-container -->
					<?php
					} ?>
					
					</div>
				</div>
			</div>
		</div>
		
</div><!-- .thpeddup-content-body -->